/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import jm.midi.MidiInputListener;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public class RTMidiIn
implements Receiver {
    private int oldStatus;
    private Vector listeners = new Vector();
    private Transmitter trans = null;

    public RTMidiIn() {
        this.init();
    }

    public void addMidiInputListener(MidiInputListener midiInputListener) {
        this.listeners.add(midiInputListener);
    }

    public void notifyListeners(Event event) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((MidiInputListener)enumeration.nextElement()).newEvent(event);
        }
    }

    @Override
    public void send(MidiMessage midiMessage, long l) {
        System.out.println("New MIDI message");
        Event event = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(midiMessage.getMessage());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            dataInputStream.mark(2);
            int n = dataInputStream.readUnsignedByte();
            int n2 = 0;
            if (n < 128) {
                n = this.oldStatus;
                dataInputStream.reset();
            }
            if (n >= 255) {
                int n3 = dataInputStream.readUnsignedByte();
                n2 = MidiUtil.readVarLength(dataInputStream);
                event = MidiUtil.createMetaEvent(n3);
            } else if (n >= 240) {
                System.out.println("SysEX---");
                n2 = MidiUtil.readVarLength(dataInputStream);
            } else if (n >= 128) {
                short s = (short)(n / 16);
                short s2 = (short)(n - s * 16);
                VoiceEvt voiceEvt = (VoiceEvt)MidiUtil.createVoiceEvent(s);
                voiceEvt.setMidiChannel(s2);
                event = voiceEvt;
                if (event == null) {
                    throw new IOException("Read Error");
                }
            }
            if (event != null) {
                event.setTime((int)l);
                event.read(dataInputStream);
            }
            this.oldStatus = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.notifyListeners(event);
    }

    @Override
    public void close() {
        this.trans.close();
    }

    private boolean init() {
        if (this.trans == null) {
            try {
                if (MidiSystem.getReceiver() == null) {
                    System.err.println("MidiSystem Receiver Unavailable");
                    return false;
                }
                MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
                for (int i = 0; i < infoArray.length; ++i) {
                    System.out.println(infoArray[i]);
                }
                this.trans = MidiSystem.getTransmitter();
                this.trans.setReceiver(this);
            }
            catch (MidiUnavailableException midiUnavailableException) {
                System.err.println("Midi System Unavailable:" + midiUnavailableException);
                return false;
            }
        }
        return true;
    }
}

