/*
 * Decompiled with CFR 0.152.
 */
package jm.midi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.midi.MidiUtil;
import jm.midi.Track;
import jm.midi.event.EndTrack;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class SMF
implements JMC {
    private short fileType;
    private short numOfTracks;
    private int numOfBytes;
    private short ppqn;
    private Vector trackList;
    private boolean VERBOSE = false;

    public SMF() {
        this(1, 480);
    }

    public SMF(short s, short s2) {
        this.fileType = s;
        this.ppqn = s2;
        this.numOfBytes = 0;
        this.numOfTracks = 0;
        this.trackList = new Vector();
    }

    public void setVerbose(boolean bl) {
        this.VERBOSE = bl;
    }

    public Vector getTrackList() {
        return this.trackList;
    }

    public short getPPQN() {
        return this.ppqn;
    }

    public void clearTracks() {
        if (!this.trackList.isEmpty()) {
            this.trackList.removeAllElements();
        }
    }

    public void read(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        if (!this.trackList.isEmpty()) {
            this.trackList.removeAllElements();
        }
        if (dataInputStream.readInt() != 1297377380) {
            throw new IOException("This is NOT a MIDI file !!!");
        }
        dataInputStream.readInt();
        try {
            this.fileType = dataInputStream.readShort();
            if (this.VERBOSE) {
                System.out.println("MIDI file type = " + this.fileType);
            }
            this.numOfTracks = dataInputStream.readShort();
            if (this.VERBOSE) {
                System.out.println("Number of tracks = " + this.numOfTracks);
            }
            this.ppqn = dataInputStream.readShort();
            if (this.VERBOSE) {
                System.out.println("ppqn = " + this.ppqn);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
        }
        for (int i = 0; i < this.numOfTracks; ++i) {
            this.readTrackChunk(dataInputStream);
        }
        inputStream.close();
        dataInputStream.close();
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.numOfTracks = (short)this.trackList.size();
        try {
            dataOutputStream.writeInt(1297377380);
            dataOutputStream.writeInt(6);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(this.numOfTracks);
            dataOutputStream.writeShort(this.ppqn);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Enumeration enumeration = this.trackList.elements();
        while (enumeration.hasMoreElements()) {
            Track track = (Track)enumeration.nextElement();
            this.writeTrackChunk(dataOutputStream, track);
        }
        outputStream.flush();
        outputStream.close();
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    public void print() {
        Enumeration enumeration = this.trackList.elements();
        while (enumeration.hasMoreElements()) {
            Track track = (Track)enumeration.nextElement();
            track.print();
        }
    }

    private void skipATrack(RandomAccessFile randomAccessFile) throws IOException {
        if (this.VERBOSE) {
            System.out.println("Skipping the tempo track . . .");
        }
        randomAccessFile.readInt();
        randomAccessFile.skipBytes(randomAccessFile.readInt());
    }

    private void readTrackChunk(DataInputStream dataInputStream) throws IOException {
        Track track = new Track();
        this.trackList.addElement(track);
        int n = 0;
        if (this.VERBOSE) {
            System.out.println("Reading Track ..........");
        }
        if (dataInputStream.readInt() != 1297379947) {
            throw new IOException("Track started in wrong place!!!!  ABORTING");
        }
        dataInputStream.readInt();
        int n2 = 0;
        int n3 = 0;
        Event event = null;
        while (true) {
            try {
                n = MidiUtil.readVarLength(dataInputStream);
                dataInputStream.mark(2);
                int n4 = dataInputStream.readUnsignedByte();
                if (n4 < 128) {
                    n4 = n2;
                    dataInputStream.reset();
                }
                if (n4 >= 255) {
                    int n5 = dataInputStream.readUnsignedByte();
                    n3 = MidiUtil.readVarLength(dataInputStream);
                    event = MidiUtil.createMetaEvent(n5);
                } else if (n4 >= 240) {
                    System.out.println("SysEX---");
                    n3 = MidiUtil.readVarLength(dataInputStream);
                } else if (n4 >= 128) {
                    short s = (short)(n4 / 16);
                    short s2 = (short)(n4 - s * 16);
                    VoiceEvt voiceEvt = (VoiceEvt)MidiUtil.createVoiceEvent(s);
                    voiceEvt.setMidiChannel(s2);
                    event = voiceEvt;
                    if (event == null) {
                        throw new IOException("MIDI file read error: invalid voice event type!");
                    }
                }
                n2 = n4;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
            if (event != null) {
                event.setTime(n);
                event.read(dataInputStream);
                track.addEvent(event);
                if (!(event instanceof EndTrack)) continue;
                break;
            }
            dataInputStream.skipBytes(n3);
        }
    }

    private void writeTrackChunk(DataOutputStream dataOutputStream, Track track) throws IOException {
        if (this.VERBOSE) {
            System.out.println("Writing MIDI Track");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        int n = 1297379947;
        Enumeration enumeration = track.getEvtList().elements();
        enumeration = track.getEvtList().elements();
        while (enumeration.hasMoreElements()) {
            Event event = (Event)enumeration.nextElement();
            event.write(dataOutputStream2);
        }
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(byteArrayOutputStream.size());
        dataOutputStream.write(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
    }
}

