/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;
import jm.midi.event.VoiceEvt;

public final class PChange
implements VoiceEvt,
Cloneable {
    private final short id = (short)7;
    private short value;
    private short midiChannel;
    private int time;

    public PChange() {
        this.value = 0;
        this.midiChannel = 0;
        this.time = 0;
    }

    public PChange(short s, short s2, int n) {
        this.value = s;
        this.midiChannel = s2;
        this.time = n;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short s) {
        this.value = s;
    }

    @Override
    public short getMidiChannel() {
        return this.midiChannel;
    }

    @Override
    public void setMidiChannel(short s) {
        this.midiChannel = s;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int n) {
        this.time = n;
    }

    @Override
    public short getID() {
        return 7;
    }

    @Override
    public int write(DataOutputStream dataOutputStream) throws IOException {
        int n = MidiUtil.writeVarLength(this.time, dataOutputStream);
        dataOutputStream.writeByte((byte)(192 + this.midiChannel));
        dataOutputStream.writeByte((byte)this.value);
        return n + 2;
    }

    @Override
    public int read(DataInputStream dataInputStream) throws IOException {
        this.value = (short)dataInputStream.readUnsignedByte();
        return 1;
    }

    @Override
    public Event copy() throws CloneNotSupportedException {
        PChange pChange;
        try {
            pChange = (PChange)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            pChange = new PChange();
        }
        return pChange;
    }

    @Override
    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return new String("Program Change(007): [time = " + this.time + "][midiChannel = " + this.midiChannel + "][value = " + this.value + "]");
    }
}

