/*
 * Decompiled with CFR 0.152.
 */
package jm.midi.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jm.midi.MidiUtil;
import jm.midi.event.Event;

public final class TimeSig
implements Event {
    public static final short ID = 17;
    private int time;
    private int numerator;
    private int denominator;
    private int metronomePulse;
    private int thirtySecondNotesPerBeat;

    public TimeSig() {
        this(0, 4, 4);
    }

    public TimeSig(int n, int n2) {
        this(0, n, n2);
    }

    public TimeSig(int n, int n2, int n3) {
        this.time = n;
        this.numerator = n2;
        this.denominator = n3;
        this.metronomePulse = 24;
        this.thirtySecondNotesPerBeat = 32;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int n) {
        this.denominator = n;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int n) {
        this.numerator = n;
    }

    public int getMetronomePulse() {
        return this.metronomePulse;
    }

    public void setMetronomePulse(int n) {
        this.metronomePulse = n;
    }

    public int getThirtySecondNotesPerBeat() {
        return this.thirtySecondNotesPerBeat;
    }

    public void setThirtySecondNotesPerBeat(int n) {
        this.thirtySecondNotesPerBeat = n;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int n) {
        this.time = n;
    }

    @Override
    public short getID() {
        return 17;
    }

    @Override
    public int write(DataOutputStream dataOutputStream) throws IOException {
        int n = MidiUtil.writeVarLength(this.time, dataOutputStream);
        dataOutputStream.writeByte(255);
        dataOutputStream.writeByte(88);
        n += MidiUtil.writeVarLength(4, dataOutputStream);
        dataOutputStream.writeByte((byte)this.numerator);
        int n2 = this.denominator;
        int n3 = 0;
        while (n2 % 2 == 0) {
            n2 /= 2;
            ++n3;
        }
        dataOutputStream.writeByte((byte)n3);
        dataOutputStream.writeByte(24);
        dataOutputStream.writeByte(8);
        return n + 6;
    }

    @Override
    public int read(DataInputStream dataInputStream) throws IOException {
        this.numerator = (short)dataInputStream.readUnsignedByte();
        short s = (short)dataInputStream.readUnsignedByte();
        this.denominator = 1 << s;
        this.metronomePulse = dataInputStream.readUnsignedByte();
        this.thirtySecondNotesPerBeat = dataInputStream.readUnsignedByte();
        return 4;
    }

    @Override
    public Event copy() throws CloneNotSupportedException {
        TimeSig timeSig;
        try {
            timeSig = (TimeSig)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println(cloneNotSupportedException);
            timeSig = new TimeSig();
        }
        return timeSig;
    }

    @Override
    public void print() {
        System.out.println("TimeSig(021):             [time = " + this.time + "][numerator = " + this.numerator + "][denominator = " + this.denominator + "]");
    }
}

