/*
 * Decompiled with CFR 0.152.
 */
package jm.music.rt;

import jm.audio.AOException;
import jm.audio.AudioChainListener;
import jm.audio.Instrument;
import jm.audio.RTMixer;
import jm.music.data.Note;

public abstract class RTLine
implements AudioChainListener {
    protected Instrument[] inst;
    protected boolean clear = false;
    private double localCounter = 0.0;
    private boolean newNote = true;
    private double tempo = 60.0;
    private double testPos;
    private double size;
    Note note = null;
    double scorePos = 0.0;
    double temp = 1.0;

    public RTLine(Instrument[] instrumentArray) {
        int n;
        this.inst = instrumentArray;
        for (n = 0; n < instrumentArray.length; ++n) {
            instrumentArray[n].addRTLine(this);
        }
        n = instrumentArray[0].getSampleRate();
        int n2 = instrumentArray[0].getChannels();
        for (int i = 0; i < instrumentArray.length; ++i) {
            if (instrumentArray[i].getSampleRate() != n) {
                System.err.println("jMusic RTLine error: All instruments must have the same sample rate.");
                System.exit(0);
            }
            if (instrumentArray[i].getChannels() == n2) continue;
            System.err.println("jMusic RTLine error: All instruments must have the same number of channels.");
            System.exit(0);
        }
        this.size = n * n2;
    }

    public Instrument[] getInstrument() {
        return this.inst;
    }

    public int getNumLines() {
        return this.inst.length;
    }

    public void setTempo(double d) {
        this.tempo = d;
    }

    public void setBufferSize(int n) {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].setBufSize(n);
        }
    }

    public int getSampleRate() {
        return this.inst[0].getSampleRate();
    }

    public int getChannels() {
        return this.inst[0].getChannels();
    }

    public void externalAction(Object object, int n) {
    }

    @Override
    public synchronized void controlChange(float[] fArray, int n, boolean bl) {
    }

    public void instNote(Instrument instrument, long l) {
        this.scorePos = (double)l / this.size;
        this.temp = 60.0 / this.tempo;
        if (this.scorePos > this.testPos) {
            this.note = this.getNextNote().copy();
            this.note.setRhythmValue(this.note.getRhythmValue() * this.temp);
            this.note.setDuration(this.note.getDuration() * this.temp);
            this.testPos += this.note.getRhythmValue();
        } else {
            this.note = new Note(Integer.MIN_VALUE, this.testPos - this.scorePos);
            this.note.setRhythmValue(this.note.getRhythmValue() * this.temp);
            this.note.setDuration(this.note.getRhythmValue());
        }
        instrument.renderNote(this.note, this.scorePos);
    }

    public void start(RTMixer rTMixer) {
        for (int i = 0; i < this.inst.length; ++i) {
            try {
                if (!this.inst[i].getInitialised()) {
                    this.inst[i].createChain();
                    this.inst[i].setInitialised(true);
                }
                this.inst[i].addAudioChainListener(rTMixer);
                this.inst[i].start();
                continue;
            }
            catch (AOException aOException) {
                System.err.println("jMusic RTLine start error: Perhpas a jMusic instrument was being reused.");
                aOException.printStackTrace();
            }
        }
    }

    public void pause() {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].pause();
        }
    }

    public void unPause() {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].unPause();
        }
    }

    public void stop() {
        for (int i = 0; i < this.inst.length; ++i) {
            this.inst[i].stop();
        }
    }

    public abstract Note getNextNote();
}

