/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.PhraseAnalysis;

public final class ChordAnalysis {
    public static final int[] RATINGS = new int[]{1, 4, 4, 3, 2, 5, 7};

    private ChordAnalysis() {
    }

    public static Possible[] getChords(Phrase phrase, double d, int n, int[] nArray) {
        int[][] nArray2 = new int[nArray.length][3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i][0] = nArray[i];
            nArray2[i][1] = nArray[(i + 2) % nArray.length];
            nArray2[i][2] = nArray[(i + 4) % nArray.length];
        }
        double d2 = phrase.getStartTime();
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        double d3 = 0.0;
        int n2 = 0;
        double d4 = phrase.getEndTime();
        if (d4 == 0.0) {
            return new Possible[0];
        }
        Note note = new Note();
        Note note2 = new Note();
        int n3 = phrase.size();
        Possible[] possibleArray = new Possible[(int)Math.ceil(d4 / d)];
        int n4 = 0;
        block1: for (n4 = 0; n4 < possibleArray.length; ++n4) {
            note = d3 == (double)n4 * d ? phrase.getNote(n2) : null;
            while (d3 < ((double)n4 + 0.5) * d) {
                d3 += phrase.getNote(n2).getRhythmValue();
                if (++n2 < n3) continue;
                note2 = null;
                break block1;
            }
            note2 = d3 == ((double)n4 + 0.5) * d ? phrase.getNote(n2) : null;
            while (d3 < (double)(n4 + 1) * d) {
                d3 += phrase.getNote(n2).getRhythmValue();
                if (++n2 < n3) continue;
                break block1;
            }
            possibleArray[n4] = ChordAnalysis.firstPass(note, note2, n, nArray, nArray2);
        }
        possibleArray[n4] = ChordAnalysis.firstPass(note, note2, n, nArray, nArray2);
        return possibleArray;
    }

    public static int[] getFirstPassChords(Phrase phrase, double d, int n, int[] nArray) {
        Possible[] possibleArray = ChordAnalysis.getChords(phrase, d, n, nArray);
        int[] nArray2 = new int[possibleArray.length];
        for (int i = 0; i < possibleArray.length; ++i) {
            nArray2[i] = possibleArray[i] != null ? possibleArray[i].getBestChord() : 7;
        }
        return nArray2;
    }

    public static int[] getSecondPassChords(Phrase phrase, double d, int n, int[] nArray) {
        Possible[] possibleArray = ChordAnalysis.getChords(phrase, d, n, nArray);
        int[] nArray2 = new int[possibleArray.length];
        int n2 = possibleArray.length - 1;
        if (n2 < 0) {
            return new int[0];
        }
        while (possibleArray[n2] == null) {
            nArray2[n2] = 7;
            if (--n2 >= 0) continue;
            return nArray2;
        }
        nArray2[n2] = possibleArray[n2].getBestChord();
        int n3 = nArray2[n2];
        --n2;
        block1: while (n2 > 0) {
            while (possibleArray[n2] == null) {
                nArray2[n2] = 7;
                if (--n2 >= 1) continue;
                break block1;
            }
            int n4 = (n3 + 4) % nArray.length;
            nArray2[n2] = ChordAnalysis.acceptableChange(possibleArray[n2].chords, n4, possibleArray[n2].getBestChord()) ? n4 : possibleArray[n2].getBestChord();
            n3 = nArray2[n2];
            --n2;
        }
        nArray2[0] = possibleArray[0] == null ? 7 : possibleArray[0].getBestChord();
        return nArray2;
    }

    private static boolean acceptableChange(int[] nArray, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n || RATINGS[nArray[i]] > 2 + RATINGS[n2]) continue;
            return true;
        }
        return false;
    }

    private static Possible firstPass(Note note, Note note2, int n, int[] nArray, int[][] nArray2) {
        if (ChordAnalysis.isBad(note, n, nArray)) {
            if (ChordAnalysis.isBad(note2, n, nArray)) {
                return null;
            }
            return ChordAnalysis.firstPassChords(note2, n, nArray, nArray2);
        }
        if (ChordAnalysis.isBad(note2, n, nArray)) {
            return ChordAnalysis.firstPassChords(note, n, nArray, nArray2);
        }
        if (PhraseAnalysis.pitchToDegree(note.getPitch(), n) == PhraseAnalysis.pitchToDegree(note2.getPitch(), n)) {
            return ChordAnalysis.firstPassChords(note, n, nArray, nArray2);
        }
        return ChordAnalysis.firstPassChords(note, note2, n, nArray, nArray2);
    }

    private static boolean isBad(Note note, int n, int[] nArray) {
        if (note == null) {
            return true;
        }
        if (note.getPitch() == Integer.MIN_VALUE) {
            return true;
        }
        return !PhraseAnalysis.isScale(note, n, nArray);
    }

    private static Possible firstPassChords(Note note, int n, int[] nArray, int[][] nArray2) {
        Possible possible = new Possible(new int[3]);
        int n2 = 0;
        int n3 = PhraseAnalysis.pitchToDegree(note.getPitch(), n);
        for (int i = 0; i < nArray2.length; ++i) {
            if (!ChordAnalysis.isInTriad(n3, nArray2[i])) continue;
            possible.chords[n2++] = i;
        }
        return possible;
    }

    private static Possible firstPassChords(Note note, Note note2, int n, int[] nArray, int[][] nArray2) {
        Possible possible = ChordAnalysis.firstPassChords(note, n, nArray, nArray2);
        Possible possible2 = ChordAnalysis.firstPassChords(note2, n, nArray, nArray2);
        Possible possible3 = ChordAnalysis.findCommonChords(possible.chords, possible2.chords);
        return possible3 == null ? possible : possible3;
    }

    private static boolean isInTriad(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private static Possible findCommonChords(int[] nArray, int[] nArray2) {
        Possible possible = new Possible(new int[2]);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] != nArray2[j]) continue;
                possible.chords[n++] = nArray[i];
            }
        }
        if (n == 0) {
            return null;
        }
        if (n == 2) {
            return possible;
        }
        if (n == 1) {
            int[] nArray3 = new int[]{possible.chords[0]};
            return new Possible(nArray3);
        }
        throw new Error("Unexpected value for index");
    }

    private static class Possible {
        int[] chords = null;

        Possible() {
        }

        Possible(int[] nArray) {
            this.chords = nArray;
        }

        int getBestChord() {
            if (this.chords == null) {
                return -1;
            }
            int n = 6;
            for (int i = 0; i < this.chords.length; ++i) {
                if (RATINGS[this.chords[i]] >= RATINGS[n]) continue;
                n = this.chords[i];
            }
            return n;
        }
    }
}

