/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import java.util.Hashtable;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.NoteListException;
import jm.music.tools.QuantisationException;

public final class PhraseAnalysis {
    public static final String[] featureNames = new String[]{"01 - Pitch Variety", "02 - Pitch Range", "03 - Key Centeredness", "04 - Tonal Deviation", "05 - Dissonance", "06 - Overall Pitch Direction", "07 - Melodic Direction Stability", "08 - Pitch Movement By Tonal Step", "09 - Leap Compensation", "10 - Climax Strength", "11 - Climax Position", "12 - Climax Tonality", "13 - Note Density", "14 - Rest Density", "15 - Rhythmic Variety", "16 - Rhythmic Range", "17 - Syncopation", "18 - Repeated Pitch Density", "19 - Repeated Rhythmic Value Density", "20 - Repeated Pitch Patterns Of Three", "21 - Repeated Pitch Patterns Of Four", "22 - Repeated Rhythm Patterns Of Three", "23 - Repeated Rhythm Patterns Of Four"};
    public static final String NOTELIST_EXCEPTION_STRING = "NoteListException";
    public static final String QUANTISATION_EXCEPTION_STRING = "QuantisationException";
    public static final double NOTELIST_EXCEPTION_CONSTANT = -1.0;
    public static final double QUANTISATION_EXCEPTION_CONSTANT = -2.0;
    public static final int FEATURE_COUNT = 23;
    public static final int MAX_PITCH_RANGE = 24;
    public static final double MAX_RHYTHM_RANGE = 16.0;
    public static final int[] MAJOR_SCALE = new int[]{0, 2, 4, 5, 7, 9, 11};
    public static final int[] MINOR_SCALE = new int[]{0, 2, 3, 5, 7, 8, 10};
    public static final int[] PRIMARY_NOTES = new int[]{0, 7};
    public static final int BIG_JUMP_INTERVAL = 8;
    public static final int MAX_DISTINCT_RHYTHMS = 16;
    public static final int INTERVAL_WITH_REST = 255;
    private static final int[] GOOD_INTERVALS = new int[]{0, 1, 2, 3, 4, 5, 7, 8, 9, 12};
    private static final int[] BAD_INTERVALS = new int[]{6, 11};
    private static final int SEMITONES_PER_OCTAVE = 12;

    private PhraseAnalysis() {
    }

    public static String[] getAllStatisticsAsStrings(Phrase phrase, double d, int n, int[] nArray) {
        return PhraseAnalysis.getAllStatisticsAsStrings(phrase.getNoteArray(), d, n, nArray);
    }

    public static String[] getAllStatisticsAsStrings(Note[] noteArray, double d, int n, int[] nArray) {
        String[] stringArray = new String[23];
        try {
            stringArray[0] = Double.toString(PhraseAnalysis.pitchVariety(noteArray));
        }
        catch (NoteListException noteListException) {
            stringArray[0] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[1] = Double.toString(PhraseAnalysis.pitchRangePerSpan(noteArray));
        }
        catch (NoteListException noteListException) {
            stringArray[1] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[2] = Double.toString(PhraseAnalysis.keyCenteredness(noteArray, d, n));
        }
        catch (NoteListException noteListException) {
            stringArray[2] = NOTELIST_EXCEPTION_STRING;
        }
        catch (QuantisationException quantisationException) {
            stringArray[2] = QUANTISATION_EXCEPTION_STRING;
        }
        try {
            stringArray[3] = Double.toString(PhraseAnalysis.tonalDeviation(noteArray, d, n, nArray));
        }
        catch (NoteListException noteListException) {
            stringArray[3] = NOTELIST_EXCEPTION_STRING;
        }
        catch (QuantisationException quantisationException) {
            stringArray[3] = QUANTISATION_EXCEPTION_STRING;
        }
        stringArray[4] = Double.toString(PhraseAnalysis.dissonance(noteArray));
        stringArray[5] = Double.toString(PhraseAnalysis.overallPitchDirection(noteArray));
        try {
            stringArray[6] = Double.toString(PhraseAnalysis.melodicDirectionStability(noteArray));
        }
        catch (NoteListException noteListException) {
            stringArray[6] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[7] = Double.toString(PhraseAnalysis.movementByStep(noteArray, n, nArray));
        }
        catch (NoteListException noteListException) {
            stringArray[7] = NOTELIST_EXCEPTION_STRING;
        }
        stringArray[8] = Double.toString(PhraseAnalysis.leapCompensation(noteArray));
        try {
            stringArray[9] = Double.toString(PhraseAnalysis.climaxStrength(noteArray));
        }
        catch (NoteListException noteListException) {
            stringArray[9] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[10] = Double.toString(PhraseAnalysis.climaxPosition(noteArray));
        }
        catch (NoteListException noteListException) {
            stringArray[10] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[11] = Double.toString(PhraseAnalysis.climaxTonality(noteArray, n, nArray));
        }
        catch (NoteListException noteListException) {
            stringArray[11] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[12] = Double.toString(PhraseAnalysis.noteDensity(noteArray, d));
        }
        catch (NoteListException noteListException) {
            stringArray[12] = NOTELIST_EXCEPTION_STRING;
        }
        catch (QuantisationException quantisationException) {
            stringArray[12] = QUANTISATION_EXCEPTION_STRING;
        }
        try {
            stringArray[13] = Double.toString(PhraseAnalysis.noteDensity(noteArray, d));
        }
        catch (NoteListException noteListException) {
            stringArray[13] = NOTELIST_EXCEPTION_STRING;
        }
        catch (QuantisationException quantisationException) {
            stringArray[13] = QUANTISATION_EXCEPTION_STRING;
        }
        stringArray[14] = Double.toString(PhraseAnalysis.rhythmicVariety(noteArray));
        try {
            stringArray[15] = Double.toString(PhraseAnalysis.rhythmRangePerSpan(noteArray));
        }
        catch (NoteListException noteListException) {
            stringArray[15] = NOTELIST_EXCEPTION_STRING;
        }
        stringArray[16] = Double.toString(PhraseAnalysis.syncopation(noteArray));
        try {
            stringArray[17] = Double.toString(PhraseAnalysis.repeatedPitchDensity(noteArray));
        }
        catch (NoteListException noteListException) {
            stringArray[17] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[18] = Double.toString(PhraseAnalysis.repeatedRhythmicValueDensity(noteArray));
        }
        catch (NoteListException noteListException) {
            stringArray[18] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[19] = Double.toString(PhraseAnalysis.repeatedPitchPatterns(noteArray, 3));
        }
        catch (NoteListException noteListException) {
            stringArray[19] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[20] = Double.toString(PhraseAnalysis.repeatedPitchPatterns(noteArray, 4));
        }
        catch (NoteListException noteListException) {
            stringArray[20] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[21] = Double.toString(PhraseAnalysis.repeatedRhythmPatterns(noteArray, 3));
        }
        catch (NoteListException noteListException) {
            stringArray[21] = NOTELIST_EXCEPTION_STRING;
        }
        try {
            stringArray[22] = Double.toString(PhraseAnalysis.repeatedRhythmPatterns(noteArray, 4));
        }
        catch (NoteListException noteListException) {
            stringArray[22] = NOTELIST_EXCEPTION_STRING;
        }
        return stringArray;
    }

    public static double[] getAllStatisticsAsDoubles(Phrase phrase, double d, int n, int[] nArray) {
        return PhraseAnalysis.getAllStatisticsAsDoubles(phrase.getNoteArray(), d, n, nArray);
    }

    public static double[] getAllStatisticsAsDoubles(Note[] noteArray, double d, int n, int[] nArray) {
        double[] dArray = new double[23];
        try {
            dArray[0] = PhraseAnalysis.pitchVariety(noteArray);
        }
        catch (NoteListException noteListException) {
            dArray[0] = -1.0;
        }
        try {
            dArray[1] = PhraseAnalysis.pitchRangePerSpan(noteArray);
        }
        catch (NoteListException noteListException) {
            dArray[1] = -1.0;
        }
        try {
            dArray[2] = PhraseAnalysis.keyCenteredness(noteArray, d, n);
        }
        catch (NoteListException noteListException) {
            dArray[2] = -1.0;
        }
        catch (QuantisationException quantisationException) {
            dArray[2] = -2.0;
        }
        try {
            dArray[3] = PhraseAnalysis.tonalDeviation(noteArray, d, n, nArray);
        }
        catch (NoteListException noteListException) {
            dArray[3] = -1.0;
        }
        catch (QuantisationException quantisationException) {
            dArray[3] = -2.0;
        }
        dArray[4] = PhraseAnalysis.dissonance(noteArray);
        dArray[5] = PhraseAnalysis.overallPitchDirection(noteArray);
        try {
            dArray[6] = PhraseAnalysis.melodicDirectionStability(noteArray);
        }
        catch (NoteListException noteListException) {
            dArray[6] = -1.0;
        }
        try {
            dArray[7] = PhraseAnalysis.movementByStep(noteArray, n, nArray);
        }
        catch (NoteListException noteListException) {
            dArray[7] = -1.0;
        }
        dArray[8] = PhraseAnalysis.leapCompensation(noteArray);
        try {
            dArray[9] = PhraseAnalysis.climaxStrength(noteArray);
        }
        catch (NoteListException noteListException) {
            dArray[9] = -1.0;
        }
        try {
            dArray[10] = PhraseAnalysis.climaxPosition(noteArray);
        }
        catch (NoteListException noteListException) {
            dArray[10] = -1.0;
        }
        try {
            dArray[11] = PhraseAnalysis.climaxTonality(noteArray, n, nArray);
        }
        catch (NoteListException noteListException) {
            dArray[11] = -1.0;
        }
        try {
            dArray[12] = PhraseAnalysis.noteDensity(noteArray, d);
        }
        catch (NoteListException noteListException) {
            dArray[12] = -1.0;
        }
        catch (QuantisationException quantisationException) {
            dArray[12] = -2.0;
        }
        try {
            dArray[13] = PhraseAnalysis.noteDensity(noteArray, d);
        }
        catch (NoteListException noteListException) {
            dArray[13] = -1.0;
        }
        catch (QuantisationException quantisationException) {
            dArray[13] = -2.0;
        }
        dArray[14] = PhraseAnalysis.rhythmicVariety(noteArray);
        try {
            dArray[15] = PhraseAnalysis.rhythmRangePerSpan(noteArray);
        }
        catch (NoteListException noteListException) {
            dArray[15] = -1.0;
        }
        dArray[16] = PhraseAnalysis.syncopation(noteArray);
        try {
            dArray[17] = PhraseAnalysis.repeatedPitchDensity(noteArray);
        }
        catch (NoteListException noteListException) {
            dArray[17] = -1.0;
        }
        try {
            dArray[18] = PhraseAnalysis.repeatedRhythmicValueDensity(noteArray);
        }
        catch (NoteListException noteListException) {
            dArray[18] = -1.0;
        }
        try {
            dArray[19] = PhraseAnalysis.repeatedPitchPatterns(noteArray, 3);
        }
        catch (NoteListException noteListException) {
            dArray[19] = -1.0;
        }
        try {
            dArray[20] = PhraseAnalysis.repeatedPitchPatterns(noteArray, 4);
        }
        catch (NoteListException noteListException) {
            dArray[20] = -1.0;
        }
        try {
            dArray[21] = PhraseAnalysis.repeatedRhythmPatterns(noteArray, 3);
        }
        catch (NoteListException noteListException) {
            dArray[21] = -1.0;
        }
        try {
            dArray[22] = PhraseAnalysis.repeatedRhythmPatterns(noteArray, 4);
        }
        catch (NoteListException noteListException) {
            dArray[22] = -1.0;
        }
        return dArray;
    }

    public static Hashtable getAllStatistics(Phrase phrase, double d, int n, int[] nArray) {
        return PhraseAnalysis.getAllStatistics(phrase.getNoteArray(), d, n, nArray);
    }

    public static Hashtable getAllStatistics(Note[] noteArray, double d, int n, int[] nArray) {
        String[] stringArray = PhraseAnalysis.getAllStatisticsAsStrings(noteArray, d, n, nArray);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < featureNames.length; ++i) {
            hashtable.put(featureNames[i], stringArray[i]);
        }
        return hashtable;
    }

    public static double noteDensity(Phrase phrase, double d) throws NoteListException, QuantisationException {
        return PhraseAnalysis.noteDensity(phrase.getNoteArray(), d);
    }

    public static double noteDensity(Note[] noteArray, double d) throws NoteListException, QuantisationException {
        int n = PhraseAnalysis.quantumCount(noteArray, d);
        if (n != 0) {
            return (double)PhraseAnalysis.noteCount(noteArray) / (double)n;
        }
        throw new NoteListException("The length of the melody should be greater than 0.");
    }

    public static double pitchVariety(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.pitchVariety(phrase.getNoteArray());
    }

    public static double pitchVariety(Note[] noteArray) throws NoteListException {
        int n = PhraseAnalysis.noteCount(noteArray);
        if (n != 0) {
            return (double)PhraseAnalysis.distinctPitchCount(noteArray) / (double)n;
        }
        throw new NoteListException("The melody should contain at least one note.");
    }

    public static double rhythmicVariety(Phrase phrase) {
        return PhraseAnalysis.rhythmicVariety(phrase.getNoteArray());
    }

    public static double rhythmicVariety(Note[] noteArray) {
        return (double)PhraseAnalysis.distinctRhythmCount(noteArray) / 16.0;
    }

    public static double climaxStrength(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.climaxStrength(phrase.getNoteArray());
    }

    public static double climaxStrength(Note[] noteArray) throws NoteListException {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < noteArray.length; ++i) {
            int n3 = noteArray[i].getPitch();
            if (n3 == Integer.MIN_VALUE) continue;
            if (n3 > n2) {
                n2 = n3;
                n = 1;
                continue;
            }
            if (n3 != n2) continue;
            ++n;
        }
        if (n != 0) {
            return 1.0 / (double)n;
        }
        throw new NoteListException("The melody should contain at least one note.");
    }

    public static double restDensity(Phrase phrase, double d) throws NoteListException, QuantisationException {
        return PhraseAnalysis.restDensity(phrase.getNoteArray(), d);
    }

    public static double restDensity(Note[] noteArray, double d) throws NoteListException, QuantisationException {
        int n = PhraseAnalysis.quantumCount(noteArray, d);
        if (n != 0) {
            return (double)PhraseAnalysis.restQuantumCount(noteArray, d) / (double)n;
        }
        throw new NoteListException("The length of the melody should be greater than 0.");
    }

    public static double tonalDeviation(Phrase phrase, double d, int n, int[] nArray) throws NoteListException, QuantisationException {
        return PhraseAnalysis.tonalDeviation(phrase.getNoteArray(), d, n, nArray);
    }

    public static double tonalDeviation(Note[] noteArray, double d, int n, int[] nArray) throws NoteListException, QuantisationException {
        int n2 = PhraseAnalysis.quantumCount(noteArray, d);
        if (n2 != 0) {
            return (double)PhraseAnalysis.nonScaleQuantumCount(noteArray, d, n, nArray) / (double)n2;
        }
        throw new NoteListException("The length of the melody should be greater than 0.");
    }

    public static double keyCenteredness(Phrase phrase, double d, int n) throws QuantisationException, NoteListException {
        return PhraseAnalysis.keyCenteredness(phrase.getNoteArray(), d, n);
    }

    public static double keyCenteredness(Note[] noteArray, double d, int n) throws QuantisationException, NoteListException {
        int n2 = PhraseAnalysis.quantumCount(noteArray, d);
        if (n2 > 0) {
            return (double)PhraseAnalysis.primaryQuantumCount(noteArray, d, n) / (double)n2;
        }
        throw new NoteListException("The length of the melody should be greater than 0.");
    }

    public static double pitchRangePerSpan(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.pitchRangePerSpan(phrase.getNoteArray());
    }

    public static double pitchRangePerSpan(Note[] noteArray) throws NoteListException {
        double d = (double)PhraseAnalysis.pitchRange(noteArray) / 24.0;
        return d < 1.0 ? d : 1.0;
    }

    public static double rhythmRangePerSpan(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.rhythmRangePerSpan(phrase.getNoteArray());
    }

    public static double rhythmRangePerSpan(Note[] noteArray) throws NoteListException {
        double d = PhraseAnalysis.rhythmRange(noteArray) / 16.0;
        return d < 1.0 ? d : 1.0;
    }

    public static double repeatedPitchDensity(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.repeatedPitchDensity(phrase.getNoteArray());
    }

    public static double repeatedPitchDensity(Note[] noteArray) throws NoteListException {
        int n = PhraseAnalysis.intervalCount(noteArray);
        if (n != 0) {
            return (double)PhraseAnalysis.consecutiveIdenticalPitches(noteArray) / (double)n;
        }
        throw new NoteListException("The melody should contain at least two notes.");
    }

    public static double repeatedRhythmicValueDensity(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.repeatedRhythmicValueDensity(phrase.getNoteArray());
    }

    public static double repeatedRhythmicValueDensity(Note[] noteArray) throws NoteListException {
        int n = PhraseAnalysis.intervalCount(noteArray);
        if (n != 0) {
            return (double)PhraseAnalysis.consecutiveIdenticalRhythms(noteArray) / (double)n;
        }
        throw new NoteListException("The melody should contain at least two notes.");
    }

    public static double melodicDirectionStability(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.melodicDirectionStability(phrase.getNoteArray());
    }

    public static double melodicDirectionStability(Note[] noteArray) throws NoteListException {
        int n = PhraseAnalysis.intervalCount(noteArray);
        if (n - 1 != 0) {
            return (double)PhraseAnalysis.sameDirectionIntervalCount(noteArray) / (double)n;
        }
        throw new NoteListException("The melody should contain at least three notes.");
    }

    public static double overallPitchDirection(Phrase phrase) {
        return PhraseAnalysis.overallPitchDirection(phrase.getNoteArray());
    }

    public static double overallPitchDirection(Note[] noteArray) {
        double d = PhraseAnalysis.intervalSemitoneCount(noteArray);
        if (d != 0.0) {
            return (double)PhraseAnalysis.risingSemitoneCount(noteArray) / d;
        }
        return 0.5;
    }

    public static double movementByStep(Phrase phrase, int n, int[] nArray) throws NoteListException {
        return PhraseAnalysis.movementByStep(phrase.getNoteArray(), n, nArray);
    }

    public static double movementByStep(Note[] noteArray, int n, int[] nArray) throws NoteListException {
        int n2 = PhraseAnalysis.intervalCount(noteArray);
        if (n2 > 0) {
            return (double)PhraseAnalysis.stepIntervalCount(noteArray, n, nArray) / (double)n2;
        }
        throw new NoteListException("The melody should contain at least two notes.");
    }

    public static double dissonance(Phrase phrase) {
        return PhraseAnalysis.dissonance(phrase.getNoteArray());
    }

    public static double dissonance(Note[] noteArray) {
        int[] nArray = PhraseAnalysis.pitchIntervals(noteArray);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 127) {
                int n2 = i;
                nArray[n2] = nArray[n2] - 255;
            }
            nArray[i] = Math.abs(nArray[i]);
            if (nArray[i] > 12) {
                n += 2;
                continue;
            }
            n += PhraseAnalysis.rateDissonance(nArray[i]);
        }
        return (double)n / (2.0 * (double)nArray.length);
    }

    public static double leapCompensation(Phrase phrase) {
        return PhraseAnalysis.leapCompensation(phrase.getNoteArray());
    }

    public static double leapCompensation(Note[] noteArray) {
        int n = PhraseAnalysis.bigJumpCount(noteArray);
        if (n != 0) {
            return (double)(n - PhraseAnalysis.bigJumpFollowedByStepBackCount(noteArray)) / (double)n;
        }
        return 0.0;
    }

    public static double syncopation(Phrase phrase) {
        return PhraseAnalysis.syncopation(phrase.getNoteArray());
    }

    public static double syncopation(Note[] noteArray) {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < noteArray.length; ++i) {
            double d2 = noteArray[i].getRhythmValue();
            if (d2 >= 1.0 && noteArray[i].getPitch() != Integer.MIN_VALUE && d % 1.0 != 0.0) {
                ++n;
            }
            d += d2;
        }
        return (double)n / Math.floor(PhraseAnalysis.rhythmValueCount(noteArray) - 1.0);
    }

    public static double repeatedPitchPatterns(Phrase phrase, int n) throws NoteListException {
        return PhraseAnalysis.repeatedPitchPatterns(phrase.getNoteArray(), n);
    }

    public static double repeatedPitchPatterns(Note[] noteArray, int n) throws NoteListException {
        int n2 = PhraseAnalysis.intervalCount(noteArray) - n;
        if (n2 > 0) {
            return (double)PhraseAnalysis.pitchPatternCount(noteArray, n) / (double)n2;
        }
        throw new NoteListException("The melody must contain more intervals than the size of the pattern being searched for.");
    }

    public static double repeatedRhythmPatterns(Phrase phrase, int n) throws NoteListException {
        return PhraseAnalysis.repeatedRhythmPatterns(phrase.getNoteArray(), n);
    }

    public static double repeatedRhythmPatterns(Note[] noteArray, int n) throws NoteListException {
        int n2 = PhraseAnalysis.intervalCount(noteArray) - n;
        if (n2 > 0) {
            return (double)PhraseAnalysis.rhythmPatternCount(noteArray, n) / (double)n2;
        }
        throw new NoteListException("The melody must contain more intervals than the size of the pattern being searched for.");
    }

    public static double climaxPosition(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.climaxPosition(phrase.getNoteArray());
    }

    public static double climaxPosition(Note[] noteArray) throws NoteListException {
        if (PhraseAnalysis.noteCount(noteArray) > 0) {
            double d = 0.0;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < noteArray.length; ++i) {
                d += noteArray[i].getRhythmValue();
                int n3 = noteArray[i].getPitch();
                if (n3 == Integer.MIN_VALUE || n3 < n) continue;
                n = n3;
                n2 = i;
            }
            double d2 = 0.0;
            for (int i = 0; i < n2 - 1; ++i) {
                d2 += noteArray[i].getRhythmValue();
            }
            return d2 / d;
        }
        throw new NoteListException("The melody should contain at least one note.");
    }

    public static double climaxTonality(Phrase phrase, int n, int[] nArray) throws NoteListException {
        return PhraseAnalysis.climaxTonality(phrase.getNoteArray(), n, nArray);
    }

    public static double climaxTonality(Note[] noteArray, int n, int[] nArray) throws NoteListException {
        if (PhraseAnalysis.noteCount(noteArray) > 0) {
            int n2 = 0;
            for (int i = 0; i < noteArray.length; ++i) {
                int n3 = noteArray[i].getPitch();
                if (n3 == Integer.MIN_VALUE || n3 <= n2) continue;
                n2 = n3;
            }
            if (PhraseAnalysis.isElementOf(n2 = PhraseAnalysis.pitchToDegree(n2, n), PRIMARY_NOTES)) {
                return 0.0;
            }
            if (PhraseAnalysis.isElementOf(n2, nArray)) {
                return 0.5;
            }
            return 1.0;
        }
        throw new NoteListException("The melody should contain at least one note.");
    }

    public static int noteCount(Phrase phrase) {
        return PhraseAnalysis.noteCount(phrase.getNoteArray());
    }

    public static int noteCount(Note[] noteArray) {
        int n = 0;
        for (int i = 0; i < noteArray.length; ++i) {
            if (noteArray[i].getPitch() == Integer.MIN_VALUE) continue;
            ++n;
        }
        return n;
    }

    public static int quantumCount(Phrase phrase, double d) throws QuantisationException {
        return PhraseAnalysis.quantumCount(phrase.getNoteArray(), d);
    }

    public static int quantumCount(Note[] noteArray, double d) throws QuantisationException {
        if (PhraseAnalysis.isQuantised(noteArray, d)) {
            int n = 0;
            for (int i = 0; i < noteArray.length; ++i) {
                n += (int)(noteArray[i].getRhythmValue() / d);
            }
            return n;
        }
        throw new QuantisationException("Every rhythm value must be a multiple of the quantum duration.");
    }

    public static int distinctPitchCount(Phrase phrase) {
        return PhraseAnalysis.distinctPitchCount(phrase.getNoteArray());
    }

    public static int distinctPitchCount(Note[] noteArray) {
        int[] nArray = new int[noteArray.length];
        int n = 0;
        for (int i = 0; i < noteArray.length; ++i) {
            int n2 = noteArray[i].getPitch();
            if (n2 == Integer.MIN_VALUE || PhraseAnalysis.isElementOf(n2, nArray, n)) continue;
            nArray[n] = n2;
            ++n;
        }
        return n;
    }

    public static int distinctRhythmCount(Phrase phrase) {
        return PhraseAnalysis.distinctRhythmCount(phrase.getNoteArray());
    }

    public static int distinctRhythmCount(Note[] noteArray) {
        double[] dArray = new double[noteArray.length];
        int n = 0;
        for (int i = 0; i < noteArray.length; ++i) {
            double d;
            if (noteArray[i].getPitch() > Integer.MIN_VALUE || PhraseAnalysis.isElementOf(d = noteArray[i].getRhythmValue(), dArray, n)) continue;
            dArray[n] = d;
            ++n;
        }
        return n;
    }

    public static int restQuantumCount(Phrase phrase, double d) throws QuantisationException {
        return PhraseAnalysis.restQuantumCount(phrase.getNoteArray(), d);
    }

    public static int restQuantumCount(Note[] noteArray, double d) throws QuantisationException {
        if (PhraseAnalysis.isQuantised(noteArray, d)) {
            int n = 0;
            for (int i = 0; i < noteArray.length; ++i) {
                if (noteArray[i].getPitch() != Integer.MIN_VALUE) continue;
                n += (int)(noteArray[i].getRhythmValue() / d);
            }
            return n;
        }
        throw new QuantisationException("Every rhythm value must be a multiple of the quantum duration.");
    }

    public static int nonScaleQuantumCount(Phrase phrase, double d, int n, int[] nArray) throws QuantisationException {
        return PhraseAnalysis.nonScaleQuantumCount(phrase.getNoteArray(), d, n, nArray);
    }

    public static int nonScaleQuantumCount(Note[] noteArray, double d, int n, int[] nArray) throws QuantisationException {
        if (PhraseAnalysis.isQuantised(noteArray, d)) {
            int n2 = 0;
            for (int i = 0; i < noteArray.length; ++i) {
                int n3 = noteArray[i].getPitch();
                if (n3 == Integer.MIN_VALUE || PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(n3, n), nArray)) continue;
                n2 += (int)(noteArray[i].getRhythmValue() / d);
            }
            return n2;
        }
        throw new QuantisationException("Every rhythm value must be a multiple of the quantum duration.");
    }

    public static int primaryQuantumCount(Phrase phrase, double d, int n) throws QuantisationException {
        return PhraseAnalysis.primaryQuantumCount(phrase.getNoteArray(), d, n);
    }

    public static int primaryQuantumCount(Note[] noteArray, double d, int n) throws QuantisationException {
        if (PhraseAnalysis.isQuantised(noteArray, d)) {
            int n2 = 0;
            for (int i = 0; i < noteArray.length; ++i) {
                int n3 = noteArray[i].getPitch();
                if (n3 != Integer.MIN_VALUE && !PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(n3, n), PRIMARY_NOTES)) continue;
                n2 += (int)(noteArray[i].getRhythmValue() / d);
            }
            return n2;
        }
        throw new QuantisationException("Every rhythm value must be a multiple of the quantum duration.");
    }

    public static int pitchRange(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.pitchRange(phrase.getNoteArray());
    }

    public static int pitchRange(Note[] noteArray) throws NoteListException {
        int n = 0;
        int n2 = 127;
        for (int i = 0; i < noteArray.length; ++i) {
            int n3 = noteArray[i].getPitch();
            if (n3 == Integer.MIN_VALUE) continue;
            if (n3 > n) {
                n = n3;
                continue;
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        if (n != 0 && n2 != 127) {
            return n - n2;
        }
        throw new NoteListException("There are no notes in the melody.");
    }

    public static double rhythmRange(Phrase phrase) throws NoteListException {
        return PhraseAnalysis.rhythmRange(phrase.getNoteArray());
    }

    public static double rhythmRange(Note[] noteArray) throws NoteListException {
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < noteArray.length; ++i) {
            double d3 = noteArray[i].getRhythmValue();
            if (noteArray[i].getPitch() == Integer.MIN_VALUE) continue;
            if (d3 > d) {
                d = d3;
                continue;
            }
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        if (d != 0.0 && d2 != Double.MAX_VALUE) {
            return d / d2;
        }
        throw new NoteListException("There are no notes in the melody.");
    }

    public static int consecutiveIdenticalPitches(Phrase phrase) {
        return PhraseAnalysis.consecutiveIdenticalPitches(phrase.getNoteArray());
    }

    public static int consecutiveIdenticalPitches(Note[] noteArray) {
        int[] nArray = PhraseAnalysis.pitchIntervals(noteArray);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0 && nArray[i] != 255) continue;
            ++n;
        }
        return n;
    }

    public static int consecutiveIdenticalRhythms(Phrase phrase) {
        return PhraseAnalysis.consecutiveIdenticalRhythms(phrase.getNoteArray());
    }

    public static int consecutiveIdenticalRhythms(Note[] noteArray) {
        double[] dArray = PhraseAnalysis.rhythmIntervals(noteArray);
        int n = 0;
        for (int i = 0; i < dArray.length - 1; ++i) {
            if (!(dArray[i] == 1.0 && dArray[i + 1] > 0.0) && (dArray[i] != -1.0 || !(dArray[i + 1] < 0.0))) continue;
            ++n;
        }
        if (dArray[dArray.length - 1] == 1.0) {
            ++n;
        }
        return n;
    }

    public static int sameDirectionIntervalCount(Phrase phrase) {
        return PhraseAnalysis.sameDirectionIntervalCount(phrase.getNoteArray());
    }

    public static int sameDirectionIntervalCount(Note[] noteArray) {
        int n = 0;
        int[] nArray = PhraseAnalysis.pitchIntervals(noteArray);
        if (nArray.length > 0) {
            if (nArray[0] > 127) {
                nArray[0] = nArray[0] - 255;
            }
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] > 127) {
                    int n2 = i;
                    nArray[n2] = nArray[n2] - 255;
                }
                if (!(nArray[i] > 0 && nArray[i - 1] > 0 || nArray[i] == 0 && nArray[i - 1] == 0) && (nArray[i] >= 0 || nArray[i - 1] >= 0)) continue;
                ++n;
            }
        }
        return n;
    }

    public static int intervalCount(Phrase phrase) {
        return PhraseAnalysis.intervalCount(phrase.getNoteArray());
    }

    public static int intervalCount(Note[] noteArray) {
        int n = PhraseAnalysis.noteCount(noteArray) - 1;
        return n < 1 ? 0 : n;
    }

    public static int[] pitchIntervals(Phrase phrase) {
        return PhraseAnalysis.pitchIntervals(phrase.getNoteArray());
    }

    public static int[] pitchIntervals(Note[] noteArray) {
        int n = PhraseAnalysis.intervalCount(noteArray);
        if (n > 0) {
            int[] nArray = new int[n];
            int n2 = -1;
            while (noteArray[++n2].getPitch() == Integer.MIN_VALUE) {
            }
            int n3 = noteArray[n2].getPitch();
            int n4 = 0;
            while (n4 < nArray.length) {
                int n5 = noteArray[++n2].getPitch();
                while (n5 == Integer.MIN_VALUE) {
                    if (noteArray[n2 - 1].getPitch() != Integer.MIN_VALUE) {
                        int n6 = n4;
                        nArray[n6] = nArray[n6] + 255;
                    }
                    n5 = noteArray[++n2].getPitch();
                }
                int n7 = n4++;
                nArray[n7] = nArray[n7] + (n5 - n3);
                n3 = n5;
            }
            return nArray;
        }
        return new int[0];
    }

    public static double[] rhythmIntervals(Phrase phrase) {
        return PhraseAnalysis.rhythmIntervals(phrase.getNoteArray());
    }

    public static double[] rhythmIntervals(Note[] noteArray) {
        int n = noteArray.length - 1;
        for (int i = noteArray.length - 1; noteArray[i].getPitch() == Integer.MIN_VALUE && i > -1; --i) {
            --n;
        }
        if (n > 0) {
            double[] dArray = new double[n];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = noteArray[i + 1].getRhythmValue() / noteArray[i].getRhythmValue();
                if (noteArray[i].getPitch() != Integer.MIN_VALUE) continue;
                int n2 = i;
                dArray[n2] = dArray[n2] * -1.0;
            }
            return dArray;
        }
        return new double[0];
    }

    public static int intervalSemitoneCount(Phrase phrase) {
        return PhraseAnalysis.intervalSemitoneCount(phrase.getNoteArray());
    }

    public static int intervalSemitoneCount(Note[] noteArray) {
        int n = 0;
        int[] nArray = PhraseAnalysis.pitchIntervals(noteArray);
        for (int i = 0; i < nArray.length; ++i) {
            n += Math.abs(PhraseAnalysis.removeRestMarker(nArray[i]));
        }
        return n;
    }

    public static int risingSemitoneCount(Phrase phrase) {
        return PhraseAnalysis.risingSemitoneCount(phrase.getNoteArray());
    }

    public static int risingSemitoneCount(Note[] noteArray) {
        int n = 0;
        int[] nArray = PhraseAnalysis.pitchIntervals(noteArray);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = PhraseAnalysis.removeRestMarker(nArray[i]);
            if (nArray[i] <= 0) continue;
            n += nArray[i];
        }
        return n;
    }

    public static int stepIntervalCount(Phrase phrase, int n, int[] nArray) {
        return PhraseAnalysis.stepIntervalCount(phrase.getNoteArray(), n, nArray);
    }

    public static int stepIntervalCount(Note[] noteArray, int n, int[] nArray) {
        int n2 = PhraseAnalysis.intervalCount(noteArray);
        if (n2 > 0) {
            int n3 = -1;
            int n4 = 0;
            while (noteArray[++n3].getPitch() == Integer.MIN_VALUE) {
            }
            int n5 = noteArray[n3].getPitch();
            for (int i = 0; i < n2; ++i) {
                while (noteArray[++n3].getPitch() == Integer.MIN_VALUE) {
                }
                int n6 = noteArray[n3].getPitch();
                if (Math.abs(n6 - n5) < 3 && PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(n6, n), nArray) && PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(n5, n), nArray)) {
                    ++n4;
                }
                n5 = n6;
            }
            return n4;
        }
        return 0;
    }

    public static int bigJumpFollowedByStepBackCount(Phrase phrase) {
        return PhraseAnalysis.bigJumpFollowedByStepBackCount(phrase.getNoteArray());
    }

    public static int bigJumpFollowedByStepBackCount(Note[] noteArray) {
        int n = 0;
        int[] nArray = PhraseAnalysis.pitchIntervals(noteArray);
        if (nArray.length > 0) {
            nArray[0] = PhraseAnalysis.removeRestMarker(nArray[0]);
            for (int i = 1; i < nArray.length - 1; ++i) {
                nArray[i] = PhraseAnalysis.removeRestMarker(nArray[i]);
                if ((nArray[i - 1] < 8 || nArray[i] >= 0 || nArray[i] < -8) && (nArray[i - 1] > -8 || nArray[i] <= 0 || nArray[i] > 8)) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    public static int bigJumpCount(Phrase phrase) {
        return PhraseAnalysis.bigJumpCount(phrase.getNoteArray());
    }

    public static int bigJumpCount(Note[] noteArray) {
        int n = 0;
        int[] nArray = PhraseAnalysis.pitchIntervals(noteArray);
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length - 1; ++i) {
                nArray[i] = PhraseAnalysis.removeRestMarker(nArray[i]);
                if (Math.abs(nArray[i]) < 8) continue;
                ++n;
            }
            return n;
        }
        return n;
    }

    public static int pitchPatternCount(Phrase phrase, int n) {
        return PhraseAnalysis.pitchPatternCount(phrase.getNoteArray(), n);
    }

    public static int pitchPatternCount(Note[] noteArray, int n) {
        int n2 = 0;
        int[] nArray = PhraseAnalysis.pitchIntervals(noteArray);
        if (nArray.length > n) {
            int[][] nArray2 = new int[nArray.length - n][n];
            int n3 = 0;
            for (int i = 0; i < nArray.length - n; ++i) {
                int n4;
                int[] nArray3 = new int[n];
                for (n4 = 0; n4 < n; ++n4) {
                    nArray3[n4] = nArray[i + n4];
                }
                if (PhraseAnalysis.isAlreadyMatched(nArray2, nArray3, n3)) continue;
                for (n4 = i + 1; n4 < nArray.length - n + 1; ++n4) {
                    if (!PhraseAnalysis.matchPattern(nArray, i, n4, n)) continue;
                    if (n3 == 0 || nArray2[n3 - 1] != nArray3) {
                        nArray2[n3++] = nArray3;
                    }
                    ++n2;
                }
            }
        }
        return n2;
    }

    public static int rhythmPatternCount(Phrase phrase, int n) {
        return PhraseAnalysis.rhythmPatternCount(phrase.getNoteArray(), n);
    }

    public static int rhythmPatternCount(Note[] noteArray, int n) {
        int n2 = 0;
        double[] dArray = PhraseAnalysis.rhythmIntervals(noteArray);
        if (dArray.length > n) {
            double[][] dArray2 = new double[dArray.length - n][n];
            int n3 = 0;
            for (int i = 0; i < dArray.length - n; ++i) {
                int n4;
                double[] dArray3 = new double[n];
                for (n4 = 0; n4 < n; ++n4) {
                    dArray3[n4] = dArray[i + n4];
                }
                if (PhraseAnalysis.isAlreadyMatched(dArray2, dArray3, n3)) continue;
                for (n4 = i + 1; n4 < dArray.length - n + 1; ++n4) {
                    if (!PhraseAnalysis.matchPattern(dArray, i, n4, n)) continue;
                    if (n3 == 0 || dArray2[n3 - 1] != dArray3) {
                        dArray2[n3++] = dArray3;
                    }
                    ++n2;
                }
            }
        }
        return n2;
    }

    public static double rhythmValueCount(Phrase phrase) {
        return PhraseAnalysis.rhythmValueCount(phrase.getNoteArray());
    }

    public static double rhythmValueCount(Note[] noteArray) {
        double d = 0.0;
        for (int i = 0; i < noteArray.length; ++i) {
            d += noteArray[i].getRhythmValue();
        }
        return d;
    }

    public static int removeRestMarker(int n) {
        return n > 127 ? n - 255 : n;
    }

    public static boolean isQuantised(Phrase phrase, double d) throws QuantisationException {
        return PhraseAnalysis.isQuantised(phrase.getNoteArray(), d);
    }

    public static boolean isQuantised(Note[] noteArray, double d) throws QuantisationException {
        if (d > 0.0) {
            for (int i = 0; i < noteArray.length; ++i) {
                if (noteArray[i].getRhythmValue() % d == 0.0) continue;
                return false;
            }
            return true;
        }
        throw new QuantisationException("The quantum duration must be greater than zero.");
    }

    private static boolean matchPattern(int[] nArray, int n, int n2, int n3) {
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            if (nArray[n + i] == nArray[n2 + i]) continue;
            bl = false;
        }
        return bl;
    }

    private static boolean matchPattern(double[] dArray, int n, int n2, int n3) {
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            if (dArray[n + i] == dArray[n2 + i]) continue;
            bl = false;
        }
        return bl;
    }

    private static boolean isAlreadyMatched(int[][] nArray, int[] nArray2, int n) {
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i][j] != nArray2[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    private static boolean isAlreadyMatched(double[][] dArray, double[] dArray2, int n) {
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < dArray2.length; ++j) {
                if (dArray[i][j] != dArray2[j]) continue block0;
            }
            return true;
        }
        return false;
    }

    private static int rateDissonance(int n) {
        int n2;
        for (n2 = 0; n2 < GOOD_INTERVALS.length; ++n2) {
            if (n != GOOD_INTERVALS[n2]) continue;
            return 0;
        }
        for (n2 = 0; n2 < BAD_INTERVALS.length; ++n2) {
            if (n != BAD_INTERVALS[n2]) continue;
            return 2;
        }
        return 1;
    }

    private static boolean isElementOf(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private static boolean isElementOf(int n, int[] nArray, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private static boolean isElementOf(double d, double[] dArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (dArray[i] != d) continue;
            return true;
        }
        return false;
    }

    public static int pitchToDegree(int n, int n2) {
        if ((n -= n2) < 0) {
            n += (-n / 12 + 1) * 12;
        }
        return n % 12;
    }

    public static boolean isScale(Note note, int n, int[] nArray) {
        int n2 = note.getPitch();
        if (n2 == Integer.MIN_VALUE) {
            return true;
        }
        return PhraseAnalysis.isElementOf(PhraseAnalysis.pitchToDegree(n2, n), nArray, nArray.length);
    }
}

