/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import jm.JMC;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.AdaptiveMatrix;

public final class PhraseMatrix
implements JMC {
    private AdaptiveMatrix pitchAM;
    private AdaptiveMatrix rhythmAM;
    private AdaptiveMatrix dynamicAM;
    private int pitchDepth;
    private int rhythmDepth;
    private int dynamicDepth;
    private Note[] notes;
    private final double[] rhythmMap = new double[]{4.0, 3.0, 2.0, 1.0, 0.6666666666666666, 1.5, 0.5, 0.75, 0.3333333333333333, 0.25, 0.125};

    public PhraseMatrix(Phrase phrase, int n) {
        this(phrase, n, n, n);
    }

    public PhraseMatrix(Phrase phrase, int n, int n2, int n3) {
        this.pitchDepth = n;
        this.rhythmDepth = n2;
        this.dynamicDepth = n3;
        this.notes = phrase.getNoteArray();
        this.calcPitch();
        this.calcRhythm();
        this.calcDynamic();
    }

    public void calcPitch() {
        int[] nArray = new int[this.notes.length];
        for (int i = 0; i < this.notes.length; ++i) {
            nArray[i] = this.notes[i].getPitch();
        }
        this.pitchAM = new AdaptiveMatrix(nArray, this.pitchDepth, 127);
    }

    public void calcRhythm() {
        int[] nArray = new int[this.notes.length];
        for (int i = 0; i < this.notes.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < this.rhythmMap.length; ++j) {
                if (this.notes[i].getRhythmValue() != this.rhythmMap[j]) continue;
                bl = true;
                nArray[i] = j;
                break;
            }
            if (bl) continue;
            System.err.print("[WARNING] PhraseMatrix only supports ");
            System.err.println("rhythm values supported in the JMC file");
        }
        this.rhythmAM = new AdaptiveMatrix(nArray, this.rhythmDepth, this.rhythmMap.length);
    }

    public void calcDynamic() {
        int[] nArray = new int[this.notes.length];
        for (int i = 0; i < this.notes.length; ++i) {
            nArray[i] = this.notes[i].getDynamic();
        }
        this.dynamicAM = new AdaptiveMatrix(nArray, this.dynamicDepth, 127);
    }

    public Phrase generate(boolean bl, boolean bl2, boolean bl3) {
        return this.generate(bl, bl2, bl3, this.notes.length);
    }

    public Phrase generate(boolean bl, boolean bl2, boolean bl3, int n) {
        int n2;
        int n3;
        int[] nArray = new int[this.pitchDepth];
        int[] nArray2 = new int[this.rhythmDepth];
        int[] nArray3 = new int[this.dynamicDepth];
        Note[] noteArray = new Note[n];
        for (n3 = 0; n3 < n; ++n3) {
            noteArray[n3] = new Note();
        }
        for (n3 = 0; n3 < this.pitchDepth; ++n3) {
            nArray[n3] = this.notes[n3].getPitch();
        }
        block2: for (n3 = 0; n3 < this.rhythmDepth; ++n3) {
            for (int i = 0; i < this.rhythmMap.length; ++i) {
                if (this.notes[n3].getRhythmValue() != this.rhythmMap[i]) continue;
                nArray2[n3] = i;
                continue block2;
            }
        }
        for (n3 = 0; n3 < this.dynamicDepth; ++n3) {
            nArray3[n3] = this.notes[n3].getDynamic();
        }
        int[] nArray4 = this.pitchAM.generate(n, nArray);
        int[] nArray5 = this.dynamicAM.generate(n, nArray3);
        int[] nArray6 = this.rhythmAM.generate(n, nArray2);
        if (bl) {
            for (n2 = 0; n2 < n; ++n2) {
                noteArray[n2].setPitch(nArray4[n2]);
            }
        }
        if (bl2) {
            for (n2 = 0; n2 < n; ++n2) {
                noteArray[n2].setRhythmValue(this.rhythmMap[nArray6[n2]]);
                noteArray[n2].setDuration(this.rhythmMap[nArray6[n2]] * 0.9);
            }
        }
        if (bl3) {
            for (n2 = 0; n2 < n; ++n2) {
                noteArray[n2].setDynamic(nArray5[n2]);
            }
        }
        Phrase phrase = new Phrase();
        phrase.addNoteList(noteArray);
        return phrase;
    }
}

