/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools;

import java.util.Random;

public final class Prob {
    private static final Random RNG = new Random();

    private Prob() {
    }

    public static final int gaussianPitch(int n, int n2) {
        long l;
        while ((l = Math.round(RNG.nextGaussian() * (double)n2 + (double)n)) < 0L || l > 127L) {
        }
        return (int)l;
    }

    public static final double gaussianFrequency(double d, double d2) {
        double d3;
        while ((d3 = RNG.nextGaussian() * d2 + d) < 1.0E-17) {
        }
        return d3;
    }

    public static final double gaussianRhythmValue(double d, double d2, double d3) {
        double d4;
        do {
            d4 = RNG.nextGaussian() * d2 + d;
            d4 /= d3;
            d4 = Math.round(d4);
        } while ((d4 *= d3) < 0.0 || d4 > Double.MAX_VALUE);
        return d4;
    }

    public static final int gaussianDynamic(int n, int n2) {
        long l;
        while ((l = Math.round(RNG.nextGaussian() * (double)n2 + (double)n)) < 0L || l > 127L) {
        }
        return (int)l;
    }

    public static final double gaussianPan(double d, double d2) {
        return Prob.gaussianPan(d, d2, 1.0);
    }

    public static final double gaussianPan(double d, double d2, double d3) {
        long l;
        double d4 = d3 = d3 >= 0.0 ? d3 : 0.0;
        while ((double)(l = Math.round(RNG.nextGaussian() * d2 + d)) < 0.0 || (double)l > d3) {
        }
        return (int)l;
    }
}

