/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.fuzzy;

public class FuzzyNumber {
    private double peak;
    private double min;
    private double max;
    private double diff;
    private double membership;

    public FuzzyNumber(double d, double d2, double d3) {
        this.peak = d;
        this.min = d2;
        this.max = d3;
    }

    public double getMembership(double d) {
        if (d < this.min || d > this.max) {
            return 0.0;
        }
        this.diff = this.peak - d;
        this.membership = this.diff >= 0.0 ? 1.0 - this.diff / (this.peak - this.min) : 1.0 + this.diff / (this.max - this.peak);
        return this.membership;
    }

    public void setPeak(double d) {
        this.peak = d;
        if (this.min > d) {
            this.min = d;
        }
        if (this.max < d) {
            this.max = d;
        }
    }

    public double getPeak() {
        return this.peak;
    }

    public void setMin(double d) {
        this.min = d;
        if (this.peak < d) {
            this.peak = d;
        }
        if (this.max < d) {
            this.max = d;
        }
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double d) {
        this.max = d;
        if (this.min > d) {
            this.min = d;
        }
        if (this.peak > d) {
            this.peak = d;
        }
    }

    public double getMax() {
        return this.max;
    }
}

