/*
 * Decompiled with CFR 0.152.
 */
package jm.music.tools.ga;

import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.music.data.Note;
import jm.music.data.Phrase;
import jm.music.tools.PhraseAnalysis;
import jm.music.tools.ga.PopulationInitialiser;

public class ClimaticPopInitialiser
extends PopulationInitialiser {
    protected static String label = "Climatic Population Initialiser";
    public final int TONIC = 60;
    public static final int MIN_POPULATION_SIZE = 2;
    public static final int MAX_POPULATION_SIZE = 100;
    public static final int DEFAULT_POPULATION_SIZE = 50;
    public static final double CLIMAX_AVERAGE = 0.523;
    public static final double CLIMAX_ST_DEV = 0.261;
    protected Panel panel;
    protected int populationSize;
    protected Label populationLabel;
    protected boolean modifyAll = false;

    public ClimaticPopInitialiser() {
        this(50);
    }

    public ClimaticPopInitialiser(int n) {
        this.populationSize = n;
        this.panel = new Panel();
        this.panel.setLayout(new FlowLayout(0, 0, 0));
        this.populationLabel = new Label(Integer.toString(this.populationSize));
        this.panel.add(new Label("Population Size", 2));
        this.panel.add(new Scrollbar(0, this.populationSize, 1, 2, 100){
            {
                this.addAdjustmentListener(new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        ClimaticPopInitialiser.this.populationSize = this.getValue();
                        ClimaticPopInitialiser.this.populationLabel.setText(Integer.toString(this.getValue()));
                        ClimaticPopInitialiser.this.populationLabel.repaint();
                    }
                });
            }
        });
        this.panel.add(this.populationLabel);
    }

    @Override
    public Phrase[] initPopulation(Phrase phrase, int n) {
        Phrase phrase2 = this.completeFinalBeat(phrase, n);
        int n2 = this.modifyAll ? 0 : phrase2.size();
        double[][] dArray = this.generateBeatRhythmArray(phrase2, n);
        int[] nArray = this.generateIntervalArray(phrase2);
        Phrase[] phraseArray = new Phrase[this.populationSize];
        for (int i = 0; i < this.populationSize; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            Note note;
            phraseArray[i] = phrase2.copy();
            int n7 = 0;
            if (this.isClimaxAccepted(phrase2, n)) {
                n7 = this.findClimax(phrase2);
                note = new Note(60, (double)n);
                n6 = 7 * n;
            } else {
                n5 = 127;
                for (n4 = 0; n4 < phrase2.size(); ++n4) {
                    n3 = phrase2.getNote(n4).getPitch();
                    if (n3 == Integer.MIN_VALUE || n3 >= n5) continue;
                    n5 = n3;
                }
                note = this.generateClimax(n5);
                n7 = note.getPitch();
                n6 = 4 * n;
            }
            n5 = -1;
            for (n4 = 0; n4 < phrase2.size(); ++n4) {
                n3 = phrase2.getNote(n4).getPitch();
                if (n3 == Integer.MIN_VALUE) continue;
                n5 = n3 - 12;
                break;
            }
            if (n5 < 53) {
                n5 = 53;
            }
            this.extend(phraseArray[i], note, n6, dArray, nArray, n7, n, n5);
            this.addAppropriateTarget(phraseArray[i], note);
            if (phraseArray[i].getEndTime() != (double)(8 * n)) {
                note = new Note(60, (double)n);
                n6 = 7 * n;
                this.extend(phraseArray[i], note, n6, dArray, nArray, n7, n, n5);
                n4 = phraseArray[i].size() - 1;
                n3 = phraseArray[i].getNote(n4).getPitch();
                while (n3 == Integer.MIN_VALUE) {
                    n3 = phraseArray[i].getNote(--n4).getPitch();
                }
                int n8 = note.getPitch();
                if (n3 < n8) {
                    if (n8 - n3 > 6) {
                        note.setPitch(n8 - 12);
                    }
                } else if (n3 > n8 && n3 - n8 > 6) {
                    note.setPitch(n8 + 12);
                }
                phraseArray[i].addNote(note);
            }
            this.cleanMelody(phraseArray[i], n2);
        }
        return phraseArray;
    }

    private Phrase completeFinalBeat(Phrase phrase, int n) {
        Phrase phrase2 = phrase.copy();
        double d = phrase2.getEndTime();
        double d2 = Math.ceil(d) - d;
        if (d2 > 0.0) {
            int[] nArray = this.generateIntervalArray(phrase);
            int n2 = phrase2.size() - 1;
            int n3 = Integer.MIN_VALUE;
            while (n3 == Integer.MIN_VALUE) {
                n3 = phrase2.getNote(n2--).getPitch();
            }
            if (!this.isScale(n3 += nArray[(int)(Math.random() * (double)nArray.length)])) {
                n3 = Math.random() < 0.5 ? ++n3 : --n3;
            }
            phrase2.addNote(new Note(n3, d2));
        }
        return phrase2;
    }

    private double[][] generateBeatRhythmArray(Phrase phrase, int n) {
        double[][] dArrayArray = new double[(int)phrase.getEndTime() * n][];
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        while (n3 < phrase.size()) {
            int n4 = n3;
            double d2 = d;
            int n5 = n3;
            double d3 = d;
            double[] dArray = new double[phrase.size()];
            int n6 = 0;
            Note note = phrase.getNote(n5++);
            double d4 = note.getRhythmValue();
            dArray[n6++] = d4;
            if (note.getPitch() == Integer.MIN_VALUE) {
                int n7 = n6 - 1;
                dArray[n7] = dArray[n7] * -1.0;
            }
            d3 += d4;
            while (d3 != Math.ceil(d3)) {
                note = phrase.getNote(n5++);
                d4 = note.getRhythmValue();
                dArray[n6++] = d4;
                if (note.getPitch() == Integer.MIN_VALUE) {
                    int n8 = n6 - 1;
                    dArray[n8] = dArray[n8] * -1.0;
                }
                d3 += d4;
            }
            double[] dArray2 = new double[n6];
            System.arraycopy(dArray, 0, dArray2, 0, n6);
            dArrayArray[n2++] = dArray2;
            n3 = n5;
            d = d3;
            while (d3 < d2 + (double)n && n5 < phrase.size()) {
                note = phrase.getNote(n5++);
                d4 = note.getRhythmValue();
                dArray[n6++] = d4;
                if (note.getPitch() == Integer.MIN_VALUE) {
                    int n9 = n6 - 1;
                    dArray[n9] = dArray[n9] * -1.0;
                }
                d3 += d4;
                while (d3 != Math.ceil(d3)) {
                    note = phrase.getNote(n5++);
                    d4 = note.getRhythmValue();
                    dArray[n6++] = d4;
                    if (note.getPitch() == Integer.MIN_VALUE) {
                        int n10 = n6 - 1;
                        dArray[n10] = dArray[n10] * -1.0;
                    }
                    d3 += d4;
                }
                if (!(d3 <= d2 + (double)n)) continue;
                dArray2 = new double[n6];
                System.arraycopy(dArray, 0, dArray2, 0, n6);
                dArrayArray[n2++] = dArray2;
            }
        }
        double[][] dArrayArray2 = new double[n2][];
        System.arraycopy(dArrayArray, 0, dArrayArray2, 0, n2);
        return dArrayArray2;
    }

    private int[] generateIntervalArray(Phrase phrase) {
        int[] nArray = new int[]{};
        try {
            nArray = PhraseAnalysis.pitchIntervals(phrase);
        }
        catch (ArrayStoreException arrayStoreException) {
            System.exit(0);
        }
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray2[i] > 127) {
                int n = i;
                nArray2[n] = nArray2[n] - 255;
            }
            nArray2[nArray.length + i] = 0 - nArray2[i];
        }
        return nArray2;
    }

    private boolean isClimaxAccepted(Phrase phrase, int n) {
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < phrase.size(); ++i) {
            int n4 = phrase.getNote(i).getPitch();
            if (n4 != Integer.MIN_VALUE) {
                if (n4 > n2) {
                    n2 = n4;
                    d2 = d;
                    n3 = 0;
                } else if (n4 == n2) {
                    ++n3;
                    d2 = d;
                }
            }
            d += phrase.getNote(i).getRhythmValue();
        }
        if (d2 < (double)(8 * n) * 0.262 || d2 > (double)(8 * n) * 0.784) {
            return false;
        }
        return n2 > phrase.getNote(0).getPitch() + 12 && n3 <= 1;
    }

    private int findClimax(Phrase phrase) {
        int n = 0;
        for (int i = 0; i < phrase.size(); ++i) {
            int n2 = phrase.getNote(i).getPitch();
            if (n2 == Integer.MIN_VALUE || n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private Note generateClimax(int n) {
        int n2 = 0;
        int n3 = n + 13;
        while (n2 == 0) {
            if (n3 % 12 == 0 || n3 % 12 == 7) {
                n2 = n3;
            }
            ++n3;
        }
        while (n2 > 88) {
            if (n3 % 12 == 0 || n3 % 12 == 7) {
                n2 = n3;
            }
            --n3;
        }
        return new Note(n2, 1.0);
    }

    private void extend(Phrase phrase, Note note, int n, double[][] dArray, int[] nArray, int n2, int n3, int n4) {
        int n5 = (int)phrase.getEndTime();
        while (n5 < n) {
            int n6;
            int n7;
            int n8;
            if (n5 == 2 * n3) {
                n8 = phrase.size() - 1;
                n7 = phrase.getNote(n8).getPitch();
                while (n7 == Integer.MIN_VALUE) {
                    n7 = phrase.getNote(--n8).getPitch();
                }
                if (n7 % 12 != 0 && n7 % 12 != 7) {
                    n6 = n7 + 1;
                    while (n6 % 12 != 0 && n6 % 12 != 7) {
                        ++n6;
                    }
                    int n9 = n7 - 1;
                    while (n9 % 12 != 0 && n9 % 12 != 7) {
                        --n9;
                    }
                    n7 = n6 > n2 ? n9 : (n9 < n4 ? n6 : (n6 - n7 > n7 - n9 ? n9 : (n7 - n9 > n6 - n7 ? n6 : n6)));
                }
                phrase.addNote(new Note(n7, 2.0));
            } else {
                n8 = n;
                n7 = 0;
                for (n6 = 0; n6 < 30 && n5 + n8 > (n5 / n3 + 1) * n3; ++n6) {
                    n7 = (int)(Math.random() * (double)dArray.length);
                    double d = 0.0;
                    for (int i = 0; i < dArray[n7].length; ++i) {
                        d += dArray[n7][i] < 0.0 ? 0.0 - dArray[n7][i] : dArray[n7][i];
                    }
                    n8 = (int)d;
                }
                if (n6 != 30) {
                    for (int i = 0; i < dArray[n7].length; ++i) {
                        this.addNote(phrase, note, n, dArray[n7][i], nArray, n2, n4);
                    }
                } else {
                    this.addNote(phrase, note, n, (n5 / n3 + 1) * n3 - n5, nArray, n2, n4);
                }
            }
            n5 = (int)phrase.getEndTime();
        }
    }

    private void addAppropriateTarget(Phrase phrase, Note note) {
        int n;
        Note note2 = note.copy();
        int n2 = phrase.size();
        while ((n = phrase.getNote(--n2).getPitch()) == Integer.MIN_VALUE) {
        }
        int n3 = note.getPitch();
        if (n + 7 < n3) {
            while ((n3 -= 12) - 12 > n) {
            }
            note2.setPitch(n3);
        }
        phrase.addNote(note2);
    }

    private void addNote(Phrase phrase, Note note, int n, double d, int[] nArray, int n2, int n3) {
        if (d < 0.0) {
            phrase.addNote(new Note(Integer.MIN_VALUE, 0.0 - d));
        } else {
            int n4;
            double d2;
            double d3;
            int n5;
            int n6 = phrase.size() - 1;
            int n7 = phrase.getNote(n6).getPitch();
            while (n7 == Integer.MIN_VALUE) {
                n7 = phrase.getNote(--n6).getPitch();
            }
            double d4 = (double)(note.getPitch() - n7) / ((double)n - phrase.getEndTime());
            int n8 = nArray[(int)(Math.random() * (double)nArray.length)];
            double d5 = (double)n8 / (double)(n5 = note.getPitch() - n7);
            if (d5 < 0.0 && Math.random() < 2.5 / ((double)n - phrase.getEndTime())) {
                n8 = 0 - n8;
            }
            if ((d3 = (d2 = (double)n5 / ((double)n - phrase.getEndTime())) / d4) >= 2.0 || d3 <= 0.5) {
                n8 /= 2;
            }
            if ((n4 = n7 + n8) >= n2 || n4 < n3) {
                n4 = n7 - n8;
            }
            if (n4 >= n2 || n4 < n3) {
                n4 = n7 - n8 / 2;
            }
            if (n4 >= n2 || n4 < n3) {
                n4 = n7 - n8 / 4;
            }
            phrase.addNote(new Note(n4, d));
        }
    }

    private void cleanMelody(Phrase phrase, int n) {
        for (int i = n; i < phrase.size(); ++i) {
            int n2 = phrase.getNote(i).getPitch();
            if (n2 == Integer.MIN_VALUE || this.isScale(n2)) continue;
            if (Math.random() < 0.5) {
                phrase.getNote(i).setPitch(n2 + 1);
                continue;
            }
            phrase.getNote(i).setPitch(n2 - 1);
        }
    }

    private boolean isScale(int n) {
        for (int i = 0; i < PhraseAnalysis.MAJOR_SCALE.length; ++i) {
            if (n % 12 != PhraseAnalysis.MAJOR_SCALE[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Panel getPanel() {
        return this.panel;
    }

    @Override
    public String getLabel() {
        return label;
    }

    public void setModifyAll(boolean bl) {
        this.modifyAll = bl;
    }
}

