/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import javax.swing.JOptionPane;
import jm.JMC;
import jm.audio.io.AudioFileIn;
import jm.midi.MidiParser;
import jm.midi.SMF;
import jm.music.data.CPhrase;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.ConversionException;
import jm.util.XMLParser;

public class Read
implements JMC {
    protected Read() {
    }

    public static void midi(Score score) {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a MIDI file to open.", 0);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Read.midi(score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public static void midi(Score score, String string) {
        if (score == null) {
            System.err.println("jMusic Read.midi error: The score is not initialised! I'm doing it for you.");
            score = new Score();
        }
        score.empty();
        SMF sMF = new SMF();
        sMF.setVerbose(true);
        try {
            System.out.println("--------------------- Reading MIDI File ---------------------");
            FileInputStream fileInputStream = new FileInputStream(string);
            sMF.read(fileInputStream);
            MidiParser.SMFToScore(score, sMF);
            System.out.println("MIDI file '" + string + "' read into score '" + score.getTitle() + "' Tempo = " + score.getTempo());
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void midi(Part part) {
        Score score = new Score();
        Read.midi(score);
        part = score.getPart(0);
    }

    public static void midi(Part part, String string) {
        Score score = new Score();
        Read.midi(score, string);
        part = score.getPart(0);
    }

    public static void midi(Phrase phrase) {
        Score score = new Score();
        Read.midi(score);
        phrase = score.getPart(0).getPhrase(0);
    }

    public static void midi(Phrase phrase, String string) {
        Part part = new Part();
        Read.midi(part, string);
        phrase = part.getPhrase(0);
    }

    public static void midi(CPhrase cPhrase, String string) {
        Score score = new Score();
        Read.midi(score, string);
        Part part = new Part();
        part = score.getPart(0);
        for (int i = 0; i < part.size(); ++i) {
            cPhrase.addPhrase(part.getPhrase(i));
        }
    }

    public static void jm(Score score) {
        Read.jm(score, score.getTitle() + ".jm");
    }

    public static void jm(Score score, String string) {
        if (score == null) {
            System.err.println("jMusic Read.jm error: The score is not initialised! I'm doing it for you.");
            score = new Score();
        }
        score.empty();
        try {
            System.out.println("--------------------- Reading .jm File ---------------------");
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            try {
                score.addPartList(((Score)objectInputStream.readObject()).getPartArray());
                System.out.println("reading");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException);
            }
            System.out.println("jm file '" + string + "' read into score '" + score.getTitle() + "'");
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void jm(Part part, String string) {
        if (part == null) {
            System.err.println("jMusic Read.jm error: The part is not initialised! I'm doing it for you.");
            part = new Part();
        }
        part.empty();
        Score score = new Score();
        Read.jm(score, string);
        part.addPhraseList(score.getPart(0).getPhraseArray());
    }

    public static void jm(Phrase phrase, String string) {
        if (phrase == null) {
            System.err.println("jMusic Read.jm error: The phrase is not initialised! I'm doing it for you.");
            phrase = new Phrase();
        }
        phrase.empty();
        Part part = new Part();
        Read.jm(part, string);
        phrase.addNoteList(part.getPhrase(0).getNoteArray());
    }

    public static void jm(CPhrase cPhrase, String string) {
        if (cPhrase == null) {
            System.err.println("jMusic Read.jm error: The CPhrase is not initialised! I'm doing it for you.");
            cPhrase = new CPhrase();
        }
        cPhrase.empty();
        Score score = new Score();
        Read.jm(score, string);
        Part part = new Part();
        part = score.getPart(0);
        for (int i = 0; i < part.size(); ++i) {
            cPhrase.addPhrase(part.getPhrase(i));
        }
    }

    public static void xml(Score score) {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a jMusic XML file to open.", 0);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Read.xml(score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public static void xml(Score score, String string) {
        if (score == null) {
            System.err.println("jMusic Read.xml error: The score is not initialised! I'm doing it for you.");
            score = new Score();
        }
        score.empty();
        try {
            System.out.println("--------------------- Reading .xml File ---------------------");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            try {
                score.addPartList(XMLParser.xmlStringToScore(bufferedReader.readLine()).getPartArray());
                System.out.println("reading");
            }
            catch (ConversionException conversionException) {
                System.err.println(conversionException);
            }
            System.out.println("xml file '" + string + "' read into score '" + score.getTitle() + "'");
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void xml(Part part, String string) {
        if (part == null) {
            System.err.println("jMusic Read.xml error: The part is not initialised! I'm doing it for you.");
            part = new Part();
        }
        part.empty();
        Score score = new Score();
        Read.xml(score, string);
        part.addPhraseList(score.getPart(0).getPhraseArray());
    }

    public static void xml(Phrase phrase, String string) {
        if (phrase == null) {
            System.err.println("jMusic Read.xml error: The phrase is not initialised! I'm doing it for you.");
            phrase = new Phrase();
        }
        phrase.empty();
        Part part = new Part();
        Read.xml(part, string);
        phrase.addNoteList(part.getPhrase(0).getNoteArray());
    }

    public static void xml(CPhrase cPhrase, String string) {
        if (cPhrase == null) {
            System.err.println("jMusic Read.xml error: The CPhrase is not initialised! I'm doing it for you.");
            cPhrase = new CPhrase();
        }
        cPhrase.empty();
        Score score = new Score();
        Read.xml(score, string);
        Part part = new Part();
        part = score.getPart(0);
        for (int i = 0; i < part.size(); ++i) {
            cPhrase.addPhrase(part.getPhrase(i));
        }
    }

    public static float[] audio(String string) {
        System.out.println("-------------------- Reading Audio File ---------------------");
        AudioFileIn audioFileIn = new AudioFileIn(string);
        float[] fArray = audioFileIn.getSampleData();
        System.out.println("File '" + string + "' read in. Details:");
        System.out.println("Channels = " + audioFileIn.getChannels() + " Samples per channel = " + audioFileIn.getDuration() / audioFileIn.getChannels() + " Sample rate = " + audioFileIn.getSampleRate() + " Bit depth = " + audioFileIn.getSampleBitDepth());
        System.out.println("-------------------------------------------------------------");
        return fArray;
    }

    public static void audio(float[] fArray, String string) {
        System.out.println("-------------------- Reading Audio File ---------------------");
        AudioFileIn audioFileIn = new AudioFileIn(string);
        fArray = audioFileIn.getSampleData();
        System.out.println("Audio file '" + string + "' read in. Details:");
        System.out.println("Channels = " + audioFileIn.getChannels() + " Samples per channel = " + audioFileIn.getDuration() / audioFileIn.getChannels() + " Sample rate = " + audioFileIn.getSampleRate() + " Bit depth = " + audioFileIn.getSampleBitDepth());
        System.out.println("-------------------------------------------------------------");
    }

    public static Score midiOrJmWithNoMessaging(File file) {
        return new JmMidiProcessor(file).getScore();
    }

    public static Score midiOrJmWithNoMessaging(String string, String string2) {
        return new JmMidiProcessor(string, string2).getScore();
    }

    public static Score midiOrJmWithAWTMessaging(File file, Frame frame) {
        JmMidiProcessor jmMidiProcessor = new JmMidiProcessor(file);
        Read.displayErrorDialog(frame, jmMidiProcessor.getMessage());
        return jmMidiProcessor.getScore();
    }

    public static Score midiOrJmWithAWTMessaging(String string, String string2, Frame frame) {
        JmMidiProcessor jmMidiProcessor = new JmMidiProcessor(string, string2);
        Read.displayErrorDialog(frame, jmMidiProcessor.getMessage());
        return jmMidiProcessor.getScore();
    }

    private static void displayErrorDialog(Frame frame, String string) {
        if (string == null) {
            return;
        }
        Dialog dialog = new Dialog(frame, "Not a valid MIDI or jMusic File", true);
        Read.completeErrorDialog(dialog, string);
    }

    private static void completeErrorDialog(final Dialog dialog, String string) {
        dialog.add((Component)new Label(string), "Center");
        Button button = new Button("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dialog.dispose();
            }
        });
        Panel panel = new Panel();
        panel.add(button);
        dialog.add((Component)panel, "South");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.show();
    }

    public static Score midiOrJmWithSwingMessaging(File file, Component component) {
        JmMidiProcessor jmMidiProcessor = new JmMidiProcessor(file);
        Read.displayErrorJDialog(component, jmMidiProcessor.getMessage());
        return jmMidiProcessor.getScore();
    }

    public static Score midiOrJmWithSwingMessaging(String string, String string2, Component component) {
        JmMidiProcessor jmMidiProcessor = new JmMidiProcessor(string, string2);
        Read.displayErrorJDialog(component, jmMidiProcessor.getMessage());
        return jmMidiProcessor.getScore();
    }

    private static void displayErrorJDialog(Component component, String string) {
        if (string == null) {
            return;
        }
        JOptionPane.showMessageDialog(component, string, "Not a valid MIDI or jMusic File", 0);
    }

    protected static class JmMidiProcessor {
        private String message = null;
        private Score score = new Score();

        public JmMidiProcessor(File file) {
            if (file == null) {
                this.message = "The selected file is null.  No JM/MIDI information could be imported.";
                this.score = null;
            } else if (file.isDirectory()) {
                this.message = "The selected file is a directory.  No JM/MIDI information could be imported.";
                this.score = null;
            } else {
                JmMidiProcessor jmMidiProcessor = new JmMidiProcessor(file.getParent() + File.separator, file.getName());
                this.message = jmMidiProcessor.getMessage();
                this.score = jmMidiProcessor.getScore();
            }
        }

        public JmMidiProcessor(String string, String string2) {
            if (string2 == null) {
                this.message = "The filename String is null.  No JM/MIDI information could be imported.";
                this.score = null;
                return;
            }
            try {
                this.score.setTitle(string2);
                SMF sMF = new SMF();
                if (string == null) {
                    FileInputStream fileInputStream = new FileInputStream(string2);
                    sMF.read(fileInputStream);
                    MidiParser.SMFToScore(this.score, sMF);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(string + string2);
                    sMF.read(fileInputStream);
                    MidiParser.SMFToScore(this.score, sMF);
                }
            }
            catch (IOException iOException) {
                this.message = iOException.getMessage();
                if (this.message == null) {
                    this.message = "Unknown IO Exception";
                    this.score = null;
                    return;
                }
                if (this.message.equals("Track Started in wrong place!!!!  ABORTING")) {
                    this.message = "The MIDI file corrupted.  Track data started in the wrong place.";
                    this.score = null;
                    return;
                }
                if (this.message.equals("This is NOT a MIDI file !!!")) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(string + string2);
                        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                        this.score = (Score)objectInputStream.readObject();
                        objectInputStream.close();
                        fileInputStream.close();
                    }
                    catch (SecurityException securityException) {
                        this.message = "Read access not allowed to " + string2;
                        this.score = null;
                        return;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.message = "The file " + string2 + " is neither a jm nor a MIDI file";
                        this.score = null;
                        return;
                    }
                    catch (ClassCastException classCastException) {
                        this.message = "The file " + string2 + " is neither a jm nor a MIDI file";
                        this.score = null;
                        return;
                    }
                    catch (StreamCorruptedException streamCorruptedException) {
                        this.message = "The file " + string2 + " is neither a jm nor a MIDI file";
                        this.score = null;
                        return;
                    }
                    catch (IOException iOException2) {
                        this.message = iOException2.getMessage();
                        if (this.message == null) {
                            this.message = "Unknown Exception.  No musical information could be imported.";
                        }
                        this.score = null;
                        return;
                    }
                }
                this.score = null;
                return;
            }
        }

        public Score getScore() {
            return this.score;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

