/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.ReadFilenameFilter;
import jm.util.ReadListener;
import jm.util.ReadListenerLinkedList;

public class ReadFilesJButton
extends JButton {
    public static final Mode SINGLE_FILE_MODE = new Mode("Single File");
    public static final Mode MULTIPLE_FILES_MODE = new Mode("Multiple Files");
    public static final Mode FOLDER_MODE = new Mode("Folder");
    private Mode mode;
    private ReadListenerLinkedList readListenerList;
    private JFileChooser chooser = new JFileChooser();
    private Component owner;

    public ReadFilesJButton(Component component) {
        this(component, MULTIPLE_FILES_MODE);
    }

    public ReadFilesJButton(final Component component, final Mode mode) {
        this.owner = component;
        this.setMode(mode);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        File file;
                        ReadFilesJButton.this.readListenerList.startedReading();
                        int n = ReadFilesJButton.this.chooser.showOpenDialog(component);
                        ReadFilesJButton.this.chooser;
                        if (n != 0) {
                            return;
                        }
                        if (mode == SINGLE_FILE_MODE) {
                            ReadFilesJButton.this.processFile(ReadFilesJButton.this.chooser.getSelectedFile());
                        } else if (mode == MULTIPLE_FILES_MODE) {
                            ReadFilesJButton.this.processFiles(ReadFilesJButton.this.chooser.getSelectedFiles());
                        } else if (mode == FOLDER_MODE && (file = ReadFilesJButton.this.chooser.getSelectedFile()).isDirectory()) {
                            String[] stringArray = file.list(new ReadFilenameFilter());
                            for (int i = 0; i < stringArray.length; ++i) {
                                ReadFilesJButton.this.processFile(new File(file.getAbsolutePath(), stringArray[i]));
                            }
                        }
                        if (ReadFilesJButton.this.readListenerList != null) {
                            ReadFilesJButton.this.readListenerList.finishedReading();
                        }
                    }
                };
                Thread thread = new Thread(runnable, "processThread");
                thread.start();
            }
        });
    }

    private void processFile(File file) {
        Score score = Read.midiOrJmWithSwingMessaging(file, this.owner);
        if (score == null) {
            return;
        }
        if (this.readListenerList != null) {
            score = this.readListenerList.scoreRead(score);
        }
    }

    private void processFiles(File[] fileArray) {
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            this.processFile(fileArray[i]);
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode == SINGLE_FILE_MODE) {
            this.setText("Read File");
            this.chooser.setDialogTitle("Select a MIDI or jMusic file to import");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setFileSelectionMode(0);
        } else if (mode == MULTIPLE_FILES_MODE) {
            this.setText("Read Files");
            this.chooser.setDialogTitle("Select MIDI and/or jMusic files to import");
            this.chooser.setMultiSelectionEnabled(true);
            this.chooser.setFileSelectionMode(0);
        } else if (mode == FOLDER_MODE) {
            this.setText("Read Folder");
            this.chooser.setDialogTitle("Select a folder of MIDI or jMusic files to import");
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setFileSelectionMode(1);
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void addReadListener(ReadListener readListener) {
        if (readListener == null) {
            return;
        }
        if (this.readListenerList == null) {
            this.readListenerList = new ReadListenerLinkedList(readListener);
        } else {
            this.readListenerList.add(readListener);
        }
    }

    public void removeReadListener(ReadListener readListener) {
        if (this.readListenerList == null) {
            return;
        }
        if (this.readListenerList.getListener() == readListener) {
            this.readListenerList = this.readListenerList.getNext();
        }
    }

    private static class Mode {
        private final String name;

        private Mode(String string) {
            this.name = string;
        }
    }
}

