/*
 * Decompiled with CFR 0.152.
 */
package jm.util;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import jm.JMC;
import jm.audio.Audio;
import jm.audio.Instrument;
import jm.audio.io.AudioFileOut;
import jm.midi.MidiParser;
import jm.midi.SMF;
import jm.music.data.CPhrase;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.XMLParser;

public class Write
implements JMC {
    public static void midi(Score score) {
        FileDialog fileDialog = new FileDialog(new Frame(), "Save as a MIDI file ...", 1);
        fileDialog.setFile("jMusic_composition.mid");
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.midi(score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public static void midi(Score score, OutputStream outputStream) {
        SMF sMF = new SMF();
        try {
            sMF.clearTracks();
            MidiParser.scoreToSMF(score, sMF);
            sMF.write(outputStream);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void midi(Score score, String string) {
        SMF sMF = new SMF();
        try {
            double d = System.currentTimeMillis();
            System.out.println("----------------------------- Writing MIDI File ------------------------------");
            sMF.clearTracks();
            MidiParser.scoreToSMF(score, sMF);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            sMF.write(fileOutputStream);
            double d2 = System.currentTimeMillis();
            System.out.println("MIDI file '" + string + "' written from score '" + score.getTitle() + "' in " + (d2 - d) / 1000.0 + " seconds.");
            System.out.println("------------------------------------------------------------------------------");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void midi(Part part) {
        Write.midi(new Score(part));
    }

    public static void midi(Part part, String string) {
        Score score = new Score("Score of " + part.getTitle());
        score.addPart(part);
        Write.midi(score, string);
    }

    public static void midi(Phrase phrase) {
        Write.midi(new Score(new Part(phrase)));
    }

    public static void midi(Phrase phrase, String string) {
        Part part = new Part();
        part.addPhrase(phrase);
        Score score = new Score("Score of " + phrase.getTitle());
        score.addPart(part);
        Write.midi(score, string);
    }

    public static void midi(CPhrase cPhrase) {
        Part part = new Part();
        part.addCPhrase(cPhrase);
        Score score = new Score("Score of " + cPhrase.getTitle());
        score.addPart(part);
        Write.midi(score, cPhrase.getTitle() + ".mid");
    }

    public static void midi(CPhrase cPhrase, String string) {
        Part part = new Part();
        part.addCPhrase(cPhrase);
        Score score = new Score("Score of " + cPhrase.getTitle());
        score.addPart(part);
        Write.midi(score, string);
    }

    public static void midi(Note note) {
        Write.midi(note, "SingleNote.mid");
    }

    public static void midi(Note note, String string) {
        Score score = new Score("Score of a single note");
        Part part = new Part(new Phrase(note));
        score.addPart(part);
        Write.midi(score, string);
    }

    public static void jm(Score score) {
        Write.jm(score, score.getTitle() + ".jm");
    }

    public static void jm(Score score, String string) {
        try {
            System.out.println("--------------------- Writing JM File -----------------------");
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(score);
            objectOutputStream.flush();
            objectOutputStream.close();
            System.out.println("JM file '" + string + "' written from score '" + score.getTitle() + "'");
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void jm(Part part) {
        Score score = new Score("Score of " + part.getTitle());
        score.addPart(part);
        Write.jm(score, part.getTitle() + ".jm");
    }

    public static void jm(Part part, String string) {
        Score score = new Score("Score of " + part.getTitle());
        score.addPart(part);
        Write.jm(score, string);
    }

    public static void jm(Phrase phrase) {
        Part part = new Part();
        part.addPhrase(phrase);
        Score score = new Score("Score of " + phrase.getTitle());
        score.addPart(part);
        Write.jm(score, phrase.getTitle() + ".jm");
    }

    public static void jm(Phrase phrase, String string) {
        Part part = new Part();
        part.addPhrase(phrase);
        Score score = new Score("Score of " + phrase.getTitle());
        score.addPart(part);
        Write.jm(score, string);
    }

    public static void jm(CPhrase cPhrase) {
        Part part = new Part();
        part.addCPhrase(cPhrase);
        Score score = new Score("Score of " + cPhrase.getTitle());
        score.addPart(part);
        Write.jm(score, cPhrase.getTitle() + ".jm");
    }

    public static void jm(CPhrase cPhrase, String string) {
        Part part = new Part();
        part.addCPhrase(cPhrase);
        Score score = new Score("Score of " + cPhrase.getTitle());
        score.addPart(part);
        Write.jm(score, string);
    }

    public static void au(Phrase phrase, Instrument instrument) {
        Write.au(new Part(phrase), instrument);
    }

    public static void au(Part part, Instrument instrument) {
        Write.au(new Score(part), instrument);
    }

    public static void au(Score score, Instrument instrument) {
        Instrument[] instrumentArray = new Instrument[]{instrument};
        Write.au(score, score.getTitle() + ".au", instrumentArray);
    }

    public static void au(Score score, Instrument[] instrumentArray) {
        Write.au(score, score.getTitle() + ".au", instrumentArray);
    }

    public static void au(Score score, String string, Instrument instrument) {
        Instrument[] instrumentArray = new Instrument[]{instrument};
        Write.au(score, string, instrumentArray);
    }

    public static void au(Score score, String string, Instrument[] instrumentArray) {
        double d = System.currentTimeMillis();
        System.out.println("------------------------------ Writing AU File --------------------------------");
        String string2 = string + ".jpf";
        String string3 = "jmusic.tmp";
        File file = new File(string3);
        if (file.exists()) {
            file.delete();
        }
        Audio.processScore(score, instrumentArray, string2);
        Audio.combine(string2, string3, string, true, true);
        double d2 = System.currentTimeMillis();
        System.out.println("AU file '" + string + "' written from score '" + score.getTitle() + "' in " + (d2 - d) / 1000.0 + " seconds.");
        System.out.println("-------------------------------------------------------------------------------");
    }

    public static void au(Part part, Instrument[] instrumentArray) {
        Score score = new Score("Score of " + part.getTitle());
        score.addPart(part);
        Write.au(score, part.getTitle() + ".au", instrumentArray);
    }

    public static void au(Part part, String string, Instrument instrument) {
        Score score = new Score("Score of " + part.getTitle());
        score.addPart(part);
        Instrument[] instrumentArray = new Instrument[]{instrument};
        Write.au(score, string, instrumentArray);
    }

    public static void au(Part part, String string, Instrument[] instrumentArray) {
        Score score = new Score("Score of " + part.getTitle());
        score.addPart(part);
        Write.au(score, string, instrumentArray);
    }

    public static void au(Phrase phrase, Instrument[] instrumentArray) {
        Part part = new Part();
        part.addPhrase(phrase);
        Score score = new Score("Score of " + phrase.getTitle());
        score.addPart(part);
        Write.au(score, phrase.getTitle() + ".au", instrumentArray);
    }

    public static void au(Phrase phrase, String string, Instrument[] instrumentArray) {
        Part part = new Part();
        part.addPhrase(phrase);
        Score score = new Score("Score of " + phrase.getTitle());
        score.addPart(part);
        Write.au(score, string, instrumentArray);
    }

    public static void au(Phrase phrase, String string, Instrument instrument) {
        Part part = new Part();
        part.addPhrase(phrase);
        Score score = new Score("Score of " + phrase.getTitle());
        score.addPart(part);
        Instrument[] instrumentArray = new Instrument[]{instrument};
        Write.au(score, string, instrumentArray);
    }

    public static void au(CPhrase cPhrase, Instrument[] instrumentArray) {
        Part part = new Part();
        part.addCPhrase(cPhrase);
        Score score = new Score("Score of " + cPhrase.getTitle());
        score.addPart(part);
        Write.au(score, cPhrase.getTitle() + ".au", instrumentArray);
    }

    public static void au(CPhrase cPhrase, String string, Instrument[] instrumentArray) {
        Part part = new Part();
        part.addCPhrase(cPhrase);
        Score score = new Score("Score of " + cPhrase.getTitle());
        score.addPart(part);
        Write.au(score, string, instrumentArray);
    }

    public static void audio(float[] fArray, String string) {
        Write.audio(fArray, string, 1, 44100, 16);
    }

    public static void audio(float[] fArray, String string, int n, int n2, int n3) {
        double d = System.currentTimeMillis();
        System.out.println("---------------------------- Writing Audio File -------------------------------");
        AudioFileOut audioFileOut = new AudioFileOut(fArray, string, n, n2, n3);
        double d2 = System.currentTimeMillis();
        System.out.println("Audio file '" + string + "' written in " + (d2 - d) / 1000.0 + " seconds.");
        System.out.println("Channels = " + n + " Sample rate = " + n2 + " Bit depth = " + n3);
        System.out.println("-------------------------------------------------------------------------------");
    }

    public static void xml(Score score) {
        Write.xml(score, score.getTitle() + ".xml");
    }

    public static void xml(Score score, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            System.out.println("--------------------- Writing XML File -----------------------");
            String string2 = XMLParser.scoreToXMLString(score);
            printWriter.print(string2);
            printWriter.close();
            System.out.println("XML file '" + string + "' written from score '" + score.getTitle() + "'");
            System.out.println("-------------------------------------------------------------");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static void xml(Part part) {
        Score score = new Score("Score of " + part.getTitle());
        score.addPart(part);
        Write.xml(score, part.getTitle() + ".xml");
    }

    public static void xml(Part part, String string) {
        Score score = new Score("Score of " + part.getTitle());
        score.addPart(part);
        Write.xml(score, string);
    }

    public static void xml(Phrase phrase) {
        Part part = new Part();
        part.addPhrase(phrase);
        Score score = new Score("Score of " + phrase.getTitle());
        score.addPart(part);
        Write.xml(score, phrase.getTitle() + ".xml");
    }

    public static void xml(Phrase phrase, String string) {
        Part part = new Part();
        part.addPhrase(phrase);
        Score score = new Score("Score of " + phrase.getTitle());
        score.addPart(part);
        Write.xml(score, string);
    }

    public static void xml(CPhrase cPhrase) {
        Part part = new Part();
        part.addCPhrase(cPhrase);
        Score score = new Score("Score of " + cPhrase.getTitle());
        score.addPart(part);
        Write.xml(score, cPhrase.getTitle() + ".xml");
    }

    public static void xml(CPhrase cPhrase, String string) {
        Part part = new Part();
        part.addCPhrase(cPhrase);
        Score score = new Score("Score of " + cPhrase.getTitle());
        score.addPart(part);
        Write.xml(score, string);
    }

    private static Score adjustTempo(Score score) {
        Enumeration enumeration = score.getPartList().elements();
        double d = 60.0 / score.getTempo();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            double d2 = d;
            if (part.getTempo() != 0.0) {
                d2 = 60.0 / part.getTempo();
            }
            Enumeration enumeration2 = part.getPhraseList().elements();
            while (enumeration2.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration2.nextElement();
                Enumeration enumeration3 = phrase.getNoteList().elements();
                while (enumeration3.hasMoreElements()) {
                    Note note = (Note)enumeration3.nextElement();
                    note.setRhythmValue(note.getRhythmValue() * d2);
                    note.setDuration(note.getDuration() * d2);
                }
            }
        }
        return score;
    }
}

