/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.license.ng;

import clover.cenqua_com_licensing.atlassian.commons.codec.binary.Base64;
import clover.cenqua_com_licensing.atlassian.license.LicenseException;
import clover.cenqua_com_licensing.atlassian.license.LicensePair;
import clover.cenqua_com_licensing.atlassian.license.ng.AtlassianLicense;
import clover.cenqua_com_licensing.atlassian.license.ng.AtlassianProduct;
import clover.cenqua_com_licensing.atlassian.license.ng.AtlassianProductLicense;
import clover.cenqua_com_licensing.atlassian.license.ng.ConfluenceLicense;
import clover.cenqua_com_licensing.atlassian.license.ng.ConfluenceLicenseBuilder;
import clover.cenqua_com_licensing.atlassian.license.ng.DefaultPropertiesPersister;
import clover.cenqua_com_licensing.atlassian.license.ng.ProductLicenseBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class LicenseManager {
    private static Map LICENSE_CONTENT = null;
    private static final Map LICENSE_BUILDERS = new HashMap();
    private static final PublicKey PUBLIC_KEY;

    public static void addLicenseBuilder(String productNameSpace, ProductLicenseBuilder builder) {
        LICENSE_BUILDERS.put(productNameSpace, builder);
    }

    public static final void resetLicense() {
        LICENSE_CONTENT = null;
    }

    public static final AtlassianLicense getLicense(AtlassianProduct product) throws LicenseException {
        ProductLicenseBuilder builder = (ProductLicenseBuilder)LICENSE_BUILDERS.get(product.getNameSpace());
        if (builder != null && LICENSE_CONTENT != null) {
            return builder.build(LICENSE_CONTENT, product);
        }
        if (LICENSE_CONTENT != null) {
            return new AtlassianProductLicense(LICENSE_CONTENT, product);
        }
        return null;
    }

    public static final void registerLicense(String licenseData) throws LicenseException {
        Properties license = LicenseManager.decode(licenseData);
        if (license == null) {
            throw new LicenseException("License is invalid and could not be decoded");
        }
        LicenseManager.registerLicense(license);
    }

    public static void registerLicense(LicensePair pair) throws LicenseException {
        LicenseManager.registerLicense(pair.getLicense());
    }

    private static void registerLicense(byte[] licenseText) throws LicenseException {
        LicenseManager.registerLicense(LicenseManager.loadLicense(licenseText));
    }

    private static void registerLicense(Properties prop) throws LicenseException {
        LICENSE_CONTENT = Collections.unmodifiableMap(prop);
    }

    private static Properties loadLicense(byte[] licenseText) throws LicenseException {
        Properties prop = new Properties();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(licenseText);
            in.skip(LicensePair.NEW_LICENSE_PREFIX.length);
            InflaterInputStream zipIn = new InflaterInputStream(in, new Inflater());
            DefaultPropertiesPersister.load(prop, new InputStreamReader(zipIn));
        }
        catch (IOException e) {
            throw new LicenseException("Failed to load the license.", e);
        }
        return prop;
    }

    static final Properties decode(String licenseData) throws LicenseException {
        LicensePair pair = LicenseManager.toLicensePair(licenseData);
        if (pair == null) {
            return null;
        }
        return LicenseManager.loadLicense(pair.getLicense());
    }

    public static LicensePair toLicensePair(String licenseData) throws LicenseException {
        int lengthStr;
        int pos = (licenseData = LicenseManager.removeWhiteSpaces(licenseData)).lastIndexOf(88);
        if (pos == -1 || pos + 3 >= licenseData.length()) {
            return null;
        }
        try {
            String string = licenseData.substring(pos + 1, pos + 3);
            if (Integer.parseInt(string) != 1) {
                return null;
            }
            String versionStr = licenseData.substring(pos + 3);
            lengthStr = Integer.valueOf(versionStr, 31);
        }
        catch (NumberFormatException encodedLicenseLength) {
            return null;
        }
        String encodedLicenseLength = licenseData.substring(0, pos);
        if (encodedLicenseLength.length() != lengthStr) {
            throw new LicenseException("Invalid license length. The license can not be decoded.");
        }
        try {
            byte[] licenseContent = Base64.decodeBase64(encodedLicenseLength.getBytes());
            ByteArrayInputStream in = new ByteArrayInputStream(licenseContent);
            DataInputStream dIn = new DataInputStream(in);
            int textLength = dIn.readInt();
            byte[] text = new byte[textLength];
            dIn.read(text);
            byte[] hash = new byte[dIn.available()];
            dIn.read(hash);
            try {
                Signature signature = Signature.getInstance("SHA1withDSA");
                signature.initVerify(PUBLIC_KEY);
                signature.update(text);
                if (!signature.verify(hash)) {
                    throw new LicenseException("Failed to verify the license.");
                }
                return new LicensePair(text, hash, licenseData);
            }
            catch (InvalidKeyException e) {
                throw new LicenseException(e);
            }
            catch (SignatureException e) {
                throw new LicenseException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new LicenseException(e);
            }
        }
        catch (IOException licenseContent) {
            throw new LicenseException(licenseContent);
        }
    }

    public static String packNewLicense(byte[] text, byte[] hash) throws LicenseException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dOut = new DataOutputStream(out);
            dOut.writeInt(text.length);
            dOut.write(text);
            dOut.write(hash);
            byte[] allData = out.toByteArray();
            String result = new String(Base64.encodeBase64(allData)).trim();
            result = result + 'X' + "01" + Integer.toString(result.length(), 31);
            result = LicenseManager.split(result);
            return result;
        }
        catch (IOException e) {
            throw new LicenseException(e);
        }
    }

    private static String split(String licenseData) {
        if (licenseData == null || licenseData.length() == 0) {
            return licenseData;
        }
        char[] chars = licenseData.toCharArray();
        StringBuffer buf = new StringBuffer(chars.length + chars.length / 76);
        for (int i = 0; i < chars.length; ++i) {
            buf.append(chars[i]);
            if (i <= 0 || i % 76 != 0) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    private static String removeWhiteSpaces(String licenseData) {
        if (licenseData == null || licenseData.length() == 0) {
            return licenseData;
        }
        char[] chars = licenseData.toCharArray();
        StringBuffer buf = new StringBuffer(chars.length);
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            buf.append(chars[i]);
        }
        return buf.toString();
    }

    static {
        try {
            String pubKeyEncoded = "MIIBuDCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYUAAoGBAIvfweZvmGo5otwawI3no7Udanxal3hX2haw962KL/nHQrnC4FG2PvUFf34OecSK1KtHDPQoSQ+DHrfdf6vKUJphw0Kn3gXm4LS8VK/LrY7on/wh2iUobS2XlhuIqEc5mLAUu9Hd+1qxsQkQ50d0lzKrnDqPsM0WA9htkdJJw2nS";
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PUBLIC_KEY = keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decodeBase64(pubKeyEncoded.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        catch (InvalidKeySpecException e) {
            throw new Error(e);
        }
        ConfluenceLicenseBuilder confluenceLicenseBuilder = new ConfluenceLicenseBuilder();
        LicenseManager.addLicenseBuilder(ConfluenceLicense.PRODUCT_NAME_SPACE, confluenceLicenseBuilder);
    }
}

