/*
 * Decompiled with CFR 0.152.
 */
package clover.cenqua_com_licensing.atlassian.time.chrono;

import clover.cenqua_com_licensing.atlassian.time.Chronology;
import clover.cenqua_com_licensing.atlassian.time.DateTimeField;
import clover.cenqua_com_licensing.atlassian.time.DateTimeFieldType;
import clover.cenqua_com_licensing.atlassian.time.DateTimeZone;
import clover.cenqua_com_licensing.atlassian.time.DurationField;
import clover.cenqua_com_licensing.atlassian.time.DurationFieldType;
import clover.cenqua_com_licensing.atlassian.time.IllegalFieldValueException;
import clover.cenqua_com_licensing.atlassian.time.ReadablePartial;
import clover.cenqua_com_licensing.atlassian.time.ReadablePeriod;
import clover.cenqua_com_licensing.atlassian.time.field.FieldUtils;
import clover.cenqua_com_licensing.atlassian.time.field.UnsupportedDateTimeField;
import clover.cenqua_com_licensing.atlassian.time.field.UnsupportedDurationField;
import java.io.Serializable;

public abstract class BaseChronology
extends Chronology
implements Serializable {
    private static final long serialVersionUID = -7310865996721419676L;

    protected BaseChronology() {
    }

    public abstract DateTimeZone getZone();

    public abstract Chronology withUTC();

    public abstract Chronology withZone(DateTimeZone var1);

    public long getDateTimeMillis(int n, int n2, int n3, int n4) throws IllegalArgumentException {
        long l = this.year().set(0L, n);
        l = this.monthOfYear().set(l, n2);
        l = this.dayOfMonth().set(l, n3);
        return this.millisOfDay().set(l, n4);
    }

    public long getDateTimeMillis(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws IllegalArgumentException {
        long l = this.year().set(0L, n);
        l = this.monthOfYear().set(l, n2);
        l = this.dayOfMonth().set(l, n3);
        l = this.hourOfDay().set(l, n4);
        l = this.minuteOfHour().set(l, n5);
        l = this.secondOfMinute().set(l, n6);
        return this.millisOfSecond().set(l, n7);
    }

    public long getDateTimeMillis(long l, int n, int n2, int n3, int n4) throws IllegalArgumentException {
        l = this.hourOfDay().set(l, n);
        l = this.minuteOfHour().set(l, n2);
        l = this.secondOfMinute().set(l, n3);
        return this.millisOfSecond().set(l, n4);
    }

    public void validate(ReadablePartial readablePartial, int[] nArray) {
        int n;
        int n2 = readablePartial.size();
        int n3 = 0;
        while (n3 < n2) {
            n = nArray[n3];
            DateTimeField dateTimeField = readablePartial.getField(n3);
            if (n < dateTimeField.getMinimumValue()) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)new Integer(n), (Number)new Integer(dateTimeField.getMinimumValue()), null);
            }
            if (n > dateTimeField.getMaximumValue()) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)new Integer(n), null, (Number)new Integer(dateTimeField.getMaximumValue()));
            }
            ++n3;
        }
        n = 0;
        while (n < n2) {
            int n4 = nArray[n];
            DateTimeField dateTimeField = readablePartial.getField(n);
            if (n4 < dateTimeField.getMinimumValue(readablePartial, nArray)) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)new Integer(n4), (Number)new Integer(dateTimeField.getMinimumValue(readablePartial, nArray)), null);
            }
            if (n4 > dateTimeField.getMaximumValue(readablePartial, nArray)) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)new Integer(n4), null, (Number)new Integer(dateTimeField.getMaximumValue(readablePartial, nArray)));
            }
            ++n;
        }
    }

    public int[] get(ReadablePartial readablePartial, long l) {
        int n = readablePartial.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = readablePartial.getFieldType(n2).getField(this).get(l);
            ++n2;
        }
        return nArray;
    }

    public long set(ReadablePartial readablePartial, long l) {
        int n = 0;
        int n2 = readablePartial.size();
        while (n < n2) {
            l = readablePartial.getFieldType(n).getField(this).set(l, readablePartial.getValue(n));
            ++n;
        }
        return l;
    }

    public int[] get(ReadablePeriod readablePeriod, long l, long l2) {
        int n = readablePeriod.size();
        int[] nArray = new int[n];
        if (l != l2) {
            int n2 = 0;
            while (n2 < n) {
                DurationField durationField = readablePeriod.getFieldType(n2).getField(this);
                int n3 = durationField.getDifference(l2, l);
                l = durationField.add(l, n3);
                nArray[n2] = n3;
                ++n2;
            }
        }
        return nArray;
    }

    public int[] get(ReadablePeriod readablePeriod, long l) {
        int n = readablePeriod.size();
        int[] nArray = new int[n];
        if (l != 0L) {
            long l2 = 0L;
            int n2 = 0;
            while (n2 < n) {
                DurationField durationField = readablePeriod.getFieldType(n2).getField(this);
                if (durationField.isPrecise()) {
                    int n3 = durationField.getDifference(l, l2);
                    l2 = durationField.add(l2, n3);
                    nArray[n2] = n3;
                }
                ++n2;
            }
        }
        return nArray;
    }

    public long add(ReadablePeriod readablePeriod, long l, int n) {
        if (n != 0 && readablePeriod != null) {
            int n2 = 0;
            int n3 = readablePeriod.size();
            while (n2 < n3) {
                long l2 = readablePeriod.getValue(n2);
                if (l2 != 0L) {
                    l = readablePeriod.getFieldType(n2).getField(this).add(l, l2 * (long)n);
                }
                ++n2;
            }
        }
        return l;
    }

    public long add(long l, long l2, int n) {
        if (l2 == 0L || n == 0) {
            return l;
        }
        long l3 = FieldUtils.safeMultiply(l2, n);
        return FieldUtils.safeAdd(l, l3);
    }

    public DurationField millis() {
        return UnsupportedDurationField.getInstance(DurationFieldType.millis());
    }

    public DateTimeField millisOfSecond() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfSecond(), this.millis());
    }

    public DateTimeField millisOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfDay(), this.millis());
    }

    public DurationField seconds() {
        return UnsupportedDurationField.getInstance(DurationFieldType.seconds());
    }

    public DateTimeField secondOfMinute() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfMinute(), this.seconds());
    }

    public DateTimeField secondOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfDay(), this.seconds());
    }

    public DurationField minutes() {
        return UnsupportedDurationField.getInstance(DurationFieldType.minutes());
    }

    public DateTimeField minuteOfHour() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfHour(), this.minutes());
    }

    public DateTimeField minuteOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfDay(), this.minutes());
    }

    public DurationField hours() {
        return UnsupportedDurationField.getInstance(DurationFieldType.hours());
    }

    public DateTimeField hourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfDay(), this.hours());
    }

    public DateTimeField clockhourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfDay(), this.hours());
    }

    public DurationField halfdays() {
        return UnsupportedDurationField.getInstance(DurationFieldType.halfdays());
    }

    public DateTimeField hourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfHalfday(), this.hours());
    }

    public DateTimeField clockhourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfHalfday(), this.hours());
    }

    public DateTimeField halfdayOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.halfdayOfDay(), this.halfdays());
    }

    public DurationField days() {
        return UnsupportedDurationField.getInstance(DurationFieldType.days());
    }

    public DateTimeField dayOfWeek() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfWeek(), this.days());
    }

    public DateTimeField dayOfMonth() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfMonth(), this.days());
    }

    public DateTimeField dayOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfYear(), this.days());
    }

    public DurationField weeks() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weeks());
    }

    public DateTimeField weekOfWeekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekOfWeekyear(), this.weeks());
    }

    public DurationField weekyears() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weekyears());
    }

    public DateTimeField weekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyear(), this.weekyears());
    }

    public DateTimeField weekyearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyearOfCentury(), this.weekyears());
    }

    public DurationField months() {
        return UnsupportedDurationField.getInstance(DurationFieldType.months());
    }

    public DateTimeField monthOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.monthOfYear(), this.months());
    }

    public DurationField years() {
        return UnsupportedDurationField.getInstance(DurationFieldType.years());
    }

    public DateTimeField year() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.year(), this.years());
    }

    public DateTimeField yearOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfEra(), this.years());
    }

    public DateTimeField yearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfCentury(), this.years());
    }

    public DurationField centuries() {
        return UnsupportedDurationField.getInstance(DurationFieldType.centuries());
    }

    public DateTimeField centuryOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.centuryOfEra(), this.centuries());
    }

    public DurationField eras() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public DateTimeField era() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.era(), this.eras());
    }

    public abstract String toString();
}

