/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.longs.LongCollection;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongIterators;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractLongCollection
implements LongCollection {
    protected AbstractLongCollection() {
    }

    public long[] toArray(long[] a) {
        return this.toLongArray(a);
    }

    public long[] toLongArray() {
        return this.toLongArray(null);
    }

    public long[] toLongArray(long[] a) {
        if (a == null || a.length < this.size()) {
            a = new long[this.size()];
        }
        LongIterators.unwrap(this.longIterator(), a);
        return a;
    }

    public boolean addAll(LongCollection c) {
        boolean retVal = false;
        LongIterator i = c.longIterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.nextLong())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean containsAll(LongCollection c) {
        LongIterator i = c.longIterator();
        int n = c.size();
        while (n-- != 0) {
            if (this.contains(i.nextLong())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(LongCollection c) {
        boolean retVal = false;
        int n = this.size();
        LongIterator i = this.longIterator();
        while (n-- != 0) {
            if (c.contains(i.nextLong())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(LongCollection c) {
        boolean retVal = false;
        int n = c.size();
        LongIterator i = c.longIterator();
        while (n-- != 0) {
            if (!this.rem(i.nextLong())) continue;
            retVal = true;
        }
        return retVal;
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            a = new Object[this.size()];
        } else if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap((Iterator)this.longIterator(), a);
        return a;
    }

    public boolean addAll(Collection c) {
        boolean retVal = false;
        Iterator i = c.iterator();
        int n = c.size();
        while (n-- != 0) {
            if (!this.add(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(long k) {
        throw new UnsupportedOperationException();
    }

    public boolean rem(long k) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object ok) {
        return this.rem((Long)ok);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.longIterator();
    }

    public boolean add(Object o) {
        return this.add((Long)o);
    }

    public boolean rem(Object o) {
        return this.rem((Long)o);
    }

    public boolean contains(Object o) {
        return this.contains((Long)o);
    }

    public boolean containsAll(Collection c) {
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        boolean retVal = false;
        int n = this.size();
        Iterator i = this.iterator();
        while (n-- != 0) {
            if (c.contains(i.next())) continue;
            i.remove();
            retVal = true;
        }
        return retVal;
    }

    public boolean removeAll(Collection c) {
        boolean retVal = false;
        int n = c.size();
        Iterator i = c.iterator();
        while (n-- != 0) {
            if (!this.remove(i.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        LongIterator i = this.longIterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            long k = i.nextLong();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

