/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ObjectLinkedOpenHashSet
extends AbstractObjectSortedSet
implements Serializable,
Cloneable,
Hash,
ObjectSortedSet {
    protected transient Object[] key;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected transient int growthFactor = 16;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public ObjectLinkedOpenHashSet(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.state = new byte[this.free];
        this.link = new int[this.free];
    }

    public ObjectLinkedOpenHashSet(int n) {
        this(n, 0.75f);
    }

    public ObjectLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    public ObjectLinkedOpenHashSet(Collection c, float f) {
        this(c.size(), f);
        this.addAll(c);
    }

    public ObjectLinkedOpenHashSet(Collection c) {
        this(c, 0.75f);
    }

    public ObjectLinkedOpenHashSet(ObjectCollection c, float f) {
        this(c.size(), f);
        this.addAll((Collection)c);
    }

    public ObjectLinkedOpenHashSet(ObjectCollection c) {
        this(c, 0.75f);
    }

    public ObjectLinkedOpenHashSet(ObjectIterator i, float f) {
        this(16, f);
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public ObjectLinkedOpenHashSet(ObjectIterator i) {
        this(i, 0.75f);
    }

    public ObjectLinkedOpenHashSet(Object[] a, int offset, int length, float f) {
        this(length < 0 ? 0 : length, f);
        ObjectArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public ObjectLinkedOpenHashSet(Object[] a, int offset, int length) {
        this(a, offset, length, 0.75f);
    }

    public ObjectLinkedOpenHashSet(Object[] a, float f) {
        this(a, 0, a.length, f);
    }

    public ObjectLinkedOpenHashSet(Object[] a) {
        this(a, 0.75f);
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key;
        int n;
        byte[] state = this.state;
        int h = k == null ? 0 : k.hashCode();
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % (n = (key = this.key).length);
        if (state[h1] == -1 && !(k != null ? h == key[h1].hashCode() && k.equals(key[h1]) : key[h1] == null)) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] == -1 && !(k == null ? key[h1] == null : h == key[h1].hashCode() && k.equals(key[h1]))) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (state[h1] != 0 && !(k != null ? h == key[h1].hashCode() && k.equals(key[h1]) : key[h1] == null)) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && !(k == null ? key[h1] == null : h == key[h1].hashCode() && k.equals(key[h1]))) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key;
        int n;
        byte[] state = this.state;
        int h = k == null ? 0 : k.hashCode();
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % (n = (key = this.key).length);
        if (state[h1] != 0 && !(k != null ? h == key[h1].hashCode() && k.equals(key[h1]) : key[h1] == null)) {
            int h2 = k2i % (n - 2) + 1;
            while (state[h1 = (h1 + h2) % n] != 0 && !(k == null ? key[h1] == null : h == key[h1].hashCode() && k.equals(key[h1]))) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public boolean add(Object k) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            return false;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        if (this.count == 0) {
            this.first = this.last = i;
            this.link[i] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~i;
            this.link[i] = ~this.last;
            this.last = i;
        }
        if (++this.count >= this.maxFill) {
            int newP = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[newP] == PRIMES[this.p]) {
                ++newP;
            }
            this.rehash(newP);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return true;
    }

    public boolean remove(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return false;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        this.fixPointers(i);
        return true;
    }

    public boolean contains(Object k) {
        return this.findKey(k) >= 0;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill(this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    private void fixPointers(int i) {
        int next;
        if (this.count == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    public Object first() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    public Object last() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    public SortedSet tailSet(Object from) {
        throw new UnsupportedOperationException();
    }

    public SortedSet headSet(Object to) {
        throw new UnsupportedOperationException();
    }

    public SortedSet subSet(Object from, Object to) {
        throw new UnsupportedOperationException();
    }

    public Comparator comparator() {
        return null;
    }

    public ObjectBidirectionalIterator iterator(Object from) {
        return new SetIterator(from);
    }

    public ObjectIterator objectIterator() {
        return new SetIterator();
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newP) {
        int i = this.first;
        int j = this.count;
        int prev = -1;
        int newPrev = -1;
        int newN = PRIMES[newP];
        Object[] key = this.key;
        Object[] newKey = new Object[newN];
        byte[] state = this.state;
        byte[] newState = new byte[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        while (j-- != 0) {
            Object k = key[i];
            int k2i = (k == null ? 0 : k.hashCode()) & Integer.MAX_VALUE;
            int h1 = k2i % newN;
            if (newState[h1] != 0) {
                int h2 = k2i % (newN - 2) + 1;
                while (newState[h1 = (h1 + h2) % newN] != 0) {
                }
            }
            newState[h1] = -1;
            newKey[h1] = k;
            int t = i;
            i = link[i] ^ prev;
            prev = t;
            if (this.first != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ h1;
                newLink[h1] = newPrev;
                newPrev = h1;
                continue;
            }
            newPrev = this.first = h1;
            newLink[h1] = -1;
        }
        this.p = newP;
        this.free = newN - this.count;
        this.maxFill = (int)((float)newN * this.f);
        this.key = newKey;
        this.state = newState;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object clone() {
        ObjectLinkedOpenHashSet c;
        try {
            c = (ObjectLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.key = (Object[])this.key.clone();
        c.state = (byte[])this.state.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (this.state[i] != -1) {
                ++i;
            }
            if (this != this.key[i]) {
                h += this.key[i] == null ? 0 : this.key[i].hashCode();
            }
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectIterator i = this.objectIterator();
        int j = this.count;
        s.defaultWriteObject();
        while (j-- != 0) {
            s.writeObject(i.next());
        }
    }

    private void checkTable() {
        Object k;
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.contains(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
        ObjectBidirectionalIterator i = (ObjectBidirectionalIterator)this.iterator();
        n = this.size();
        while (n-- != 0) {
            k = i.next();
            if (!this.contains(k)) {
                throw new AssertionError((Object)("Linked hash table forward enumerates key " + k + ", but the key does not belong to the table"));
            }
        }
        if (i.hasNext()) {
            throw new AssertionError((Object)"Forward iterator not exhausted");
        }
        n = this.size();
        if (n > 0) {
            i = this.iterator(this.last());
            while (n-- != 0) {
                k = i.previous();
                if (!this.contains(k)) {
                    throw new AssertionError((Object)("Linked hash table backward enumerates key " + k + ", but the key does not belong to the table"));
                }
            }
            if (i.hasPrevious()) {
                throw new AssertionError((Object)"Previous iterator not exhausted");
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.state = new byte[n];
        byte[] state = this.state;
        this.link = new int[n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.count;
        while (i-- != 0) {
            Object k = s.readObject();
            int k2i = (k == null ? 0 : k.hashCode()) & Integer.MAX_VALUE;
            int h1 = k2i % n;
            if (state[h1] != 0) {
                int h2 = k2i % (n - 2) + 1;
                while (state[h1 = (h1 + h2) % n] != 0) {
                }
            }
            state[h1] = -1;
            key[h1] = k;
            if (this.first != -1) {
                int n2 = prev;
                link[n2] = link[n2] ^ h1;
                link[h1] = prev;
                prev = h1;
                continue;
            }
            prev = this.first = h1;
            link[h1] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n3 = prev;
            link[n3] = ~link[n3];
        }
    }

    private class SetIterator
    extends AbstractObjectListIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        SetIterator() {
            this.next = ObjectLinkedOpenHashSet.this.first;
        }

        SetIterator(Object from) {
            if (ObjectLinkedOpenHashSet.this.key[ObjectLinkedOpenHashSet.this.last] == null ? from == null : ObjectLinkedOpenHashSet.this.key[ObjectLinkedOpenHashSet.this.last].equals(from)) {
                this.prev = ObjectLinkedOpenHashSet.this.last;
                this.index = ObjectLinkedOpenHashSet.this.count;
            } else {
                Object k;
                if (!ObjectLinkedOpenHashSet.this.contains(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = ObjectLinkedOpenHashSet.this.first;
                while (!((k = this.next()) == null ? from == null : k.equals(from))) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next;
            this.next = ObjectLinkedOpenHashSet.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return ObjectLinkedOpenHashSet.this.key[this.curr];
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev;
            this.prev = ObjectLinkedOpenHashSet.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return ObjectLinkedOpenHashSet.this.key[this.curr];
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            ObjectLinkedOpenHashSet.this.state[this.curr] = 1;
            ObjectLinkedOpenHashSet.this.key[this.curr] = HashCommon.REMOVED;
            if (this.curr == this.prev) {
                --this.index;
                this.prev = ObjectLinkedOpenHashSet.this.link[this.curr] ^ this.next;
            } else {
                this.next = ObjectLinkedOpenHashSet.this.link[this.curr] ^ this.prev;
            }
            --ObjectLinkedOpenHashSet.this.count;
            if (this.prev == -1) {
                ObjectLinkedOpenHashSet.this.first = this.next;
            } else {
                int n = this.prev;
                ObjectLinkedOpenHashSet.this.link[n] = ObjectLinkedOpenHashSet.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                ObjectLinkedOpenHashSet.this.last = this.prev;
            } else {
                int n = this.next;
                ObjectLinkedOpenHashSet.this.link[n] = ObjectLinkedOpenHashSet.this.link[n] ^ (this.curr ^ this.prev);
            }
            this.curr = -1;
        }
    }
}

