/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import clover.it.unimi.dsi.fastutil.objects.Reference2IntSortedMap;
import clover.it.unimi.dsi.fastutil.objects.ReferenceSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Reference2IntSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Reference2IntSortedMaps() {
    }

    public static Reference2IntSortedMap singleton(Object key, int value) {
        return new Singleton(key, value);
    }

    public static Reference2IntSortedMap singleton(Object key, int value, Comparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Reference2IntSortedMap singleton(Object key, Object value) {
        return new Singleton(key, (Integer)value);
    }

    public static Reference2IntSortedMap singleton(Object key, Object value, Comparator comparator) {
        return new Singleton(key, (Integer)value, comparator);
    }

    public static Reference2IntSortedMap synchronize(Reference2IntSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Reference2IntSortedMap synchronize(Reference2IntSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Reference2IntSortedMap unmodifiable(Reference2IntSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Reference2IntMaps.UnmodifiableMap
    implements Reference2IntSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2IntSortedMap sortedMap;

        protected UnmodifiableSortedMap(Reference2IntSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Reference2IntSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Reference2IntSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Reference2IntSortedMap)this.sortedMap.tailMap(from));
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }
    }

    public static class SynchronizedSortedMap
    extends Reference2IntMaps.SynchronizedMap
    implements Reference2IntSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Reference2IntSortedMap sortedMap;

        protected SynchronizedSortedMap(Reference2IntSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Reference2IntSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Reference2IntSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Reference2IntSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Reference2IntSortedMap)this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }
    }

    public static class Singleton
    extends Reference2IntMaps.Singleton
    implements Reference2IntSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Comparator comparator;

        protected Singleton(Object key, int value, Comparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(Object key, int value) {
            this(key, value, null);
        }

        final int compare(Object k1, Object k2) {
            return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ReferenceSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public SortedMap subMap(Object from, Object to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public SortedMap headMap(Object to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public SortedMap tailMap(Object from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Object firstKey() {
            return this.key;
        }

        public Object lastKey() {
            return this.key;
        }
    }

    public static class EmptySortedMap
    extends Reference2IntMaps.EmptyMap
    implements Reference2IntSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public SortedMap subMap(Object from, Object to) {
            return EMPTY_MAP;
        }

        public SortedMap headMap(Object to) {
            return EMPTY_MAP;
        }

        public SortedMap tailMap(Object from) {
            return EMPTY_MAP;
        }

        public Object firstKey() {
            throw new NoSuchElementException();
        }

        public Object lastKey() {
            throw new NoSuchElementException();
        }
    }
}

