/*
 * Decompiled with CFR 0.152.
 */
package clover.retrotranslator.net.sf.retrotranslator.runtime.format;

import clover.retrotranslator.net.sf.retrotranslator.runtime.format.Conversion;
import clover.retrotranslator.net.sf.retrotranslator.runtime.format.FormatContext;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._StringBuffer;
import java.text.DecimalFormatSymbols;

abstract class NumericConversion
extends Conversion {
    NumericConversion() {
    }

    protected static void appendNumber(StringBuffer builder, String number, boolean groupingUsed, DecimalFormatSymbols symbols) {
        for (int i = 0; i < number.length(); ++i) {
            if (groupingUsed && i > 0 && (number.length() - i) % 3 == 0) {
                builder.append(symbols.getGroupingSeparator());
            }
            builder.append((char)(symbols.getZeroDigit() - 48 + number.charAt(i)));
        }
    }

    protected static boolean printSpecialNumber(FormatContext context, double argument) {
        if (Double.isNaN(argument)) {
            context.writePadded("NaN");
            return true;
        }
        if (argument == Double.POSITIVE_INFINITY) {
            context.writePadded(context.isFlag('+') ? "+Infinity" : "Infinity");
            return true;
        }
        if (argument == Double.NEGATIVE_INFINITY) {
            context.writePadded(context.isFlag('(') ? "(Infinity)" : "-Infinity");
            return true;
        }
        return false;
    }

    protected static void printNumber(FormatContext context, boolean negative, String prefix, StringBuffer argument, DecimalFormatSymbols symbols) {
        StringBuffer builder = new StringBuffer();
        if (negative) {
            if (context.isFlag('(')) {
                builder.append('(');
                argument.append(')');
            } else {
                builder.append('-');
            }
        } else if (context.isFlag('+')) {
            builder.append('+');
        } else if (context.isFlag(' ')) {
            builder.append(' ');
        }
        if (prefix != null) {
            builder.append(prefix);
        }
        if (context.isFlag('0')) {
            int count = context.getWidth() - builder.length() - argument.length();
            for (int i = 0; i < count; ++i) {
                builder.append(symbols.getZeroDigit());
            }
        }
        context.writePadded(_StringBuffer.append(builder, argument).toString());
    }
}

