/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.context;

import java.io.Serializable;
import java.util.BitSet;

public class ContextSet
implements Serializable {
    private static final long serialVersionUID = -3761096221581124040L;
    private final BitSet bitSet;

    public ContextSet() {
        this.bitSet = new BitSet(19);
    }

    public ContextSet(int size) {
        this.bitSet = new BitSet(size);
    }

    public ContextSet(ContextSet copy) {
        this(copy.bitSet.size());
        this.bitSet.or(copy.bitSet);
    }

    private ContextSet(BitSet bitSet) {
        this(bitSet.size());
        this.bitSet.or(bitSet);
    }

    public static ContextSet fromBitSet(BitSet bs) {
        return new ContextSet(bs);
    }

    BitSet toBitSet() {
        return (BitSet)this.bitSet.clone();
    }

    public boolean get(int bitIndex) {
        return this.bitSet.get(bitIndex);
    }

    public boolean intersects(ContextSet other) {
        return this.bitSet.intersects(other.bitSet);
    }

    public int nextSetBit(int fromIndex) {
        return this.bitSet.nextSetBit(fromIndex);
    }

    public int size() {
        return this.bitSet.size();
    }

    public ContextSet and(ContextSet set) {
        BitSet bitset = this.toBitSet();
        bitset.and(set.bitSet);
        if (!bitset.equals(this.bitSet)) {
            return new ContextSet(bitset);
        }
        return this;
    }

    public ContextSet clear(int bitIndex) {
        BitSet bitset = this.toBitSet();
        bitset.clear(bitIndex);
        return new ContextSet(bitset);
    }

    public ContextSet flip(int fromIndex, int toIndex) {
        BitSet bitset = this.toBitSet();
        bitset.flip(fromIndex, toIndex);
        return new ContextSet(bitset);
    }

    public ContextSet or(ContextSet other) {
        BitSet bitset = this.toBitSet();
        bitset.or(other.bitSet);
        if (!bitset.equals(this.bitSet)) {
            return new ContextSet(bitset);
        }
        return this;
    }

    public ContextSet set(int bitIndex) {
        if (!this.bitSet.get(bitIndex)) {
            BitSet bitset = this.toBitSet();
            bitset.set(bitIndex);
            return new ContextSet(bitset);
        }
        return this;
    }

    public ContextSet set(int bitIndex, boolean value) {
        BitSet bitset = this.toBitSet();
        bitset.set(bitIndex, value);
        return new ContextSet(bitset);
    }

    public String toString() {
        return this.bitSet.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.bitSet.equals(((ContextSet)o).bitSet);
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }
}

