/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.context;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.MethodRegexpContext;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.context.RegexpContext;
import com.cenqua.clover.context.SimpleContext;
import com.cenqua.clover.context.StatementRegexpContext;
import com.cenqua.clover.instr.FileStructureInfo;
import com.cenqua.clover.instr.InstrumentationConfig;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.util.BitSetUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ContextStore
implements Serializable {
    public static final int NO_INDEX = -1;
    public static final int CONTEXT_CLOVER_OFF = 0;
    public static final int CONTEXT_STATIC = 1;
    public static final int CONTEXT_INSTANCE = 2;
    public static final int CONTEXT_CTOR = 3;
    public static final int CONTEXT_METHOD = 4;
    public static final int CONTEXT_SWITCH = 5;
    public static final int CONTEXT_WHILE = 6;
    public static final int CONTEXT_DO = 7;
    public static final int CONTEXT_FOR = 8;
    public static final int CONTEXT_IF = 9;
    public static final int CONTEXT_ELSE = 10;
    public static final int CONTEXT_TRY = 11;
    public static final int CONTEXT_CATCH = 12;
    public static final int CONTEXT_FINALLY = 13;
    public static final int CONTEXT_SYNC = 14;
    public static final int CONTEXT_ASSERT = 15;
    public static final int CONTEXT_DEPRECATED = 16;
    public static final int CONTEXT_PRIVATE_METHOD = 17;
    public static final int CONTEXT_PROPERTY_ACCESSOR = 18;
    public static final int NEXT_INDEX = 19;
    private int nextIndex = 19;
    private static LinkedHashMap reservedContexts = new LinkedHashMap();
    private static LinkedHashMap reservedMethodContexts = new LinkedHashMap();
    private static HashSet reservedNames = new HashSet();
    private static final long serialVersionUID = 3100972174066982296L;
    private LinkedHashMap methodContexts = new LinkedHashMap();
    private LinkedHashMap statementContexts = new LinkedHashMap();
    private transient Map namedContextCache;

    public ContextStore() {
        this.methodContexts.putAll(reservedMethodContexts);
    }

    public int addMethodContext(MethodRegexpContext ctx) throws CloverException {
        MethodRegexpContext context = new MethodRegexpContext(ctx);
        this.checkForReservedName(context);
        int index = -1;
        index = this.removeExistingContext(context, this.statementContexts, index);
        index = this.removeExistingContext(context, this.methodContexts, index);
        if (index == -1) {
            index = this.nextIndex++;
        }
        context.setIndex(index);
        this.logContext("method", context, index);
        ContextStore.addContext(this.methodContexts, context);
        return index;
    }

    private int removeExistingContext(NamedContext context, Map contexts, int index) {
        NamedContext existingContext = (NamedContext)contexts.get(context.getName());
        if (existingContext != null) {
            index = existingContext.getIndex();
            contexts.remove(context.getName());
            this.getCache().clear();
        }
        return index;
    }

    public int addStatementContext(StatementRegexpContext ctx) throws CloverException {
        StatementRegexpContext context = new StatementRegexpContext(ctx);
        this.checkForReservedName(context);
        int index = -1;
        index = this.removeExistingContext(context, this.methodContexts, index);
        index = this.removeExistingContext(context, this.statementContexts, index);
        if (index == -1) {
            index = this.nextIndex++;
        }
        context.setIndex(index);
        this.logContext("statement", context, index);
        ContextStore.addContext(this.statementContexts, context);
        return index;
    }

    private void logContext(String type, RegexpContext context, int index) {
        if (Logger.isDebug()) {
            Logger.getInstance().debug("adding " + type + " context id=" + index + ", name=" + context.getName() + ", pattern=" + context.getPattern());
        }
    }

    public List getMethodContexts() {
        return new ArrayList(this.methodContexts.values());
    }

    public List getStatementContexts() {
        return new ArrayList(this.statementContexts.values());
    }

    public List getReservedContexts() {
        return new ArrayList(reservedContexts.values());
    }

    public List getReservedMethodContexts() {
        return new ArrayList(reservedMethodContexts.values());
    }

    public List getAllUserContexts() {
        ArrayList contexts = new ArrayList(this.methodContexts.values());
        contexts.addAll(this.statementContexts.values());
        contexts.removeAll(reservedMethodContexts.values());
        return contexts;
    }

    public ContextSet createContextSetFilter(String spec) {
        return this.createContextSetFilter(spec, false);
    }

    public ContextSet createContextSetFilter(String spec, boolean invert) {
        BitSet result = new BitSet(this.nextIndex);
        StringTokenizer toks = new StringTokenizer(spec, ", ");
        while (toks.hasMoreTokens()) {
            String filter = toks.nextToken();
            NamedContext context = this.getContext(filter);
            if (context != null) {
                result.set(context.getIndex());
                continue;
            }
            Logger.getInstance().warn("Ignoring unknown context filter \"" + filter + "\"");
        }
        if (invert) {
            result.flip(0, this.nextIndex);
        }
        result.set(0);
        return ContextSet.fromBitSet(result);
    }

    public NamedContext getContext(String name) {
        NamedContext result = (NamedContext)reservedContexts.get(name);
        if (result == null) {
            result = (NamedContext)reservedMethodContexts.get(name);
        }
        if (result == null) {
            result = (NamedContext)this.methodContexts.get(name);
        }
        if (result == null) {
            result = (NamedContext)this.statementContexts.get(name);
        }
        return result;
    }

    public String getContextsAsString(ContextSet set) {
        if (this.getCache().containsKey(set)) {
            return (String)this.getCache().get(set);
        }
        NamedContext[] contexts = this.getContexts(set);
        StringBuffer contextString = new StringBuffer();
        String sep = "";
        for (int j = 0; j < contexts.length; ++j) {
            NamedContext context = contexts[j];
            contextString.append(sep);
            contextString.append(context.getName());
            sep = ", ";
        }
        this.getCache().put(set, contextString.toString());
        return contextString.toString();
    }

    private synchronized Map getCache() {
        if (this.namedContextCache == null) {
            this.namedContextCache = new HashMap();
        }
        return this.namedContextCache;
    }

    public NamedContext[] getContexts(ContextSet ctxSet) {
        ArrayList allContexts = new ArrayList(reservedContexts.values());
        allContexts.addAll(reservedMethodContexts.values());
        allContexts.addAll(this.methodContexts.values());
        allContexts.addAll(this.statementContexts.values());
        ArrayList contexts = new ArrayList();
        int i = ctxSet.nextSetBit(0);
        while (i >= 0) {
            this.collectContextAt(allContexts, i, contexts);
            i = ctxSet.nextSetBit(i + 1);
        }
        NamedContext[] namedContexts = contexts.toArray(new NamedContext[0]);
        return namedContexts;
    }

    public static void saveCustomContexts(InstrumentationConfig config) throws CloverException {
        if (config.hasCustomContexts()) {
            Clover2Registry registry;
            RegexpContext context;
            InstrumentationConfig.StatementContextDef contextDef;
            Iterator it;
            ContextStore contexts = new ContextStore();
            if (config.getMethodContexts() != null) {
                it = config.getMethodContexts().iterator();
                while (it.hasNext()) {
                    contextDef = (InstrumentationConfig.MethodContextDef)it.next();
                    ((InstrumentationConfig.MethodContextDef)contextDef).validate();
                    try {
                        context = new MethodRegexpContext(contextDef.getName(), Pattern.compile(contextDef.getRegexp()), ((InstrumentationConfig.MethodContextDef)contextDef).getMaxComplexity());
                        contexts.addMethodContext((MethodRegexpContext)context);
                    }
                    catch (PatternSyntaxException e) {
                        throw new CloverException("Invalid context definition: " + e.getMessage(), e);
                    }
                }
            }
            if (config.getStatementContexts() != null) {
                it = config.getStatementContexts().iterator();
                while (it.hasNext()) {
                    contextDef = (InstrumentationConfig.StatementContextDef)it.next();
                    contextDef.validate();
                    try {
                        context = new StatementRegexpContext(contextDef.getName(), Pattern.compile(contextDef.getRegexp()));
                        contexts.addStatementContext((StatementRegexpContext)context);
                    }
                    catch (PatternSyntaxException e) {
                        throw new CloverException("Invalid context definition: " + e.getMessage(), e);
                    }
                }
            }
            try {
                registry = Clover2Registry.createOrLoad(config.getRegistryFile(), config.getProjectName());
            }
            catch (IOException e) {
                throw new CloverException(e.getClass().getName() + " accessing Clover database: " + e.getMessage(), e);
            }
            registry.setContextStore(contexts);
            try {
                registry.store();
            }
            catch (IOException e) {
                throw new CloverException(e.getClass().getName() + " writing Clover database: " + e.getMessage());
            }
        }
    }

    public static ContextMapper mergeContextStores(Clover2Registry newReg, Collection mergingDbs) {
        ContextStore merged = new ContextStore();
        HashMap<CloverDatabase, HashMap<Integer, Integer>> oldMappings = new HashMap<CloverDatabase, HashMap<Integer, Integer>>();
        HashMap<CloverDatabase, HashMap<Integer, Integer>> newMappings = new HashMap<CloverDatabase, HashMap<Integer, Integer>>();
        ContextStore smallest = null;
        Iterator iterator = mergingDbs.iterator();
        while (iterator.hasNext()) {
            ContextStore store = ((CloverDatabase)iterator.next()).getContextStore();
            if (smallest != null && store.size() >= smallest.size()) continue;
            smallest = store;
        }
        Iterator contexts = smallest.getAllUserContexts().iterator();
        while (contexts.hasNext()) {
            RegexpContext context = (RegexpContext)contexts.next();
            Integer contextIdx = new Integer(context.getIndex());
            boolean universal = true;
            Iterator iterator2 = mergingDbs.iterator();
            while (iterator2.hasNext()) {
                CloverDatabase db = (CloverDatabase)iterator2.next();
                ContextStore store = db.getContextStore();
                int equiv = store.getEquivalentContextIndex(context);
                if (equiv >= 0) {
                    HashMap<Integer, Integer> oldMapping = (HashMap<Integer, Integer>)oldMappings.get(db);
                    if (oldMapping == null) {
                        oldMapping = new HashMap<Integer, Integer>();
                        oldMappings.put(db, oldMapping);
                    }
                    oldMapping.put(contextIdx, new Integer(equiv));
                    continue;
                }
                universal = false;
                break;
            }
            if (!universal) continue;
            int mergedIndex = merged.addContextFromTemplate(context);
            if (mergedIndex == -1) {
                Logger.getInstance().error("skipping problem user context " + context + ", " + context.getClass().getName());
                continue;
            }
            Iterator iterator3 = mergingDbs.iterator();
            while (iterator3.hasNext()) {
                CloverDatabase db = (CloverDatabase)iterator3.next();
                Map oldMapping = (Map)oldMappings.get(db);
                Integer equiv = (Integer)oldMapping.get(contextIdx);
                HashMap<Integer, Integer> newMapping = (HashMap<Integer, Integer>)newMappings.get(db);
                if (newMapping == null) {
                    newMapping = new HashMap<Integer, Integer>();
                    newMappings.put(db, newMapping);
                }
                newMapping.put(equiv, new Integer(mergedIndex));
            }
        }
        List allReservedContexts = merged.getReservedContexts();
        allReservedContexts.addAll(merged.getReservedMethodContexts());
        Iterator m = newMappings.values().iterator();
        while (m.hasNext()) {
            Map mapping = (Map)m.next();
            Iterator contexts2 = allReservedContexts.iterator();
            while (contexts2.hasNext()) {
                NamedContext context = (NamedContext)contexts2.next();
                Integer contextIdx = new Integer(context.getIndex());
                mapping.put(contextIdx, contextIdx);
            }
        }
        newReg.setContextStore(merged);
        return new ContextMapper(merged, newMappings);
    }

    private int addContextFromTemplate(RegexpContext context) {
        int newIndex = -1;
        try {
            if (context instanceof MethodRegexpContext) {
                newIndex = this.addMethodContext((MethodRegexpContext)context);
            } else if (context instanceof StatementRegexpContext) {
                newIndex = this.addStatementContext((StatementRegexpContext)context);
            } else {
                Logger.getInstance().warn("Expecting a user defined context in merge, but got " + context.getClass().getName() + ", " + context);
            }
        }
        catch (CloverException e) {
            Logger.getInstance().error("when merging, encountered context with illegal name, skipping", e);
        }
        return newIndex;
    }

    private int getEquivalentContextIndex(RegexpContext context) {
        Collection search = null;
        if (context instanceof MethodRegexpContext) {
            search = this.methodContexts.values();
        } else if (context instanceof StatementRegexpContext) {
            search = this.statementContexts.values();
        }
        if (search != null) {
            Iterator c = search.iterator();
            while (c.hasNext()) {
                RegexpContext regexpContext = (RegexpContext)c.next();
                if (!regexpContext.isEquivalent(context)) continue;
                return regexpContext.getIndex();
            }
        }
        return -1;
    }

    public int size() {
        return reservedContexts.size() + this.methodContexts.size() + this.statementContexts.size();
    }

    private void collectContextAt(List reservedList, int i, List contexts) {
        Iterator iterator = reservedList.iterator();
        while (iterator.hasNext()) {
            NamedContext namedContext = (NamedContext)iterator.next();
            if (namedContext.getIndex() != i) continue;
            contexts.add(namedContext);
            break;
        }
    }

    private static void addContext(Map map, NamedContext context) {
        map.put(context.getName(), context);
    }

    public static boolean isReservedName(String name) {
        return reservedNames.contains(name);
    }

    private void checkForReservedName(NamedContext context) throws CloverException {
        if (ContextStore.isReservedName(context.getName())) {
            throw new CloverException("The name \"" + context.getName() + "\" is already in use by one of the builtin contexts");
        }
    }

    static {
        ContextStore.addContext(reservedContexts, new SimpleContext(0, "SourceDirective"));
        ContextStore.addContext(reservedContexts, new SimpleContext(1, "static"));
        ContextStore.addContext(reservedContexts, new SimpleContext(3, "constructor"));
        ContextStore.addContext(reservedContexts, new SimpleContext(4, "method"));
        ContextStore.addContext(reservedContexts, new SimpleContext(5, "switch"));
        ContextStore.addContext(reservedContexts, new SimpleContext(6, "while"));
        ContextStore.addContext(reservedContexts, new SimpleContext(7, "do"));
        ContextStore.addContext(reservedContexts, new SimpleContext(8, "for"));
        ContextStore.addContext(reservedContexts, new SimpleContext(9, "if"));
        ContextStore.addContext(reservedContexts, new SimpleContext(10, "else"));
        ContextStore.addContext(reservedContexts, new SimpleContext(11, "try"));
        ContextStore.addContext(reservedContexts, new SimpleContext(12, "catch"));
        ContextStore.addContext(reservedContexts, new SimpleContext(13, "finally"));
        ContextStore.addContext(reservedContexts, new SimpleContext(14, "sync"));
        ContextStore.addContext(reservedContexts, new SimpleContext(15, "assert"));
        ContextStore.addContext(reservedContexts, new SimpleContext(16, "@deprecated"));
        ContextStore.addContext(reservedMethodContexts, new MethodRegexpContext(17, "private", Pattern.compile("(.* )?private .*")));
        ContextStore.addContext(reservedMethodContexts, new MethodRegexpContext(18, "property", Pattern.compile("(.* )?public .*(get|set|is)[A-Z0-9].*"), 1){
            private static final long serialVersionUID = 5089471658196827133L;

            public boolean matches(FileStructureInfo.MethodMarker methodMarker) {
                if (!super.matches(methodMarker)) {
                    return false;
                }
                MethodInfo info = methodMarker.getMethod();
                String name = info.getSignature().getName();
                MethodSignature.Parameter[] params = info.getSignature().getParameters();
                if (name.startsWith("get") || name.startsWith("is")) {
                    return !info.getSignature().hasParams();
                }
                return params != null && params.length == 1;
            }
        });
        reservedNames.addAll(reservedContexts.keySet());
        reservedNames.addAll(reservedMethodContexts.keySet());
    }

    public static class ContextMapper {
        private ContextStore contextStore;
        private Map mappings;

        ContextMapper(ContextStore cs, Map mappings) {
            this.contextStore = cs;
            this.mappings = mappings;
        }

        public void applyContextMapping(CloverDatabase db, FileInfo finfo) {
            final Map mapping = (Map)this.mappings.get(db);
            if (mapping == null) {
                return;
            }
            finfo.visitElements(new FileElementVisitor(){

                public void visitClass(ClassInfo info) {
                }

                public void visitMethod(MethodInfo info) {
                    info.setContext(ContextSet.fromBitSet(BitSetUtils.getMappedBitSet(info.getContext().toBitSet(), mapping)));
                }

                public void visitStatement(StatementInfo info) {
                    info.setContext(ContextSet.fromBitSet(BitSetUtils.getMappedBitSet(info.getContext().toBitSet(), mapping)));
                }

                public void visitBranch(BranchInfo info) {
                    info.setContext(ContextSet.fromBitSet(BitSetUtils.getMappedBitSet(info.getContext().toBitSet(), mapping)));
                }
            });
        }

        public ContextStore getContextStore() {
            return this.contextStore;
        }
    }
}

