/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.CloverNames;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.instr.CloverToken;
import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.Modifiers;
import com.cenqua.clover.instr.RecorderInstrEmitter;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.SourceRegion;
import java.util.Map;

public class ClassEntryNode
extends Emitter {
    private String className;
    private String pkgname;
    private String superclass;
    private boolean isTopLevel;
    private boolean isInterface;
    private boolean isEnum;
    private boolean isAnnotation;
    private Map tags;
    private Modifiers mods;
    private boolean outerDetectTests;
    private CloverToken recorderInsertPoint;
    private RecorderInstrEmitter recorderInstrEmitter;

    public ClassEntryNode(Map tags, Modifiers mods, String className, String pkgname, String superclass, ContextSet context, int line, int col, boolean isTopLevel, boolean isInterface, boolean isEnum, boolean isAnnotation) {
        super(context, line, col);
        this.tags = tags;
        this.mods = mods;
        this.className = className;
        this.pkgname = pkgname;
        this.superclass = superclass;
        this.isTopLevel = isTopLevel;
        this.isInterface = isInterface;
        this.isEnum = isEnum;
        this.isAnnotation = isAnnotation;
    }

    public void init(InstrumentationState state) {
        this.outerDetectTests = state.isDetectTests();
        boolean testClass = state.getTestDetector() != null && state.getTestDetector().isClassMatch(state, this.tags, this.mods, this.pkgname, this.className, this.superclass);
        state.setDetectTests(testClass);
        ClassInfo clazz = state.getRegistry().enterClass(this.className, new SourceRegion(this.getLine(), this.getColumn()), this.isInterface, this.isEnum, this.isAnnotation);
        if (this.isTopLevel) {
            String recorderPrefix = CloverNames.CLOVER_RECORDER_PREFIX + Integer.toString(state.getFileInfo().getDataIndex(), 36) + Integer.toString(clazz.getDataIndex(), 36) + Long.toString(System.currentTimeMillis(), 36);
            if (state.getCfg().isClassInstrStrategy() || this.isEnum) {
                recorderPrefix = recorderPrefix + ".R";
            }
            state.setRecorderPrefix(recorderPrefix);
        }
    }

    public CloverToken getRecorderInsertPoint() {
        return this.recorderInsertPoint;
    }

    public void setRecorderInsertPoint(CloverToken recorderInsertPoint) {
        this.recorderInsertPoint = recorderInsertPoint;
    }

    public boolean isOuterDetectTests() {
        return this.outerDetectTests;
    }

    public void setRecorderInstrEmitter(RecorderInstrEmitter emitter) {
        this.recorderInstrEmitter = emitter;
    }

    public RecorderInstrEmitter getRecorderInstrEmitter() {
        return this.recorderInstrEmitter;
    }
}

