/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.TestCaseInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassInfo
extends BaseClassInfo
implements HasMetricsNode,
CoverageDataReceptor {
    private static final long serialVersionUID = 7010958791590969115L;
    private List methods = new ArrayList();
    private int relativeDataIndex;
    private int dataLength;
    private transient CoverageDataProvider data;
    private transient Map testcaseIDMap;
    private transient Map testcaseNameMap;

    public ClassInfo(PackageInfo packageInfo, FileInfo containingFile, int dataIndex, String name, SourceRegion region, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        super(packageInfo, containingFile, region, name, typeInterface, typeEnum, typeAnnotation);
        this.relativeDataIndex = dataIndex;
    }

    public boolean isEmpty() {
        return this.methods.size() == 0;
    }

    public MethodInfo[] getMethods() {
        return this.methods.toArray(new MethodInfo[this.methods.size()]);
    }

    void addMethod(MethodInfo meth) {
        this.methods.add(meth);
        this.testClass |= meth.isTest();
    }

    public void addTestCase(TestCaseInfo testcase) {
        this.testClass = true;
        if (this.testcaseIDMap == null) {
            this.testcaseIDMap = new HashMap();
            this.testcaseNameMap = new HashMap();
        }
        this.testcaseIDMap.put(testcase.getId(), testcase);
        this.testcaseNameMap.put(testcase.getQualifiedName(), testcase);
    }

    public List getTestCases() {
        if (this.testcaseIDMap != null) {
            return new ArrayList(this.testcaseIDMap.values());
        }
        return Collections.EMPTY_LIST;
    }

    public TestCaseInfo getTestCase(Integer id) {
        if (this.testcaseIDMap != null) {
            return (TestCaseInfo)this.testcaseIDMap.get(id);
        }
        return null;
    }

    public TestCaseInfo getTestCase(String testname) {
        if (this.testcaseNameMap != null) {
            return (TestCaseInfo)this.testcaseNameMap.get(testname);
        }
        return null;
    }

    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        Iterator iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            methodInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    public int getDataIndex() {
        return ((FileInfo)this.containingFile).dataIndex + this.relativeDataIndex;
    }

    public int getRelativeDataIndex() {
        return this.relativeDataIndex;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void gatherSourceRegions(Set regions) {
        regions.add(this);
        Iterator iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            methodInfo.gatherSourceRegions(regions);
        }
    }

    public void visitElements(FileElementVisitor visitor) {
        visitor.visitClass(this);
        Iterator iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            methodInfo.visit(visitor);
        }
    }

    public String getChildType() {
        return "method";
    }

    public int getNumChildren() {
        return this.methods.size();
    }

    public HasMetricsNode getChild(int i) {
        return (HasMetricsNode)this.methods.get(i);
    }

    public int getIndexOfChild(HasMetricsNode child) {
        return this.methods.indexOf(child);
    }

    public boolean isLeaf() {
        return false;
    }

    public void setComparator(Comparator cmp) {
        if (cmp != null) {
            Collections.sort(this.methods, cmp);
        } else {
            Collections.sort(this.methods, SourceRegion.SOURCE_ORDER_COMP);
        }
    }

    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getPackage().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingFile().getContextFilter();
            this.metrics = this.calcMetrics(this.contextFilter, true);
        }
        return this.metrics;
    }

    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(null, false);
        }
        return this.rawMetrics;
    }

    private ClassMetrics calcMetrics(ContextSet filter, boolean filtered) {
        ClassMetrics classMetrics = new ClassMetrics(this);
        int covered = 0;
        int numMethods = 0;
        int numTestMethods = 0;
        Iterator iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            if (methodInfo.isFiltered(filter)) continue;
            if (!filtered) {
                classMetrics.add(methodInfo.getRawMetrics());
            } else {
                classMetrics.add(methodInfo.getMetrics());
            }
            if (methodInfo.getHitCount() > 0) {
                ++covered;
            }
            if (methodInfo.isTest()) {
                ++numTestMethods;
            }
            ++numMethods;
        }
        classMetrics.setNumMethods(numMethods);
        classMetrics.setNumCoveredMethods(covered);
        classMetrics.setNumTestMethods(numTestMethods);
        if (this.testcaseIDMap != null) {
            int numTests = 0;
            int numPasses = 0;
            int numFailures = 0;
            int numErrors = 0;
            float executionTime = 0.0f;
            Iterator it = this.testcaseIDMap.values().iterator();
            while (it.hasNext()) {
                TestCaseInfo test = (TestCaseInfo)it.next();
                ++numTests;
                if (!test.isHasResult()) continue;
                if (test.isSuccess()) {
                    ++numPasses;
                } else if (test.isError()) {
                    ++numErrors;
                } else {
                    ++numFailures;
                }
                executionTime += test.getTime();
            }
            classMetrics.setNumTests(numTests);
            classMetrics.setNumTestPasses(numPasses);
            classMetrics.setNumTestFailures(numFailures);
            classMetrics.setNumTestErrors(numErrors);
            classMetrics.setTestExecutionTime(executionTime);
        }
        return classMetrics;
    }

    public ClassInfo copy(FileInfo newParent, HasMetricsFilter filter) {
        ClassInfo cinfo = new ClassInfo((PackageInfo)newParent.getContainingPackage(), newParent, this.relativeDataIndex, this.name, this, this.typeInterface, this.typeEnum, this.typeAnnotation);
        cinfo.setDataProvider(this.getDataProvider());
        Iterator<Object> iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            if (!filter.accept(methodInfo)) continue;
            cinfo.addMethod(methodInfo.copy(cinfo));
        }
        cinfo.setDataLength(this.getDataLength());
        if (this.testcaseIDMap != null) {
            iterator = this.testcaseIDMap.values().iterator();
            while (iterator.hasNext()) {
                TestCaseInfo test = (TestCaseInfo)iterator.next();
                cinfo.addTestCase(test);
            }
        }
        return cinfo;
    }

    public MethodInfo getTestMethodDeclaration(String methodname) {
        Iterator iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            if (!methodInfo.getSimpleName().equals(methodname) || !methodInfo.isPublic() || methodInfo.getParamCount() != 0) continue;
            return methodInfo;
        }
        return null;
    }

    public int getNumMethods() {
        return this.methods.size();
    }
}

