/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.Logger;
import com.cenqua.clover.ProgressListener;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.ContextStore;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.CorruptedRegistryException;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.IncompatibleRegistryFormatException;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.NoSuchRegistryException;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.ReadOnlyRegistryException;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.ProgressInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Clover2Registry {
    private static final long REG_MAGIC = -889258259L;
    private static final int REG_FORMAT_VERSION = 200;
    private static final int MODE_READWRITE = 0;
    private static final int MODE_READONLY = 1;
    private File registryFile;
    private ProjectInfo model;
    private PackageInfo currentPackage;
    private FileInfo currentFile;
    private LinkedList classStack = new LinkedList();
    private LinkedList methodStack = new LinkedList();
    private int dataLength = 0;
    private int currentGlobalIndex = 0;
    private int currentRelativeIndex = 0;
    private long version = System.currentTimeMillis();
    private boolean readOnly = false;
    private String encoding;
    private ContextStore contexts;
    private InstrumentationInfo currentInstrInfo;
    private List instrumentationHistory;
    private CoverageData coverageData;

    public Clover2Registry(File registryFile, String name) {
        this(registryFile, new ProjectInfo(name), new ArrayList(), new ContextStore());
    }

    private Clover2Registry(File registryFile, ProjectInfo model, List instrumentationHistory, ContextStore contexts) {
        this.registryFile = registryFile;
        this.model = model;
        this.instrumentationHistory = instrumentationHistory;
        this.contexts = contexts;
        this.version = model.getVersion();
    }

    public static Clover2Registry fromInitString(String initstring, String name) throws CloverException {
        File regFile = new File(initstring);
        Clover2Registry reg = Clover2Registry.fromFile(regFile);
        if (reg == null) {
            reg = new Clover2Registry(regFile, name);
        }
        return reg;
    }

    public static Clover2Registry fromFile(File registryFile) throws CloverException {
        return Clover2Registry.fromFile(registryFile, null, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Clover2Registry fromFile(File registryFile, HasMetricsFilter filter, ProgressListener progressListener) throws CloverException {
        Clover2Registry clover2Registry;
        DataInputStream in;
        block14: {
            if (!registryFile.exists()) {
                Logger.getInstance().debug("Registry file: " + registryFile.getAbsolutePath() + " does not exist.");
                return null;
            }
            if (!registryFile.isFile()) {
                Logger.getInstance().warn("Registry file: " + registryFile.getAbsolutePath() + " is not a file.");
                return null;
            }
            if (!registryFile.canRead()) {
                Logger.getInstance().warn("Registry file: " + registryFile.getAbsolutePath() + " can not be read by Clover. Please ensure read/write access is granted to this file.");
                return null;
            }
            in = null;
            ObjectInputStream ois = null;
            try {
                InputStream is = new FileInputStream(registryFile);
                if (progressListener != null) {
                    is = new ProgressInputStream(is, registryFile.length(), progressListener, "Loading registry file");
                }
                in = new DataInputStream(is);
                int dataLength = Clover2Registry.readRegistryHeader(in);
                boolean readOnly = Clover2Registry.readRegistryMode(in);
                boolean containsData = in.readBoolean();
                ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(in)));
                ProjectInfo model = (ProjectInfo)ois.readObject();
                if (filter != null) {
                    model = model.copy(filter);
                }
                List instrHistory = (List)ois.readObject();
                ContextStore contexts = (ContextStore)ois.readObject();
                Clover2Registry reg = new Clover2Registry(registryFile, model, instrHistory, contexts);
                reg.readOnly = readOnly;
                reg.dataLength = dataLength;
                if (containsData) {
                    reg.coverageData = (CoverageData)ois.readObject();
                }
                clover2Registry = reg;
                if (ois == null) break block14;
            }
            catch (ClassCastException e) {
                try {
                    Logger.getInstance().debug("Exception deserializing " + registryFile.getAbsolutePath(), e);
                    throw new IncompatibleRegistryFormatException(registryFile.getAbsolutePath(), e);
                    catch (ClassNotFoundException e2) {
                        Logger.getInstance().debug("Exception deserializing " + registryFile.getAbsolutePath(), e2);
                        throw new IncompatibleRegistryFormatException(registryFile.getAbsolutePath(), e2);
                    }
                    catch (InvalidClassException e3) {
                        Logger.getInstance().debug("Exception deserializing " + registryFile.getAbsolutePath(), e3);
                        throw new IncompatibleRegistryFormatException(registryFile.getAbsolutePath(), e3);
                    }
                    catch (IOException e4) {
                        Logger.getInstance().debug("Exception deserializing " + registryFile.getAbsolutePath(), e4);
                        throw new CorruptedRegistryException(registryFile.getAbsolutePath(), e4);
                    }
                }
                catch (Throwable throwable) {
                    if (ois != null) {
                        FileUtils.close(ois);
                        throw throwable;
                    }
                    if (in == null) throw throwable;
                    FileUtils.close(in);
                    throw throwable;
                }
            }
            FileUtils.close(ois);
            return clover2Registry;
        }
        if (in == null) return clover2Registry;
        FileUtils.close(in);
        return clover2Registry;
    }

    public static Clover2Registry createOrLoad(File registryFile, String projectName) throws IOException, CloverException {
        Clover2Registry registry;
        if (registryFile.exists()) {
            Logger.getInstance().info("Updating existing database at '" + registryFile + "'.");
            registry = Clover2Registry.fromFile(registryFile);
        } else {
            Logger.getInstance().info("Creating new database at '" + registryFile + "'.");
            File parentDir = registryFile.getParentFile();
            if (parentDir != null) {
                boolean dirCreated = parentDir.mkdirs();
            }
            registry = new Clover2Registry(registryFile, projectName);
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readRegistryHeaderAndModeOnly(File registryFile) throws IOException, ReadOnlyRegistryException {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(registryFile));
            int length = Clover2Registry.readRegistryHeader((DataInput)((Object)in));
            boolean readOnly = Clover2Registry.readRegistryMode((DataInput)((Object)in));
            if (readOnly) {
                throw new ReadOnlyRegistryException();
            }
            int n = length;
            return n;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static int readRegistryHeader(DataInput in) throws IOException {
        if (-889258259L != in.readLong()) {
            throw new IOException("Not a valid Clover database file. Please regenerate.");
        }
        if (200 != in.readInt()) {
            throw new IOException("Clover is no longer compatible with this database file. Please regenerate.");
        }
        return in.readInt();
    }

    private static boolean readRegistryMode(DataInput in) throws IOException {
        return 1 == in.readInt();
    }

    void writeRegistryHeader(DataOutput out) throws IOException {
        out.writeLong(-889258259L);
        out.writeInt(200);
        out.writeInt(this.dataLength);
        out.writeInt(this.readOnly ? 1 : 0);
        out.writeBoolean(this.readOnly && this.coverageData != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFileHeader() throws IOException, ReadOnlyRegistryException, NoSuchRegistryException {
        if (this.isReadOnly()) {
            throw new ReadOnlyRegistryException();
        }
        if (this.registryFile.exists()) {
            RandomAccessFile raf = new RandomAccessFile(this.registryFile, "rw");
            try {
                this.writeRegistryHeader(raf);
                this.registryFile.setLastModified(this.version);
            }
            finally {
                raf.close();
            }
        } else {
            throw new NoSuchRegistryException(this.registryFile.getAbsolutePath());
        }
    }

    public void storeAsMock() throws IOException {
        this.store(this.newEmptyProject(), new ArrayList(), new ContextStore(), null);
    }

    private ProjectInfo newEmptyProject() {
        ProjectInfo project = new ProjectInfo(this.model.getName());
        project.setDataLength(this.dataLength);
        return project;
    }

    public void store() throws IOException {
        this.store(this.model, this.instrumentationHistory, this.contexts, this.coverageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(ProjectInfo model, List instrumentationHistory, ContextStore contexts, CoverageData coverageData) throws IOException {
        File tmpfile = new File(this.registryFile.getParentFile(), this.registryFile.getName() + ".tmp");
        FilterOutputStream out = null;
        ObjectOutputStream cmp = null;
        try {
            tmpfile.delete();
            out = new DataOutputStream(new FileOutputStream(tmpfile));
            this.writeRegistryHeader((DataOutput)((Object)out));
            cmp = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(out)));
            cmp.writeObject(model);
            cmp.writeObject(instrumentationHistory);
            cmp.writeObject(contexts);
            if (this.isReadOnly() && coverageData != null) {
                cmp.writeObject(coverageData);
            }
        }
        finally {
            if (cmp != null) {
                cmp.close();
            } else if (out != null) {
                out.close();
            }
        }
        try {
            if (this.registryFile.exists() && !this.registryFile.delete()) {
                throw new IOException("Can't delete existing registry file " + this.registryFile);
            }
            if (!tmpfile.renameTo(this.registryFile)) {
                throw new IOException("Problem moving tmp file " + tmpfile + " to registry file");
            }
            this.registryFile.setLastModified(this.version);
        }
        finally {
            tmpfile.delete();
        }
    }

    public boolean fileExists() {
        return this.registryFile.exists();
    }

    public File getRegistryFile() {
        return this.registryFile;
    }

    public String getProjectName() {
        return this.model.getName();
    }

    public void setProjectName(String name) {
        this.model.setName(name);
    }

    public long getVersion() {
        return this.version;
    }

    public long getFirstVersion() {
        return this.instrumentationHistory.isEmpty() ? this.version : ((InstrumentationInfo)this.instrumentationHistory.get(0)).endTS;
    }

    public void setVersion(long version) {
        this.version = version;
        this.model.setVersion(version);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setCoverageData(CoverageData data) {
        this.coverageData = data;
    }

    public CoverageData getCoverageData() {
        return this.coverageData;
    }

    public boolean isOutOfDate() {
        return this.registryFile.lastModified() == 0L || FileUtils.compareLastModified(this.version, this.registryFile) < 0;
    }

    public void startInstr() throws CloverException {
        if (this.isReadOnly()) {
            throw new ReadOnlyRegistryException();
        }
        this.currentGlobalIndex = 0;
        this.dataLength = this.model.getDataLength();
        this.setVersion(System.currentTimeMillis());
        this.currentInstrInfo = new InstrumentationInfo(System.currentTimeMillis());
    }

    public void endInstr() {
        if (this.currentPackage != null) {
            this.exitPackage(this.currentPackage);
        }
        this.model.setDataLength(this.dataLength);
        this.currentInstrInfo.setEndTS(System.currentTimeMillis());
        this.instrumentationHistory.add(this.currentInstrInfo);
    }

    public int getCurrentIndex() {
        return this.currentGlobalIndex;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public FileInfo enterFile(String pkg, File file, int lineCount, int ncLineCount, long timestamp, long filesize, long checksum) {
        this.currentInstrInfo.incNumFiles();
        this.currentRelativeIndex = 0;
        this.enterPackage(pkg);
        FileInfo finfo = (FileInfo)this.currentPackage.getFileInPackage(file.getName());
        long minVersion = -1L;
        if (finfo != null) {
            if (finfo.getChecksum() == checksum && finfo.getFilesize() == filesize) {
                this.currentGlobalIndex = finfo.getDataIndex();
                minVersion = finfo.getMinVersion();
            } else {
                this.currentGlobalIndex = this.dataLength;
            }
        } else {
            this.currentGlobalIndex = this.dataLength;
        }
        finfo = new FileInfo(this.currentPackage, file, this.encoding, this.currentGlobalIndex, lineCount, ncLineCount, timestamp, filesize, checksum, this.getVersion());
        if (minVersion != -1L) {
            finfo.addVersions(minVersion, this.getVersion());
        }
        this.currentFile = finfo;
        return finfo;
    }

    public void exitFile() {
        this.currentPackage.addFile(this.currentFile);
        this.currentGlobalIndex += this.currentRelativeIndex;
        this.currentFile.setDataLength(this.currentGlobalIndex - this.currentFile.getDataIndex());
        this.dataLength = Math.max(this.dataLength, this.currentGlobalIndex);
    }

    public ClassInfo enterClass(String name, SourceRegion region, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        ClassInfo clazz = new ClassInfo(this.currentPackage, this.currentFile, this.currentRelativeIndex, name, region, typeInterface, typeEnum, typeAnnotation);
        this.currentFile.addClass(clazz);
        this.pushCurrentClass(clazz);
        return clazz;
    }

    public ClassInfo exitClass(int endLine, int endCol) {
        ClassInfo clazz = this.popCurrentClass();
        clazz.setEndLine(endLine);
        clazz.setEndColumn(endCol);
        clazz.setDataLength(this.currentRelativeIndex - clazz.getRelativeDataIndex());
        return this.getCurrentClass();
    }

    public MethodInfo enterMethod(ContextSet context, SourceRegion region, MethodSignature signature, boolean test) {
        ClassInfo currentClass = this.getCurrentClass();
        MethodInfo method = new MethodInfo(currentClass, this.currentRelativeIndex, context, region, signature, test);
        this.currentRelativeIndex += method.getDataLength();
        currentClass.addMethod(method);
        this.pushCurrentMethod(method);
        return method;
    }

    public void exitMethod(int endLine, int endCol) {
        MethodInfo method = this.popCurrentMethod();
        method.setEndLine(endLine);
        method.setEndColumn(endCol);
        method.setDataLength(this.currentRelativeIndex - method.getRelativeDataIndex());
    }

    public StatementInfo addStatement(ContextSet context, SourceRegion region, int complexity) {
        MethodInfo currentMethod = this.getCurrentMethod();
        StatementInfo stmt = new StatementInfo(currentMethod, this.currentRelativeIndex, context, region, complexity);
        this.currentRelativeIndex += stmt.getDataLength();
        currentMethod.addStatement(stmt);
        return stmt;
    }

    public BranchInfo addBranch(ContextSet context, SourceRegion region, int complexity, boolean instrumented) {
        MethodInfo currentMethod = this.getCurrentMethod();
        BranchInfo branch = null;
        if (currentMethod != null) {
            branch = new BranchInfo(currentMethod, this.currentRelativeIndex, context, region, complexity, instrumented);
            this.currentRelativeIndex += branch.getDataLength();
            currentMethod.addBranch(branch);
        }
        return branch;
    }

    public ProjectInfo getModel() {
        return this.model;
    }

    public List getInstrHistory() {
        return this.instrumentationHistory;
    }

    public ContextStore getContextStore() {
        return this.contexts;
    }

    public void setContextStore(ContextStore contexts) {
        this.contexts = contexts;
    }

    public void setCurrentEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getInitString() {
        return this.registryFile.getAbsolutePath();
    }

    public long getPastInstrTimestamp(int numPastInstrs) {
        long msec = 0L;
        if (!this.instrumentationHistory.isEmpty()) {
            ListIterator history = this.instrumentationHistory.listIterator(this.instrumentationHistory.size() - 1);
            while (0 < numPastInstrs-- && history.hasPrevious()) {
                InstrumentationInfo info = (InstrumentationInfo)history.previous();
                msec = info.getEndTS();
            }
        }
        return msec;
    }

    private PackageInfo enterPackage(String name) {
        PackageInfo pkg;
        if (this.currentPackage != null) {
            if (this.currentPackage.isNamed(name)) {
                return this.currentPackage;
            }
            this.exitPackage(this.currentPackage);
        }
        if ((pkg = (PackageInfo)this.model.getNamedPackage(name)) == null) {
            pkg = new PackageInfo(this.model, name, this.currentGlobalIndex);
        }
        this.currentPackage = pkg;
        return this.currentPackage;
    }

    private void exitPackage(PackageInfo pkg) {
        if (this.model.getNamedPackage(this.currentPackage.getName()) == null) {
            this.model.addPackage(this.currentPackage);
        }
        pkg.setDataLength(this.currentGlobalIndex - pkg.getDataIndex());
    }

    private ClassInfo getCurrentClass() {
        if (this.classStack.size() > 0) {
            return (ClassInfo)this.classStack.getLast();
        }
        return null;
    }

    private void pushCurrentClass(ClassInfo clazz) {
        this.classStack.add(clazz);
    }

    private ClassInfo popCurrentClass() {
        if (this.classStack.size() > 0) {
            return (ClassInfo)this.classStack.removeLast();
        }
        return null;
    }

    private MethodInfo getCurrentMethod() {
        if (this.methodStack.size() > 0) {
            return (MethodInfo)this.methodStack.getLast();
        }
        return null;
    }

    private void pushCurrentMethod(MethodInfo clazz) {
        this.methodStack.add(clazz);
    }

    private MethodInfo popCurrentMethod() {
        if (this.methodStack.size() > 0) {
            return (MethodInfo)this.methodStack.removeLast();
        }
        return null;
    }

    public static class InstrumentationInfo
    implements Serializable {
        static final long serialVersionUID = -7699262701616121133L;
        private long startTS = 0L;
        private long endTS = 0L;
        private int numFiles = 0;

        public InstrumentationInfo(long startTS) {
            this.startTS = startTS;
        }

        public long getStartTS() {
            return this.startTS;
        }

        public void setStartTS(long startTS) {
            this.startTS = startTS;
        }

        public long getEndTS() {
            return this.endTS;
        }

        public void setEndTS(long endTS) {
            this.endTS = endTS;
        }

        public int getNumFiles() {
            return this.numFiles;
        }

        public void setNumFiles(int numFiles) {
            this.numFiles = numFiles;
        }

        public void incNumFiles() {
            ++this.numFiles;
        }
    }
}

