/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.Historical;
import com.cenqua.clover.reporters.TestSelectionHelper;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.util.CloverUtils;
import com.cenqua.clover.util.Path;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class HtmlReporter {
    protected final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE MMM d yyyy HH:mm:ss z");
    protected CloverReportConfig mCfg;
    protected File mBasePath;
    protected File mBaseImgPath;
    protected CloverDatabase mDb;
    protected Date coverageTS;
    protected HtmlRenderingSupport mHelper;
    protected String mReportTS;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$html$HtmlReporter;

    public HtmlReporter(CloverReportConfig aCfg) throws IOException, CloverException {
        this.mCfg = this.ensureConfigAppropriate(aCfg);
        this.mHelper = new HtmlRenderingSupport(this.mCfg.getFormat(), true);
        this.mBasePath = this.mCfg.getOutFile();
        CloverUtils.createDir(this.mBasePath);
        this.mBaseImgPath = new File(this.mBasePath, "img");
        CloverUtils.createDir(this.mBaseImgPath);
        this.mReportTS = this.DATE_FORMAT.format(new Date(System.currentTimeMillis()));
    }

    private CloverReportConfig ensureConfigAppropriate(CloverReportConfig aCfg) throws CloverException {
        if (!(aCfg instanceof Current) && !(aCfg instanceof Historical)) {
            throw new CloverException("Unknown report type: " + aCfg.getClass().getName());
        }
        return aCfg;
    }

    public static void generateReport(CloverReportConfig cfg) throws CloverException {
        if (cfg instanceof Current) {
            HtmlReporter.generateCurrentReport(cfg);
        } else if (cfg instanceof Historical) {
            HtmlReporter.generateHistoricalReport(cfg);
        } else {
            throw new CloverException("No report type specified");
        }
    }

    public static void generateCurrentReport(CloverReportConfig cfg) throws CloverException {
        try {
            cfg.newReporter().createCurrentReport();
        }
        catch (IOException e) {
            throw new CloverException(e);
        }
        catch (Exception e) {
            throw new CloverException(e);
        }
    }

    public static void generateHistoricalReport(CloverReportConfig cfg) throws CloverException {
        try {
            cfg.newReporter().createHistoricalReport();
        }
        catch (IOException e) {
            throw new CloverException("IOException: " + e.getMessage());
        }
        catch (Exception e) {
            Logger.getInstance().error(e.getMessage(), e);
            throw new CloverException(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public abstract void createHistoricalReport() throws Exception;

    public void createCurrentReport() throws Exception {
        this.mDb = this.mCfg.getCoverageDatabase();
        if (!this.mCfg.isAlwaysReport() && !this.mDb.hasCoverage()) {
            Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
        } else {
            Logger.getInstance().info("Writing HTML report to '" + this.mBasePath + "'");
            this.coverageTS = new Date(this.mDb.getRecordingTimestamp());
            this.filterLinkedReports();
            this.createCurrentReportImpl();
        }
    }

    private void filterLinkedReports() {
        Map linkedReports = this.mCfg.getLinkedReports();
        LinkedHashMap filteredLinkedReports = new LinkedHashMap();
        Iterator iterator = linkedReports.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            CloverReportConfig link = (CloverReportConfig)e.getValue();
            if (!link.validate()) {
                Logger.getInstance().warn("Not linking report due to: " + link.getValidationFailureReason());
                continue;
            }
            Format format = link.getFormat();
            String type = format.getType();
            if ("JSON".equalsIgnoreCase(type) || "XML".equalsIgnoreCase(type)) continue;
            filteredLinkedReports.put(e.getKey(), link);
        }
        this.mCfg.setLinkedReports(filteredLinkedReports);
    }

    public abstract void createCurrentReportImpl() throws Exception;

    static Current processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_HTML);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") || args[i].equals("--outputdir")) {
                    cfg.setOutFile(new File(args[++i]));
                    cfg.setMainFileName("index.html");
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    cfg.setInitString(args[++i]);
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--title")) {
                    cfg.setTitle(args[++i]);
                    continue;
                }
                if (args[i].equals("-e") || args[i].equals("--showempty")) {
                    cfg.getFormat().setShowEmpty(true);
                    continue;
                }
                if (args[i].equals("-a") || args[i].equals("--alwaysreport")) {
                    cfg.setAlwaysReport(true);
                    continue;
                }
                if (args[i].equals("-nu") || args[i].equals("--nounique")) {
                    ++i;
                    cfg.setShowUniqueCoverage(false);
                    continue;
                }
                if (args[i].equals("-h") || args[i].equals("--hidesrc")) {
                    cfg.getFormat().setSrcLevel(false);
                    continue;
                }
                if (args[i].equals("-bw")) {
                    cfg.getFormat().setBw(true);
                    continue;
                }
                if (args[i].equals("-b") || args[i].equals("--hidebars")) {
                    cfg.getFormat().setShowBars(false);
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--span")) {
                    ++i;
                    try {
                        cfg.setSpan(new Interval(args[i]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        HtmlReporter.usage("Invalid interval format. Should be integer followed by unit (s, m, h, d, w).");
                        return null;
                    }
                }
                if (args[i].equals("-c") || args[i].equals("--orderby")) {
                    cfg.getFormat().setOrderby(args[++i]);
                    continue;
                }
                if (args[i].equals("-n") || args[i].equals("--nocache")) {
                    cfg.getFormat().setNoCache(true);
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (args[i].equals("-if") || args[i].equals("--includefailcoverage")) {
                    cfg.setIncludeFailedTestCoverage(true);
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("--sourcepath")) {
                    cfg.setSourcepath(new Path(args[++i]));
                    continue;
                }
                if (args[i].equals("-r") || args[i].equals("--resultsdir")) {
                    CloverUtils.logDeprecationWarning(args[i] + " argument");
                    continue;
                }
                if (args[i].equals("-f") || args[i].equals("--filter")) {
                    cfg.getFormat().setFilter(args[++i]);
                    continue;
                }
                if (args[i].equals("-tc") || args[i].equals("--threadcount")) {
                    ++i;
                    try {
                        int threadCount = Integer.parseInt(args[i]);
                        if (threadCount < 0) {
                            HtmlReporter.usage("Invalid thread count. Should be zero or a positive integer.");
                            return null;
                        }
                        cfg.setNumThreads(threadCount);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        HtmlReporter.usage("Invalid thread count. Should be an integer.");
                        return null;
                    }
                }
                if (!args[i].equals("-tw") && !args[i].equals("--tabwidth")) continue;
                ++i;
                try {
                    int tabwidth = Integer.parseInt(args[i]);
                    if (tabwidth >= 0 && tabwidth <= 10) {
                        cfg.getFormat().setTabWidth(tabwidth);
                        continue;
                    }
                    Logger.getInstance().warn("ignoring tab width value, out of range 0..10");
                    continue;
                }
                catch (NumberFormatException e) {
                    Logger.getInstance().warn("ignoring illegal tab width: " + e.getMessage());
                }
            }
            TestSelectionHelper.configureTestSelectionFilter(cfg, args);
            if (!cfg.validate()) {
                HtmlReporter.usage(cfg.getValidationFailureReason());
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            HtmlReporter.usage("Missing a parameter.");
            return null;
        }
        return cfg;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer().append("  USAGE: ");
        Class<?> clazz = class$com$cenqua$clover$reporters$html$HtmlReporter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$reporters$html$HtmlReporter = new HtmlReporter[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" [OPTIONS] PARAMS\n\n").append("  PARAMS:\n").append("    -i, --initstring <string>\tclover initstring\n\n").append("    -o, --outputdir <dir>\toutput directory for generated html.\n\n").append("  OPTIONS:\n").append("    -t, --title <string>\treport title.\n\n").append("    -bw\t\t\t\tDon't colour syntax-hilight source - smaller html output.\n\n").append("    -e, --showempty\t\tshow classes/packages even if they don't have any\n").append("\t\t\t\tstatements, methods or conditionals. default is false\n\n").append("    -nu, --nounique\t\tDon't calculate or show unique per-test coverage (this may significantly speed up report generation time). default is to calculate and show unique coverage.\n\n").append("    -n, --nocache\t\tinsert no-cache browser directives in html output.\n\n").append("    -h, --hidesrc\t\tdon't render source code. default is false.\n\n").append("    -b, --hidebars\t\tdon't render coverage bars. default is false.\n\n").append("    -p, --sourcepath\t\tThe sourcepath that Clover should search on for source files.\n\n").append("    -r, --testresults <dir>\tdirectory in which to look for XML test results.\n\n").append("    -s, --span <interval>\tSpecifies how far back in time to\n").append("\t\t\t\tinclude coverage recordings from since the last Clover build. In Interval\n").append("\t\t\t\tformat. \"60s\" = 60 seconds, \"1h\" = 1 hour, \"1d\" = 1 day etc.\n\n").append("    -tw, --tabwidth <int>\tnumber of spaces a tab should be rendered as. default is 4.\n\n").append("    -tc, --threadcount <int>\tnumber of additional threads to be allocated to report generation. Default is 0.\n\n").append("    -d,  --debug \t\tswitch logging level to debug\n\n").append("    -v,  --verbose \t\tswitch logging level to verbose\n\n").append("    -a,  --alwaysreport\t\tgenerate report even if there is no coverage to report on\n\n").append("    -if, --includefailcoverage\tinclude coverage from failed tests. Default is false.\n\n").append("    -f,  --filter <string>\tcomma separated list of contexts to filter\n").append("\t\t\t\twhen generating coverage reports. Most useful one is \"catch\".\n").append("\t\t\t\tvalid values are \"static\",\"instance\",\"constructor\",\"method\",\"switch\",\n").append("\t\t\t\t\"while\",\"do\",\"for\",\"if\",\"else\",\"try\",\"catch\",\"finally\",\"sync\"\n\n").append("    -c,  --orderby <compname>\tcomparator to use when listing packages and classes.\n").append("\t\t\t\tvalid values are \"alpha\" - alphabetic, \"desc\" - coverage descending,\n").append("\t\t\t\t\"asc\" - coverage ascending. default is \"asc\".\n\n").toString());
        System.err.println(TestSelectionHelper.getParamsUsage());
    }

    public static void main(String[] args) {
        System.exit(HtmlReporter.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(Logger.getInstance());
        Current cfg = HtmlReporter.processArgs(args);
        if (cfg == null || HtmlReportUtil.getVelocityEngine() == null) {
            return 1;
        }
        try {
            cfg.newReporter().createCurrentReport();
            return 0;
        }
        catch (IOException ioe) {
            Logger.getInstance().error("IO Exception occured rendering report: " + ioe.getMessage(), ioe);
        }
        catch (Exception e) {
            Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
        }
        return 1;
    }
}

