/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.Logger;
import com.cenqua.clover.instr.FileMappedTestDetector;
import com.cenqua.clover.instr.Instrumenter;
import com.cenqua.clover.tasks.AbstractInstrTask;
import com.cenqua.clover.tasks.TestSourceSet;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class CloverInstrTask
extends AbstractInstrTask {
    private File srcDir;
    private File testSrcDir;
    private File destDir;

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setTestSrcDir(File testSrcDir) {
        this.testSrcDir = testSrcDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public boolean validate() {
        FileSet fileSet;
        Object fs;
        if (!super.validate()) {
            return false;
        }
        if (this.destDir == null) {
            throw new BuildException("destdir is required");
        }
        if (this.srcDir != null) {
            if (!this.srcDir.isDirectory()) {
                throw new BuildException("srcdir '" + this.srcDir + "' not found or not a directory");
            }
            if (this.srcDir.equals(this.destDir)) {
                throw new BuildException("srcdir cannot be the same as destdir");
            }
            fs = new FileSet();
            fs.setDir(this.srcDir);
            fs.setIncludes("**/*.java");
            this.addFileset((FileSet)fs);
        }
        if (this.testSrcDir != null) {
            if (!this.testSrcDir.isDirectory()) {
                throw new BuildException("testSrcDir '" + this.testSrcDir + "' not found or not a directory");
            }
            if (this.testSrcDir.equals(this.destDir)) {
                throw new BuildException("testSrcDir cannot be the same as destdir");
            }
            TestSourceSet ts = new TestSourceSet();
            ts.setDir(this.testSrcDir);
            ts.setIncludes("**/*.java");
            this.addConfiguredTestSources(ts);
        }
        if (!(this.instrFilesets != null && this.instrFilesets.size() != 0 || this.testSources != null && this.testSources.size() != 0)) {
            throw new BuildException("You must specify either the srcdir or one or more filesets to be instrumented");
        }
        if (this.instrFilesets != null) {
            fs = this.instrFilesets.iterator();
            while (fs.hasNext()) {
                fileSet = (FileSet)fs.next();
                if (!fileSet.getDir(this.getProject()).equals(this.destDir)) continue;
                throw new BuildException("srcdir cannot be the same as destdir: " + this.destDir);
            }
        }
        if (this.testSources != null) {
            fs = this.testSources.iterator();
            while (fs.hasNext()) {
                fileSet = (FileSet)fs.next();
                if (!fileSet.getDir(this.getProject()).equals(this.destDir)) continue;
                throw new BuildException("test srcdir cannot be the same as destdir: " + this.destDir);
            }
        }
        return true;
    }

    public void cloverExecute() {
        Logger log = Logger.getInstance();
        try {
            HashSet instrSet = new HashSet();
            if (this.instrFilesets != null) {
                Iterator fs = this.instrFilesets.iterator();
                while (fs.hasNext()) {
                    FileSet fileSet = (FileSet)fs.next();
                    this.addIncludedFilesToInstrSet(instrSet, fileSet);
                }
            }
            if (this.testSources != null) {
                FileMappedTestDetector fileMappedTestDetector = new FileMappedTestDetector();
                Iterator ts = this.testSources.iterator();
                while (ts.hasNext()) {
                    TestSourceSet testSourceSet = (TestSourceSet)ts.next();
                    testSourceSet.setProject(this.getProject());
                    this.addIncludedFilesToInstrSet(instrSet, testSourceSet);
                    fileMappedTestDetector.addTestSourceMatcher(testSourceSet);
                }
                this.config.setTestDetector(fileMappedTestDetector);
            }
            Instrumenter instr = new Instrumenter(log, this.config);
            instr.startInstrumentation();
            Iterator files = instrSet.iterator();
            while (files.hasNext()) {
                File file = (File)files.next();
                instr.instrument(file, this.destDir);
            }
            instr.endInstrumentation();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void addIncludedFilesToInstrSet(Set instrSet, FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        File baseDir = ds.getBasedir();
        String[] filenames = ds.getIncludedFiles();
        for (int i = 0; i < filenames.length; ++i) {
            instrSet.add(new File(baseDir, filenames[i]));
        }
    }
}

