/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestCoverageStrategy;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.tasks.AbstractCloverTask;
import com.cenqua.clover.test.optimization.Snapshot;
import com.cenqua.clover.test.optimization.SnapshotPrinter;
import java.io.File;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;

public class CloverSnapshotTask
extends AbstractCloverTask {
    private Interval initialSpan = Interval.DEFAULT_SPAN;
    private File file;
    private boolean debug;

    public void setSpan(String initialspan) {
        this.initialSpan = new Interval(initialspan);
    }

    public void setInitialSpan(String initialspan) {
        this.initialSpan = new Interval(initialspan);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void cloverExecute() {
        File snapshotLocation = this.file != null ? this.file : Snapshot.fileForInitString(this.config.resolveInitString());
        try {
            long start;
            Logger.getInstance().verbose("Attempting to load snapshot file from '" + snapshotLocation + "'");
            Snapshot snapshot = Snapshot.loadFromFile(snapshotLocation);
            if (snapshot == null) {
                Logger.getInstance().info("Snapshot file not found, creating new file at " + snapshotLocation.getAbsolutePath());
                start = System.currentTimeMillis();
                CloverDatabase db = CloverDatabase.loadWithCoverage(this.config.resolveInitString(), new CoverageDataSpec(null, this.initialSpan.getValueInMillis(), false, true, true, true, PerTestCoverageStrategy.IN_MEMORY));
                Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - start) + "ms to load coverage data to generate the snapshot");
                snapshot = Snapshot.generateFor(db, snapshotLocation.getAbsolutePath());
            } else {
                LinkedList versions;
                if (this.debug) {
                    snapshot.setDebug(this.debug);
                    SnapshotPrinter.prettyPrint(snapshot, Logger.getInstance(), 4);
                }
                long lastVersion = (versions = new LinkedList(snapshot.getDbVersions())).size() == 0 ? this.initialSpan.getValueInMillis() : ((Long)versions.getLast()).longValue();
                long span = Math.max(0L, System.currentTimeMillis() - lastVersion);
                start = System.currentTimeMillis();
                CloverDatabase db = CloverDatabase.loadWithCoverage(this.config.resolveInitString(), new CoverageDataSpec(null, span, false, true, true, true, PerTestCoverageStrategy.IN_MEMORY));
                Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - start) + "ms to load coverage data to update the snapshot");
                Logger.getInstance().info("Updating snapshot '" + snapshotLocation.getAbsolutePath() + "' against Clover database at '" + db.getInitstring() + "'");
                snapshot.updateFor(db);
            }
            start = System.currentTimeMillis();
            snapshot.store();
            Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - start) + "ms to snapshot");
        }
        catch (Exception e) {
            Logger.getInstance().error("Failed to create or update snapshot file at " + snapshotLocation.getAbsolutePath(), e);
            throw new BuildException((Throwable)e);
        }
    }
}

