/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.Executors;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang.Thread_UncaughtExceptionHandler_;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Thread;
import com.cenqua.clover.Logger;
import com.cenqua.clover.util.CloverExecutor;

public class CloverExecutors {
    private CloverExecutors() {
    }

    public static CloverExecutor newCloverExecutor(int numThreads, String threadPrefix) {
        return new CloverExecutorService(numThreads, threadPrefix);
    }

    private static class CloverExceptionHandler
    implements Thread_UncaughtExceptionHandler_ {
        private CloverExceptionHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            Logger.getInstance().error(thread.getName(), throwable);
        }
    }

    private static class LoggingCallable
    implements Callable {
        private final Callable task;

        public LoggingCallable(Callable callable) {
            this.task = callable;
        }

        public Object call() throws Exception {
            try {
                return this.task.call();
            }
            catch (Throwable e) {
                Logger.getInstance().warn(e);
                return null;
            }
        }
    }

    private static class CloverExecutorService
    implements CloverExecutor {
        private final ExecutorService service;

        public CloverExecutorService(int numThreads, final String threadPrefix) {
            final CloverExceptionHandler handler = new CloverExceptionHandler();
            this.service = numThreads > 0 ? Executors.newFixedThreadPool(numThreads, new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    _Thread.setUncaughtExceptionHandler(thread, handler);
                    thread.setName(threadPrefix + "-" + thread.getName());
                    return thread;
                }
            }) : null;
        }

        public void shutdown() {
            if (this.service != null) {
                this.service.shutdown();
            }
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.service == null || this.service.awaitTermination(timeout, unit);
        }

        public void submit(Callable task) throws Exception {
            if (this.service != null) {
                this.service.submit(new LoggingCallable(task));
            } else {
                task.call();
            }
        }
    }
}

