/*
 * Decompiled with CFR 0.152.
 */
package jomp.compiler;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import jomp.compiler.ASTCompilationUnit;
import jomp.compiler.JavaParser;
import jomp.compiler.OMPVisitor;
import jomp.compiler.ParseException;
import jomp.compiler.StringStack;
import jomp.compiler.UnparseVisitor;

public class Jomp {
    public static final String version = "1.0.beta";

    public static void message(int n, String string) {
        if (n <= Options.messageLevel) {
            System.err.println(string);
        }
    }

    public static void main(String[] stringArray) {
        Jomp.message(4, "Jomp Version 1.0.beta.");
        int n = 0;
        if (stringArray.length == 0) {
            Jomp.message(2, "Usage: jomp [-lsv] [-p <procs>] [-o <outfile>] [-d <schedule>] <classes>");
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].charAt(0) == '-') {
                int n3 = 1;
                while (n3 < stringArray[n2].length()) {
                    switch (n) {
                        case 1: {
                            System.err.println("Warning: missing argument to command line option -o");
                            break;
                        }
                        case 2: {
                            System.err.println("Warning: missing argument to command line option -p");
                            break;
                        }
                        case 3: {
                            System.err.println("Warning: missing argument to command line option -p");
                        }
                    }
                    n = 0;
                    switch (stringArray[n2].charAt(n3)) {
                        case 'd': {
                            n = 3;
                            break;
                        }
                        case 'j': {
                            Options.noCompile = true;
                            break;
                        }
                        case 'k': {
                            Options.keepJava = true;
                            break;
                        }
                        case 'l': {
                            Options.debugLoops = true;
                            break;
                        }
                        case 'o': {
                            n = 1;
                            break;
                        }
                        case 'p': {
                            n = 2;
                            break;
                        }
                        case 's': {
                            Options.sequential = true;
                            break;
                        }
                        case 'v': {
                            Options.verbose = true;
                            break;
                        }
                        default: {
                            System.err.println("Warning: meaningless compiler flag -" + stringArray[n2].charAt(n3));
                        }
                    }
                    ++n3;
                }
            } else {
                switch (n) {
                    case 0: {
                        Options.classes.Push(stringArray[n2]);
                        break;
                    }
                    case 1: {
                        System.err.println("Not currently supported.");
                        break;
                    }
                    case 2: {
                        try {
                            Options.numProcs = Integer.parseInt(stringArray[n2]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.err.println("Number of processors must be an integer!");
                        }
                        break;
                    }
                    case 3: {
                        if (stringArray[n2].compareTo("static") == 0) {
                            Options.schedMode = 50;
                            break;
                        }
                        if (stringArray[n2].compareTo("dynamic") == 0) {
                            Options.schedMode = 79;
                            break;
                        }
                        if (stringArray[n2].compareTo("guided") == 0) {
                            Options.schedMode = 80;
                            break;
                        }
                        if (stringArray[n2].compareTo("runtime") == 0) {
                            Options.schedMode = 81;
                            break;
                        }
                        System.err.println("Unknown scheduling option " + stringArray[n2] + " - ignored.");
                    }
                }
                n = 0;
            }
            ++n2;
        }
        String string = Options.classes.Pop();
        while (string != null) {
            System.err.println("Compiling class " + string + "....");
            try {
                Object object;
                if (Options.sequential) {
                    Runtime.getRuntime().exec("cp " + string + ".jomp " + string + ".java");
                } else {
                    object = new FileInputStream(string + ".jomp");
                    JavaParser javaParser = new JavaParser((InputStream)object);
                    ASTCompilationUnit aSTCompilationUnit = javaParser.CompilationUnit();
                    PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".java"));
                    UnparseVisitor unparseVisitor = Options.sequential ? new UnparseVisitor(printWriter) : new OMPVisitor(printWriter);
                    aSTCompilationUnit.jjtAccept(unparseVisitor, null);
                    printWriter.close();
                }
                if (!Options.noCompile) {
                    object = Runtime.getRuntime().exec("javac " + string + ".java");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Cannot find file " + string + ".jomp.");
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                System.err.println("Problem executing something.");
            }
            catch (ParseException parseException) {
                System.err.println("Parsing error.");
                System.err.println(parseException.getMessage());
                parseException.printStackTrace();
            }
            string = Options.classes.Pop();
        }
    }

    public static class Options {
        public static int schedMode = 50;
        public static boolean noCompile = true;
        public static boolean keepJava = false;
        public static boolean sequential = false;
        public static StringStack classes = new StringStack();
        public static int numProcs = 8;
        public static boolean verbose = false;
        public static int messageLevel = 12;
        public static boolean debugLoops = false;
    }
}

