/*
 * Decompiled with CFR 0.152.
 */
package jomp.compiler;

public class SymbolTable {
    Symbol wp;
    private Symbol currentSymbol = new Symbol();

    public SymbolTable() {
        this.currentSymbol.isNewScope = true;
    }

    public Symbol addSymbol(String string) {
        Symbol symbol = new Symbol();
        symbol.prev = this.currentSymbol;
        this.currentSymbol = symbol;
        this.currentSymbol.name = string;
        return this.currentSymbol;
    }

    public Symbol findSymbol(String string) {
        Symbol symbol = this.currentSymbol;
        while (symbol != null) {
            if (!symbol.isNewScope && symbol.name.compareTo(string) == 0) {
                return symbol;
            }
            symbol = symbol.prev;
        }
        return null;
    }

    public void getInit() {
        this.wp = new Symbol();
        this.wp.prev = this.currentSymbol;
    }

    public Symbol getNext() {
        while (this.wp.prev != null) {
            this.wp = this.wp.prev;
            if (this.wp.isNewScope) continue;
            return this.wp;
        }
        return null;
    }

    public void addScope() {
        Symbol symbol = new Symbol();
        symbol.prev = this.currentSymbol;
        this.currentSymbol = symbol;
        this.currentSymbol.isNewScope = true;
    }

    public void killScope() {
        try {
            while (!this.currentSymbol.isNewScope) {
                this.currentSymbol = this.currentSymbol.prev;
            }
            this.currentSymbol = this.currentSymbol.prev;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("SymbolTable stack underflow!");
            return;
        }
    }

    public void dumpTable() {
        Symbol symbol = this.currentSymbol;
        System.err.println("----------------------------------------");
        while (symbol != null) {
            if (symbol.isNewScope) {
                System.err.println("NEW SCOPE");
            } else {
                System.err.println(symbol.sig + " " + symbol.name);
            }
            symbol = symbol.prev;
        }
        System.err.println("----------------------------------------");
    }

    public static class Symbol {
        private boolean isNewScope = false;
        private Symbol prev;
        public String name = null;
        public String sig = null;
        public boolean isInitialized = false;
    }
}

