/*
 * Decompiled with CFR 0.152.
 */
package jomp.runtime;

import java.util.Hashtable;
import jomp.runtime.Barrier;
import jomp.runtime.BusyTask;
import jomp.runtime.BusyThread;
import jomp.runtime.LoopData;
import jomp.runtime.Machine;
import jomp.runtime.NestLock;
import jomp.runtime.OMPException;
import jomp.runtime.Orderer;
import jomp.runtime.Reducer;
import jomp.runtime.Ticketer;

public class OMP {
    static boolean isRunning;
    static boolean isStarted;
    static boolean isParallel;
    private static int numThreads;
    private static int numProcs;
    private static Barrier[] threadBarrier;
    private static Ticketer[] threadTicketer;
    private static Orderer[] threadOrderer;
    private static Reducer[] threadReducer;
    private static int[] threadID;
    private static int[] threadNum;
    private static BusyThread[] threads;
    private static Throwable[] threadException;
    private static int globTicket;
    private static Hashtable criticalTable;
    private static BusyTask lastTask;

    public static void start() {
        criticalTable = new Hashtable(5);
        threadBarrier = new Barrier[numThreads];
        threadTicketer = new Ticketer[numThreads];
        threadReducer = new Reducer[numThreads];
        threadOrderer = new Orderer[numThreads];
        threadID = new int[numThreads];
        threadNum = new int[numThreads];
        threadException = new Throwable[numThreads];
        Barrier barrier = new Barrier(numThreads);
        Ticketer ticketer = new Ticketer();
        Reducer reducer = new Reducer(numThreads);
        Orderer orderer = new Orderer();
        isRunning = false;
        threads = new BusyThread[numThreads];
        int n = 0;
        while (n < numThreads) {
            OMP.threadBarrier[n] = barrier;
            OMP.threadTicketer[n] = ticketer;
            OMP.threadReducer[n] = reducer;
            OMP.threadOrderer[n] = orderer;
            OMP.threadNum[n] = numThreads;
            OMP.threadID[n] = n;
            OMP.threadException[n] = null;
            if (n == 0) {
                OMP.threads[0] = null;
                Thread.currentThread().setName("0");
            } else {
                OMP.threads[n] = new BusyThread(n);
                threads[n].setName(Integer.toString(n));
                threads[n].setDaemon(true);
                threads[n].start();
            }
            ++n;
        }
        isRunning = true;
        isStarted = true;
    }

    public static void stop() {
        if (isStarted) {
            isRunning = false;
            OMP.doGlobalBarrier(0);
            isStarted = false;
        }
    }

    public static void kill() {
        int n = 1;
        while (n < numThreads) {
            threads[n].stop();
            ++n;
        }
        isParallel = false;
        OMP.setNumThreads(numThreads);
    }

    public static void doParallel(BusyTask busyTask) throws Throwable {
        if (isParallel) {
            int n = OMP.getAbsoluteID();
            Barrier barrier = threadBarrier[n];
            Ticketer ticketer = threadTicketer[n];
            Reducer reducer = threadReducer[n];
            Orderer orderer = threadOrderer[n];
            int n2 = threadNum[n];
            int n3 = threadID[n];
            Throwable throwable = threadException[n];
            OMP.threadBarrier[n] = new Barrier(1);
            OMP.threadTicketer[n] = new Ticketer();
            OMP.threadReducer[n] = new Reducer(1);
            OMP.threadOrderer[n] = new Orderer();
            OMP.threadNum[n] = 1;
            OMP.threadID[n] = 0;
            OMP.threadException[n] = null;
            busyTask.go(0);
            Throwable throwable2 = threadException[n];
            OMP.threadBarrier[n] = barrier;
            OMP.threadTicketer[n] = ticketer;
            OMP.threadReducer[n] = reducer;
            OMP.threadOrderer[n] = orderer;
            OMP.threadNum[n] = n2;
            OMP.threadID[n] = n3;
            OMP.threadException[n] = throwable;
            if (throwable2 != null) {
                throw throwable2;
            }
        } else {
            if (!isStarted) {
                OMP.start();
            }
            isParallel = true;
            if (busyTask != lastTask) {
                int n = 1;
                while (n < numThreads) {
                    OMP.threads[n].mytask = busyTask;
                    ++n;
                }
                lastTask = busyTask;
            }
            OMP.doGlobalBarrier(0);
            try {
                busyTask.go(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Options.isExceptionable) {
                Throwable throwable = threadException[0];
                OMP.threadException[0] = null;
                if (throwable != null) {
                    OMP.kill();
                    throw throwable;
                }
            }
            OMP.doGlobalBarrier(0);
            isParallel = false;
        }
    }

    public static void doBarrier(int n) {
        if (OMP.getNumThreads(n) > 1) {
            threadBarrier[n].DoBarrier(OMP.getThreadNum(n));
        }
    }

    public static void doBarrier() {
        if (!isParallel) {
            return;
        }
        int n = OMP.getAbsoluteID();
        if (OMP.getNumThreads(n) > 1) {
            threadBarrier[n].DoBarrier(OMP.getThreadNum(n));
        }
    }

    public static void doGlobalBarrier(int n) {
        threadBarrier[n].DoBarrier(n);
    }

    public static long doPlusReduce(int n, long l) {
        if (!isParallel) {
            return l;
        }
        return threadReducer[n].doPlusReduce(OMP.getThreadNum(n), l);
    }

    public static double doPlusReduce(int n, double d) {
        if (!isParallel) {
            return d;
        }
        return threadReducer[n].doPlusReduce(OMP.getThreadNum(n), d);
    }

    public static long doMultReduce(int n, long l) {
        if (!isParallel) {
            return l;
        }
        return threadReducer[n].doMultReduce(OMP.getThreadNum(n), l);
    }

    public static double doMultReduce(int n, double d) {
        if (!isParallel) {
            return d;
        }
        return threadReducer[n].doMultReduce(OMP.getThreadNum(n), d);
    }

    public static boolean doAndReduce(int n, boolean bl) {
        if (!isParallel) {
            return bl;
        }
        return threadReducer[n].doAndReduce(OMP.getThreadNum(n), bl);
    }

    public static boolean doOrReduce(int n, boolean bl) {
        if (!isParallel) {
            return bl;
        }
        return threadReducer[n].doOrReduce(OMP.getThreadNum(n), bl);
    }

    public static double doBitOrReduce(int n, long l) {
        if (!isParallel) {
            return l;
        }
        return threadReducer[n].doBitOrReduce(OMP.getThreadNum(n), l);
    }

    public static double doBitXorReduce(int n, long l) {
        if (!isParallel) {
            return l;
        }
        return threadReducer[n].doBitXorReduce(OMP.getThreadNum(n), l);
    }

    public static double doBitAndReduce(int n, long l) {
        if (!isParallel) {
            return l;
        }
        return threadReducer[n].doBitAndReduce(OMP.getThreadNum(n), l);
    }

    public static void setChunkStatic(LoopData loopData) {
        loopData.chunkSize = loopData.stop - loopData.start;
        if (loopData.chunkSize < 0L) {
            loopData.chunkSize *= -1L;
        }
        loopData.chunkSize = (loopData.chunkSize - 1L) / loopData.step;
        loopData.chunkSize = loopData.chunkSize / (long)OMP.getNumThreads() + 1L;
    }

    public static void setChunkRuntime(LoopData loopData) {
        if (Options.isSchedChunkSet) {
            loopData.chunkSize = Options.schedChunkSize;
        } else {
            switch (Options.schedMode) {
                case 0: {
                    OMP.setChunkStatic(loopData);
                    break;
                }
                case 1: 
                case 2: {
                    loopData.chunkSize = 1L;
                }
            }
        }
    }

    public static boolean getLoopStatic(int n, LoopData loopData, LoopData loopData2) {
        loopData2.start = loopData.start + loopData.chunkSize * loopData.step * (long)OMP.getThreadNum(n);
        loopData2.stop = loopData2.start + loopData.chunkSize * loopData.step;
        loopData2.startStep = loopData.chunkSize * loopData.step * (long)OMP.getNumThreads(n);
        loopData2.step = loopData.step;
        loopData2.isLast = true;
        return true;
    }

    public static boolean getLoopDynamic(int n, LoopData loopData, LoopData loopData2) {
        if (!isParallel) {
            loopData2.start = loopData.start;
            loopData2.stop = loopData.stop;
            loopData2.step = loopData.step;
            loopData2.isLast = true;
            return true;
        }
        threadTicketer[n].issueDynamic(loopData2);
        if (loopData.step > 0L) {
            if (loopData2.start >= loopData.stop) {
                return false;
            }
            if (loopData2.stop >= loopData.stop) {
                loopData2.stop = loopData.stop;
                loopData2.isLast = true;
            }
        } else {
            if (loopData2.start <= loopData.stop) {
                return false;
            }
            if (loopData2.stop <= loopData.stop) {
                loopData2.stop = loopData.stop;
                loopData2.isLast = true;
            }
        }
        loopData2.step = loopData.step;
        return true;
    }

    public static boolean getLoopGuided(int n, LoopData loopData, LoopData loopData2) {
        if (!isParallel) {
            loopData2.start = loopData.start;
            loopData2.stop = loopData.stop;
            loopData2.step = loopData.step;
            loopData2.isLast = true;
            return true;
        }
        return threadTicketer[n].issueGuided(loopData, loopData2, threadNum[n]);
    }

    public static boolean getLoopRuntime(int n, LoopData loopData, LoopData loopData2) {
        switch (Options.schedMode) {
            case 0: {
                return OMP.getLoopStatic(n, loopData, loopData2);
            }
            case 1: {
                return OMP.getLoopDynamic(n, loopData, loopData2);
            }
            case 2: {
                return OMP.getLoopGuided(n, loopData, loopData2);
            }
        }
        return false;
    }

    public static long getTicket(int n) {
        if (!isParallel) {
            return globTicket++;
        }
        return threadTicketer[n].issue();
    }

    public static void resetTicket(int n) {
        if (!isParallel) {
            globTicket = 0;
            return;
        }
        OMP.threadTicketer[n] = threadTicketer[n].reset();
    }

    public static void initTicket(int n, LoopData loopData) {
        threadTicketer[n].initDyn(loopData);
    }

    public static void resetOrderer(int n, long l) {
        if (!isParallel) {
            return;
        }
        OMP.threadOrderer[n] = threadOrderer[n].reset(l, n);
    }

    public static void startOrdered(int n, long l) {
        if (!isParallel) {
            return;
        }
        threadOrderer[n].startOrdered(l, n);
    }

    public static void stopOrdered(int n, long l) {
        if (!isParallel) {
            return;
        }
        threadOrderer[n].stopOrdered(l);
    }

    public static void setNumThreads(int n) {
        if (isParallel) {
            throw new OMPException("setNumThreads called in a parallel region!");
        }
        numThreads = n;
        if (isStarted) {
            OMP.stop();
        }
    }

    public static int getNumThreads() {
        if (!isParallel) {
            return 1;
        }
        return threadNum[OMP.getAbsoluteID()];
    }

    public static int getMaxThreads() {
        return numThreads;
    }

    public static int getThreadNum() {
        if (!isParallel) {
            return 0;
        }
        return threadID[OMP.getAbsoluteID()];
    }

    public static int getNumProcs() {
        return Machine.getNumProcs();
    }

    public static boolean inParallel() {
        return isParallel;
    }

    public static void setDynamic(int n) {
    }

    public static boolean getDynamic() {
        return false;
    }

    public static void setNested(boolean bl) {
    }

    public static boolean getNested() {
        return false;
    }

    public static int getNumThreads(int n) {
        if (!isParallel) {
            return 1;
        }
        return threadNum[n];
    }

    public static int getThreadNum(int n) {
        if (!isParallel) {
            return 0;
        }
        return threadID[n];
    }

    public static synchronized NestLock getLockByName(String string) {
        NestLock nestLock;
        if (criticalTable == null) {
            System.err.println("No critical table!!");
        }
        if ((nestLock = (NestLock)criticalTable.get(string)) == null) {
            nestLock = new NestLock();
            criticalTable.put(string, nestLock);
        }
        return nestLock;
    }

    public static int getAbsoluteID() {
        if (isParallel) {
            return Integer.parseInt(Thread.currentThread().getName());
        }
        return 0;
    }

    public static boolean isDynamic() {
        return Options.schedMode == 1;
    }

    public static synchronized void handleException(int n, Throwable throwable) {
        if (OMP.getNumThreads() == 1) {
            if (Options.isExceptionable) {
                OMP.threadException[n] = throwable;
            } else {
                System.err.println("Exceptions may not be thrown from parallel constructs!");
            }
        } else if (Options.isExceptionable) {
            OMP.threadException[0] = throwable;
        } else {
            System.err.println("Exceptions may not be thrown from parallel constructs!");
        }
    }

    private static void setNumProcs(int n) {
        if (isParallel) {
            throw new OMPException("setNumProcs called in a sequential region!");
        }
        numProcs = n;
        Machine.setNumProcs(n);
        if (isStarted) {
            OMP.stop();
        }
    }

    static {
        int n;
        isRunning = false;
        isStarted = false;
        isParallel = false;
        numThreads = 1;
        numProcs = 16;
        globTicket = 0;
        lastTask = null;
        String string = System.getProperty("jomp.schedule");
        if (string != null) {
            n = string.indexOf(44);
            if (n != -1) {
                try {
                    Options.schedChunkSize = Integer.parseInt(string.substring(n + 1));
                    Options.isSchedChunkSet = true;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Schedule chunksize must be an integer number - using default value");
                }
                string = string.substring(0, n).toLowerCase();
            }
            System.err.println("Scheduling mode " + string);
            if (string.compareTo("static") == 0) {
                Options.schedMode = 0;
            } else if (string.compareTo("dynamic") == 0) {
                Options.schedMode = 1;
            } else if (string.compareTo("guided") == 0) {
                Options.schedMode = 2;
            } else {
                System.err.println("Unknown default scheduling option!");
            }
        }
        n = 1;
        string = System.getProperty("jomp.threads");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("jomp.threads must be an integer - using default value.");
                n = 1;
            }
        }
        OMP.setNumThreads(n);
        OMP.setNumProcs(2 * n);
    }

    private static class Options {
        static final int SCHED_STATIC = 0;
        static final int SCHED_DYNAMIC = 1;
        static final int SCHED_GUIDED = 2;
        static int schedMode = 0;
        static boolean isSchedChunkSet = false;
        static int schedChunkSize;
        static boolean isExceptionable;

        private Options() {
        }

        static {
            isExceptionable = true;
        }
    }
}

