/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class Tile {
    public static BufferedImage LOADING_IMAGE;
    public static BufferedImage ERROR_IMAGE;
    protected TileSource source;
    protected int xtile;
    protected int ytile;
    protected int zoom;
    protected BufferedImage image;
    protected String key;
    protected boolean loaded = false;
    protected boolean loading = false;
    public static final int SIZE = 256;

    public Tile(TileSource tileSource, int n, int n2, int n3) {
        this.source = tileSource;
        this.xtile = n;
        this.ytile = n2;
        this.zoom = n3;
        this.image = LOADING_IMAGE;
        this.key = Tile.getTileKey(tileSource, n, n2, n3);
    }

    public Tile(TileSource tileSource, int n, int n2, int n3, BufferedImage bufferedImage) {
        this(tileSource, n, n2, n3);
        this.image = bufferedImage;
    }

    public void loadPlaceholderFromCache(TileCache tileCache) {
        BufferedImage bufferedImage = new BufferedImage(256, 256, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        for (int i = 1; i < 5; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this.zoom + i;
            if (i < 3 && n5 <= 22) {
                n4 = 1 << i;
                n3 = this.xtile << i;
                n2 = this.ytile << i;
                double d = 1.0 / (double)n4;
                graphics2D.setTransform(AffineTransform.getScaleInstance(d, d));
                int n6 = 0;
                for (int j = 0; j < n4; ++j) {
                    for (n = 0; n < n4; ++n) {
                        Tile tile = tileCache.getTile(this.source, n3 + j, n2 + n, n5);
                        if (tile == null || !tile.isLoaded()) continue;
                        ++n6;
                        tile.paint(graphics2D, j * 256, n * 256);
                    }
                }
                if (n6 == n4 * n4) {
                    this.image = bufferedImage;
                    return;
                }
            }
            if ((n4 = this.zoom - i) < 0) continue;
            n3 = this.xtile >> i;
            n2 = this.ytile >> i;
            int n7 = 1 << i;
            double d = n7;
            AffineTransform affineTransform = new AffineTransform();
            n = this.xtile % n7 * 256;
            int n8 = this.ytile % n7 * 256;
            affineTransform.setTransform(d, 0.0, 0.0, d, -n, -n8);
            graphics2D.setTransform(affineTransform);
            Tile tile = tileCache.getTile(this.source, n3, n2, n4);
            if (tile == null || !tile.isLoaded()) continue;
            tile.paint(graphics2D, 0, 0);
            this.image = bufferedImage;
            return;
        }
    }

    public TileSource getSource() {
        return this.source;
    }

    public int getXtile() {
        return this.xtile;
    }

    public int getYtile() {
        return this.ytile;
    }

    public int getZoom() {
        return this.zoom;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void loadImage(InputStream inputStream) throws IOException {
        this.image = ImageIO.read(inputStream);
    }

    public String getKey() {
        return this.key;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public String getUrl() {
        return this.source.getTileUrl(this.zoom, this.xtile, this.ytile);
    }

    public void paint(Graphics graphics, int n, int n2) {
        if (this.image == null) {
            return;
        }
        graphics.drawImage(this.image, n, n2, null);
    }

    public String toString() {
        return "Tile " + this.key;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tile)) {
            return false;
        }
        Tile tile = (Tile)object;
        return this.xtile == tile.xtile && this.ytile == tile.ytile && this.zoom == tile.zoom;
    }

    public static String getTileKey(TileSource tileSource, int n, int n2, int n3) {
        return n3 + "/" + n + "/" + n2 + "@" + tileSource.getName();
    }

    static {
        try {
            LOADING_IMAGE = ImageIO.read(JMapViewer.class.getResourceAsStream("images/hourglass.png"));
            ERROR_IMAGE = ImageIO.read(JMapViewer.class.getResourceAsStream("images/error.png"));
        }
        catch (Exception exception) {
            LOADING_IMAGE = null;
            ERROR_IMAGE = null;
        }
    }
}

