/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CopyAction
extends JosmAction
implements SelectionChangedListener {
    private LinkedList<JosmAction> listeners;

    public CopyAction() {
        super(I18n.tr("Copy"), "copy", I18n.tr("Copy selected objects to paste buffer."), Shortcut.registerShortcut("system:copy", I18n.tr("Edit: {0}", I18n.tr("Copy")), 67, 2), true);
        this.setEnabled(false);
        DataSet.selListeners.add(this);
        this.listeners = new LinkedList();
    }

    @Override
    public void addListener(JosmAction josmAction) {
        this.listeners.add(josmAction);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (CopyAction.noSelection()) {
            return;
        }
        Main.pasteBuffer = CopyAction.copyData();
        Main.main.menu.paste.setEnabled(true);
        for (JosmAction josmAction : this.listeners) {
            josmAction.pasteBufferChanged(Main.pasteBuffer);
        }
    }

    public static DataSet copyData() {
        final DataSet dataSet = new DataSet();
        final HashMap hashMap = new HashMap();
        if (CopyAction.noSelection()) {
            return dataSet;
        }
        new Visitor(){

            public void visit(Node node) {
                if (hashMap.containsKey(node)) {
                    return;
                }
                Node node2 = new Node(node);
                hashMap.put(node, node2);
                dataSet.addPrimitive(node2);
            }

            public void visit(Way way) {
                if (hashMap.containsKey(way)) {
                    return;
                }
                Way way2 = new Way();
                way2.cloneFrom(way);
                way2.nodes.clear();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (Node node : way.nodes) {
                    if (!hashMap.containsKey(node)) {
                        node.visit(this);
                    }
                    arrayList.add((Node)hashMap.get(node));
                }
                way2.nodes.clear();
                way2.nodes.addAll(arrayList);
                dataSet.addPrimitive(way2);
            }

            public void visit(Relation relation) {
                if (hashMap.containsKey(relation)) {
                    return;
                }
                Relation relation2 = new Relation(relation);
                ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
                for (RelationMember relationMember : relation.members) {
                    if (!hashMap.containsKey(relationMember.member)) {
                        relationMember.member.visit(this);
                    }
                    RelationMember relationMember2 = new RelationMember(relationMember);
                    relationMember2.member = (OsmPrimitive)hashMap.get(relationMember.member);
                    arrayList.add(relationMember2);
                }
                relation2.members.addAll(arrayList);
                dataSet.addPrimitive(relation2);
            }

            public void visitAll() {
                for (OsmPrimitive osmPrimitive : Main.ds.getSelected()) {
                    osmPrimitive.visit(this);
                }
            }
        }.visitAll();
        return dataSet;
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(!collection.isEmpty());
    }

    private static boolean noSelection() {
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select something to copy."));
            return true;
        }
        return false;
    }
}

