/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PasteTagsAction
extends JosmAction
implements SelectionChangedListener {
    public PasteTagsAction(JosmAction josmAction) {
        super(I18n.tr("Paste Tags"), "pastetags", I18n.tr("Apply tags of contents of paste buffer to all selected items."), Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags")), 86, 2, 1), true);
        DataSet.selListeners.add(this);
        josmAction.addListener(this);
        this.setEnabled(false);
    }

    private void pasteKeys(Collection<Command> collection, Collection<? extends OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        if (collection3 != null && !collection3.isEmpty()) {
            for (OsmPrimitive osmPrimitive : collection2) {
                Map<String, String> map = osmPrimitive.keys;
                if (map == null) continue;
                for (String string : map.keySet()) {
                    if (string.equals("created_by")) continue;
                    collection.add(new ChangePropertyCommand(collection3, string, osmPrimitive.keys.get(string)));
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LinkedList<Command> linkedList = new LinkedList<Command>();
        this.pasteKeys(linkedList, Main.pasteBuffer.nodes, Main.ds.getSelectedNodes());
        this.pasteKeys(linkedList, Main.pasteBuffer.ways, Main.ds.getSelectedWays());
        this.pasteKeys(linkedList, Main.pasteBuffer.relations, Main.ds.getSelectedRelations());
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Paste Tags"), linkedList));
        Main.ds.setSelected(Main.ds.getSelected());
        Main.map.mapView.repaint();
    }

    private boolean containsSameKeysWithDifferentValues(Collection<? extends OsmPrimitive> collection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.keys == null || osmPrimitive.keys.isEmpty()) continue;
            for (String string : osmPrimitive.keys.keySet()) {
                if (string.equals("created_by")) continue;
                String string2 = osmPrimitive.keys.get(string);
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, string2);
                    continue;
                }
                if (((String)hashMap.get(string)).equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private void possiblyEnable(Collection<? extends OsmPrimitive> collection, DataSet dataSet) {
        this.setEnabled(!(collection == null || collection.isEmpty() || dataSet.allPrimitives().isEmpty() || !Main.ds.getSelectedNodes().isEmpty() && this.containsSameKeysWithDifferentValues(dataSet.nodes) || !Main.ds.getSelectedWays().isEmpty() && this.containsSameKeysWithDifferentValues(dataSet.ways) || !Main.ds.getSelectedRelations().isEmpty() && this.containsSameKeysWithDifferentValues(dataSet.relations)));
    }

    @Override
    public void pasteBufferChanged(DataSet dataSet) {
        this.possiblyEnable(Main.ds.getSelected(), dataSet);
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        this.possiblyEnable(collection, Main.pasteBuffer);
    }
}

