/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateDataAction
extends JosmAction {
    public UpdateDataAction() {
        super(I18n.tr("Update Data"), "updatedata", I18n.tr("Updates the current data layer from the server (re-downloads data)"), Shortcut.registerShortcut("file:updatedata", I18n.tr("Update Data"), 85, 0), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2 = 0;
        ArrayList<Area> arrayList = new ArrayList<Area>();
        for (DataSource dataSource : Main.main.editLayer().data.dataSources) {
            arrayList.add(new Area(dataSource.bounds.asRect()));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            for (int i = n + 1; i < arrayList.size(); ++i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        for (n = arrayList.size() - 1; n > 0; --n) {
            for (int i = n - 1; i > 0; --i) {
                ((Area)arrayList.get(n)).subtract((Area)arrayList.get(i));
            }
        }
        for (Area area : arrayList) {
            if (area.isEmpty()) continue;
            ++n2;
        }
        int n3 = new ExtendedDialog(Main.parent, I18n.tr("Update Data"), I18n.tr("This action will require {0} individual download requests. Do you wish to continue?", n2), new String[]{"Update Data", "Cancel"}, new String[]{"updatedata.png", "cancel.png"}).getValue();
        if (n3 != 1) {
            return;
        }
        DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
        for (Area area : arrayList) {
            Rectangle2D rectangle2D = area.getBounds2D();
            downloadOsmTask.download(null, rectangle2D.getMinY(), rectangle2D.getMinX(), rectangle2D.getMaxY(), rectangle2D.getMaxX());
        }
    }
}

