/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadOsmTask
implements DownloadDialog.DownloadTask {
    private static Bounds currentBounds;
    private JCheckBox checkBox = new JCheckBox(I18n.tr("OpenStreetMap data"), true);

    public void download(DownloadAction downloadAction, double d, double d2, double d3, double d4) {
        double d5;
        if (d > d3) {
            d5 = d;
            d = d3;
            d3 = d5;
        }
        if (d2 > d4) {
            d5 = d2;
            d2 = d4;
            d4 = d5;
        }
        Task task = new Task(downloadAction != null && (downloadAction.dialog == null || downloadAction.dialog.newLayer.isSelected()), new BoundingBoxDownloader(d, d2, d3, d4));
        currentBounds = new Bounds(new LatLon(d, d2), new LatLon(d3, d4));
        Main.worker.execute(task);
    }

    public void loadUrl(boolean bl, String string) {
        Task task = new Task(bl, new OsmServerLocationReader(string));
        Main.worker.execute(task);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getPreferencesSuffix() {
        return "osm";
    }

    private static class Task
    extends PleaseWaitRunnable {
        private OsmServerReader reader;
        private DataSet dataSet;
        private boolean newLayer;

        public Task(boolean bl, OsmServerReader osmServerReader) {
            super(I18n.tr("Downloading data"));
            this.reader = osmServerReader;
            this.newLayer = bl;
        }

        public void realRun() throws IOException, SAXException {
            this.dataSet = this.reader.parseOsm();
        }

        protected void finish() {
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                this.errorMessage = I18n.tr("No data imported.");
                this.dataSet.dataSources.add(new DataSource(currentBounds, "OpenStreetMap server"));
            }
            OsmDataLayer osmDataLayer = new OsmDataLayer(this.dataSet, I18n.tr("Data Layer"), null);
            if (this.newLayer) {
                Main.main.addLayer(osmDataLayer);
            } else {
                Main.main.editLayer().mergeFrom(osmDataLayer);
            }
        }

        protected void cancel() {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }
}

