/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawAction
extends MapMode
implements MapViewPaintable,
SelectionChangedListener,
AWTEventListener {
    private static Node lastUsedNode = null;
    private double PHI = Math.toRadians(90.0);
    private boolean ctrl;
    private boolean alt;
    private boolean shift;
    private Node mouseOnExistingNode;
    private Set<Way> mouseOnExistingWays = new HashSet<Way>();
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private boolean drawHelperLine;
    private boolean wayIsFinished = false;
    private boolean drawTargetHighlight;
    private boolean drawTargetCursor;
    private Point mousePos;
    private Point oldMousePos;
    private Color selectedColor;
    private Node currentBaseNode;
    private EastNorth currentMouseEastNorth;

    public DrawAction(MapFrame mapFrame) {
        super(I18n.tr("Draw"), "node/autonode", I18n.tr("Draw nodes"), Shortcut.registerShortcut("mapmode:draw", I18n.tr("Mode: {0}", I18n.tr("Draw")), 65, 3), mapFrame, DrawAction.getCursor());
        Main.contentPane.getInputMap(2).put(Shortcut.registerShortcut("mapmode:drawfocus", I18n.tr("Mode: Draw Focus"), 78, 3).getKeyStroke(), I18n.tr("Draw"));
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor("crosshair", null);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(1);
        }
    }

    private void setJoinCursor(boolean bl) {
        if (!this.drawTargetCursor) {
            this.resetCursor();
            return;
        }
        try {
            Main.map.mapView.setCursor(ImageProvider.getCursor("crosshair", bl ? "joinway" : "joinnode"));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.resetCursor();
            return;
        }
    }

    private void resetCursor() {
        Main.map.mapView.setCursor(DrawAction.getCursor());
    }

    private void addHighlighting() {
        if (this.ctrl) {
            this.removeHighlighting();
            this.resetCursor();
            return;
        }
        if (this.mouseOnExistingNode != null) {
            this.setJoinCursor(false);
            this.removeHighlighting();
            if (this.drawTargetHighlight) {
                this.oldHighlights.add(this.mouseOnExistingNode);
                this.mouseOnExistingNode.highlighted = true;
            }
            return;
        }
        if (this.mouseOnExistingWays.size() == 0) {
            this.removeHighlighting();
            this.resetCursor();
            return;
        }
        this.setJoinCursor(true);
        this.removeHighlighting();
        if (!this.drawTargetHighlight) {
            return;
        }
        this.oldHighlights.addAll(this.mouseOnExistingWays);
        for (Way way : this.mouseOnExistingWays) {
            way.highlighted = true;
        }
    }

    private void removeHighlighting() {
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.highlighted = false;
        }
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.selectedColor = Main.pref.getColor(I18n.marktr("selected"), Color.red);
        this.drawHelperLine = Main.pref.getBoolean("draw.helper-line", true);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        this.drawTargetCursor = Main.pref.getBoolean("draw.target-cursor", true);
        this.wayIsFinished = false;
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.addTemporaryLayer(this);
        DataSet.selListeners.add(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        DataSet.selListeners.remove(this);
        this.removeHighlighting();
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        InputEvent inputEvent = (InputEvent)aWTEvent;
        this.ctrl = (inputEvent.getModifiers() & 2) != 0;
        this.alt = (inputEvent.getModifiers() & 8) != 0;
        this.shift = (inputEvent.getModifiers() & 1) != 0;
        this.computeHelperLine();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        this.computeHelperLine();
    }

    private void tryAgain(MouseEvent mouseEvent) {
        Main.ds.setSelected(new OsmPrimitive[0]);
        this.mouseClicked(mouseEvent);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        Object object2;
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        if (mouseEvent.getClickCount() > 1 && this.mousePos != null && this.mousePos.equals(this.oldMousePos)) {
            lastUsedNode = null;
            this.wayIsFinished = true;
            Main.map.selectSelectTool(true);
            return;
        }
        this.oldMousePos = this.mousePos;
        this.ctrl = (mouseEvent.getModifiers() & 2) != 0;
        this.alt = (mouseEvent.getModifiers() & 8) != 0;
        this.shift = (mouseEvent.getModifiers() & 1) != 0;
        this.mousePos = mouseEvent.getPoint();
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = false;
        Node node = null;
        if (!this.ctrl) {
            node = Main.map.mapView.getNearestNode(this.mousePos);
        }
        if (node != null) {
            if (this.shift || collection.isEmpty()) {
                Main.ds.setSelected(node);
                return;
            }
        } else {
            node = new Node(Main.map.mapView.getLatLon(mouseEvent.getX(), mouseEvent.getY()));
            if (node.coor.isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world."));
                return;
            }
            bl = true;
            linkedList.add(new AddCommand(node));
            if (!this.ctrl) {
                List<WaySegment> list = Main.map.mapView.getNearestWaySegments(mouseEvent.getPoint());
                HashMap hashMap = new HashMap();
                for (WaySegment waySegment : list) {
                    void var12_22;
                    if (hashMap.containsKey(waySegment.way)) {
                        List list2 = (List)hashMap.get(waySegment.way);
                    } else {
                        ArrayList arrayList3 = new ArrayList();
                        hashMap.put(waySegment.way, arrayList3);
                    }
                    var12_22.add(waySegment.lowerIndex);
                }
                object2 = new HashSet<Pair<Node, Node>>();
                for (Map.Entry entry : hashMap.entrySet()) {
                    int n;
                    Way way = (Way)entry.getKey();
                    List list3 = (List)entry.getValue();
                    object = new Way(way);
                    DrawAction.pruneSuccsAndReverse(list3);
                    Iterator iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        n = (Integer)iterator.next();
                        object2.add(Pair.sort(new Pair<Node, Node>(way.nodes.get(n), way.nodes.get(n + 1))));
                    }
                    Iterator iterator2 = list3.iterator();
                    while (iterator2.hasNext()) {
                        n = (Integer)iterator2.next();
                        ((Way)object).addNode(n + 1, node);
                    }
                    linkedList.add(new ChangeCommand((OsmPrimitive)entry.getKey(), (OsmPrimitive)object));
                    arrayList2.add(entry.getKey());
                    arrayList.add(object);
                }
                DrawAction.adjustNode(object2, node);
            }
        }
        boolean bl2 = false;
        boolean bl3 = this.wayIsFinished;
        this.wayIsFinished = false;
        if (!this.shift && collection.size() > 0 && !bl3) {
            void var13_46;
            void var13_42;
            Way way;
            void var12_32;
            int n;
            void var11_16;
            object2 = null;
            Object var11_15 = null;
            for (OsmPrimitive osmPrimitive : collection) {
                if (osmPrimitive instanceof Node) {
                    if (object2 != null) {
                        this.tryAgain(mouseEvent);
                        return;
                    }
                    object2 = (Node)osmPrimitive;
                    continue;
                }
                if (!(osmPrimitive instanceof Way)) continue;
                if (var11_16 != null) {
                    this.tryAgain(mouseEvent);
                    return;
                }
                Way way2 = (Way)osmPrimitive;
            }
            if (object2 == null && var11_16 == null) {
                this.tryAgain(mouseEvent);
                return;
            }
            Object var12_28 = null;
            if (object2 == null) {
                if (!var11_16.isFirstLastNode(lastUsedNode)) {
                    this.tryAgain(mouseEvent);
                    return;
                }
                Node node2 = lastUsedNode;
            } else if (var11_16 == null) {
                HashSet<Pair<Node, Node>> hashSet = object2;
            } else {
                if (!var11_16.isFirstLastNode((Node)object2)) {
                    this.tryAgain(mouseEvent);
                    return;
                }
                HashSet<Pair<Node, Node>> hashSet = object2;
            }
            if (var11_16 != null && var11_16.nodes != null && ((n = var11_16.nodes.indexOf(var12_32)) != -1 && n >= 1 && node.equals(var11_16.nodes.get(n - 1)) || n < var11_16.nodes.size() - 1 && node.equals(var11_16.nodes.get(n + 1)))) {
                Main.ds.setSelected(node);
                lastUsedNode = node;
                return;
            }
            if (var12_32 == node) {
                lastUsedNode = null;
                this.wayIsFinished = true;
                Main.map.selectSelectTool(true);
                return;
            }
            Object object3 = this.alt ? null : (way = var11_16 != null ? var11_16 : DrawAction.getWayForNode((Node)var12_32));
            if (way != null) {
                int n2 = 0;
                for (Node node3 : way.nodes) {
                    if (!node3.equals(var12_32)) continue;
                    ++n2;
                }
                if (n2 > 1) {
                    Object var13_41 = null;
                }
            }
            if (var13_42 == null) {
                Way way3 = new Way();
                way3.addNode((Node)var12_32);
                linkedList.add(new AddCommand(way3));
            } else {
                int n3 = arrayList2.indexOf(var13_42);
                if (n3 != -1) {
                    Way way4 = (Way)arrayList.get(n3);
                } else {
                    object = new Way((Way)var13_42);
                    linkedList.add(new ChangeCommand((OsmPrimitive)var13_42, (OsmPrimitive)object));
                    Object object4 = object;
                }
            }
            if (var13_46.nodes.contains(node)) {
                this.wayIsFinished = true;
                collection.clear();
            }
            if (var13_46.nodes.get(var13_46.nodes.size() - 1) == var12_32) {
                var13_46.addNode(node);
            } else {
                var13_46.addNode(0, node);
            }
            bl2 = true;
            Main.ds.setSelected(new OsmPrimitive[]{var13_46});
        }
        if (!bl2) {
            if (!bl) {
                return;
            }
            if (arrayList.isEmpty()) {
                object2 = I18n.tr("Add node");
            } else {
                object2 = I18n.tr("Add node into way");
                for (Way way : arrayList) {
                    way.selected = false;
                }
            }
            Main.ds.setSelected(node);
        } else {
            object2 = !bl ? I18n.tr("Connect existing way to node") : (arrayList.isEmpty() ? I18n.tr("Add a new node to an existing way") : I18n.tr("Add node into way and connect"));
        }
        SequenceCommand sequenceCommand = new SequenceCommand((String)object2, linkedList);
        Main.main.undoRedo.add(sequenceCommand);
        if (!this.wayIsFinished) {
            lastUsedNode = node;
        }
        this.computeHelperLine();
        this.removeHighlighting();
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        this.ctrl = (mouseEvent.getModifiers() & 2) != 0;
        this.alt = (mouseEvent.getModifiers() & 8) != 0;
        this.shift = (mouseEvent.getModifiers() & 1) != 0;
        this.mousePos = mouseEvent.getPoint();
        this.addHighlighting();
        this.computeHelperLine();
    }

    private void computeHelperLine() {
        Object object2;
        if (this.mousePos == null) {
            this.currentMouseEastNorth = null;
            this.currentBaseNode = null;
            return;
        }
        double d = -1.0;
        double d2 = -1.0;
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        Node node = null;
        Way way = null;
        Node node2 = null;
        this.mouseOnExistingNode = null;
        this.mouseOnExistingWays = new HashSet<Way>();
        Main.map.statusLine.setAngle(-1.0);
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setDist(-1.0);
        if (!this.ctrl && this.mousePos != null) {
            node2 = Main.map.mapView.getNearestNode(this.mousePos);
        }
        if (!this.ctrl && node2 == null) {
            object2 = Main.map.mapView.getNearestWaySegments(this.mousePos);
            Iterator<WaySegment> object3 = object2.iterator();
            while (object3.hasNext()) {
                WaySegment waySegment = object3.next();
                this.mouseOnExistingWays.add(waySegment.way);
            }
        }
        if (node2 != null) {
            if (collection.isEmpty()) {
                return;
            }
            this.currentMouseEastNorth = node2.eastNorth;
            this.mouseOnExistingNode = node2;
        } else {
            this.currentMouseEastNorth = Main.map.mapView.getEastNorth(this.mousePos.x, this.mousePos.y);
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                if (node != null) {
                    return;
                }
                node = (Node)osmPrimitive;
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            if (way != null) {
                return;
            }
            way = (Way)osmPrimitive;
        }
        this.currentBaseNode = null;
        object2 = null;
        if (node == null) {
            if (way == null) {
                return;
            }
            if (lastUsedNode == way.nodes.get(0) || lastUsedNode == way.nodes.get(way.nodes.size() - 1)) {
                this.currentBaseNode = lastUsedNode;
                if (lastUsedNode == way.nodes.get(way.nodes.size() - 1) && way.nodes.size() > 1) {
                    object2 = way.nodes.get(way.nodes.size() - 2);
                }
            }
        } else if (way == null) {
            this.currentBaseNode = node;
        } else if (node == way.nodes.get(0) || node == way.nodes.get(way.nodes.size() - 1)) {
            this.currentBaseNode = node;
        }
        if (this.currentBaseNode == null || this.currentBaseNode == node2) {
            return;
        }
        LatLon latLon = Main.proj.eastNorth2latlon(this.currentMouseEastNorth);
        d = this.currentBaseNode.coor.greatCircleDistance(latLon);
        double d3 = Math.toDegrees(this.currentBaseNode.coor.heading(latLon));
        if (object2 != null && (d2 = d3 - Math.toDegrees(((Node)object2).coor.heading(this.currentBaseNode.coor))) < 0.0) {
            d2 += 360.0;
        }
        Main.map.statusLine.setAngle(d2);
        Main.map.statusLine.setHeading(d3);
        Main.map.statusLine.setDist(d);
        this.updateStatusLine();
        if (!(this.drawHelperLine && !this.wayIsFinished || this.drawTargetHighlight)) {
            return;
        }
        Main.map.mapView.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isDrawableLayer().booleanValue()) {
            return;
        }
        this.mousePos = mouseEvent.getPoint();
        Main.map.mapView.repaint();
    }

    public static Way getWayForNode(Node node) {
        Way way = null;
        for (Way way2 : Main.ds.ways) {
            if (way2.deleted || way2.incomplete || way2.nodes.size() < 1) continue;
            Node node2 = way2.nodes.get(0);
            Node node3 = way2.nodes.get(way2.nodes.size() - 1);
            if (node2 != node && node3 != node || node2 == node3) continue;
            if (way != null) {
                return null;
            }
            way = way2;
        }
        return way;
    }

    private static void pruneSuccsAndReverse(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            if (hashSet.contains(n - 1) || hashSet.contains(n + 1)) continue;
            hashSet.add(n);
        }
        list.clear();
        list.addAll(hashSet);
        Collections.sort(list);
        Collections.reverse(list);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> collection, Node node) {
        double d;
        EastNorth eastNorth;
        EastNorth eastNorth2;
        Pair<Node, Node> pair;
        switch (collection.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> iterator = collection.iterator();
                pair = iterator.next();
                eastNorth2 = ((Node)pair.a).eastNorth;
                eastNorth = ((Node)pair.b).eastNorth;
                pair = iterator.next();
                EastNorth eastNorth3 = ((Node)pair.a).eastNorth;
                EastNorth eastNorth4 = ((Node)pair.b).eastNorth;
                double d2 = DrawAction.det(eastNorth.east() - eastNorth2.east(), eastNorth.north() - eastNorth2.north(), eastNorth3.east() - eastNorth4.east(), eastNorth3.north() - eastNorth4.north());
                if (d2 == 0.0) {
                    return;
                }
                d = DrawAction.det(eastNorth.north() - eastNorth3.north(), eastNorth.east() - eastNorth3.east(), eastNorth4.north() - eastNorth3.north(), eastNorth4.east() - eastNorth3.east()) / d2;
                EastNorth eastNorth5 = new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north()));
                int n = Main.pref.getInteger("edit.snap-intersection-threshold", 10);
                if (!(Main.map.mapView.getPoint(node.eastNorth).distance(Main.map.mapView.getPoint(eastNorth5)) < (double)n)) break;
                node.eastNorth = eastNorth5;
                return;
            }
        }
        EastNorth eastNorth6 = node.eastNorth;
        pair = collection.iterator().next();
        eastNorth2 = ((Node)pair.a).eastNorth;
        eastNorth = ((Node)pair.b).eastNorth;
        double d3 = eastNorth6.distanceSq(eastNorth);
        double d4 = eastNorth6.distanceSq(eastNorth2);
        double d5 = eastNorth2.distanceSq(eastNorth);
        d = (d3 - d4 + d5) / (2.0 * d5);
        node.eastNorth = new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north()));
    }

    static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    @Override
    public void paint(Graphics graphics, MapView mapView) {
        if (!this.drawHelperLine && !this.drawTargetHighlight) {
            return;
        }
        if (Main.map.mapView == null) {
            return;
        }
        if (this.mousePos == null) {
            return;
        }
        if (this.shift) {
            return;
        }
        if (this.currentBaseNode == null || this.currentMouseEastNorth == null) {
            return;
        }
        if (!Main.map.mapView.getBounds().contains(this.mousePos)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.selectedColor);
        graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
        GeneralPath generalPath = new GeneralPath();
        Point point = mapView.getPoint(this.currentBaseNode.eastNorth);
        Point point2 = mapView.getPoint(this.currentMouseEastNorth);
        double d = Math.atan2(point2.y - point.y, point2.x - point.x) + Math.PI;
        generalPath.moveTo(point.x, point.y);
        generalPath.lineTo(point2.x, point2.y);
        if (this.alt) {
            generalPath.moveTo((int)((double)point.x + 8.0 * Math.cos(d + this.PHI)), (int)((double)point.y + 8.0 * Math.sin(d + this.PHI)));
            generalPath.lineTo((int)((double)point.x + 8.0 * Math.cos(d - this.PHI)), (int)((double)point.y + 8.0 * Math.sin(d - this.PHI)));
        }
        graphics2D.draw(generalPath);
        graphics2D.setStroke(new BasicStroke(1.0f));
    }

    @Override
    public String getModeHelpText() {
        String string = this.currentBaseNode != null && !this.shift ? (this.mouseOnExistingNode != null ? (this.alt ? I18n.tr("Click to create a new way to the existing node.") : I18n.tr("Click to make a connection to the existing node.")) : (this.alt ? I18n.tr("Click to insert a node and create a new way.") : I18n.tr("Click to insert a new node and make a connection."))) : I18n.tr("Click to insert a new node.");
        return string.toString();
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }
}

