/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.actions.search.SelectionWebsiteLoader;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SearchAction
extends JosmAction {
    public static final int SEARCH_HISTORY_SIZE = 10;
    public static final LinkedList<SearchSetting> searchHistory = new LinkedList();
    private static SearchSetting lastSearch = null;

    public SearchAction() {
        super(I18n.tr("Search..."), "dialogs/search", I18n.tr("Search for objects."), Shortcut.registerShortcut("system:find", I18n.tr("Search..."), 70, 1), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No data loaded."));
            return;
        }
        SearchSetting searchSetting = lastSearch;
        if (searchSetting == null) {
            searchSetting = new SearchSetting("", false, false, SearchMode.replace);
        }
        this.showSearchDialog(searchSetting);
    }

    public void showSearchDialog(SearchSetting searchSetting) {
        JLabel jLabel = new JLabel(I18n.tr("Please enter a search string."));
        JTextField jTextField = new JTextField(searchSetting.text);
        jTextField.selectAll();
        jTextField.requestFocusInWindow();
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("replace selection"), searchSetting.mode == SearchMode.replace);
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("add to selection"), searchSetting.mode == SearchMode.add);
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("remove from selection"), searchSetting.mode == SearchMode.remove);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("case sensitive"), searchSetting.caseSensitive);
        JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("regular expression"), searchSetting.regexSearch);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, GBC.eop());
        jPanel.add((Component)jTextField, GBC.eop().fill(2));
        jPanel.add((Component)jRadioButton, GBC.eol());
        jPanel.add((Component)jRadioButton2, GBC.eol());
        jPanel.add((Component)jRadioButton3, GBC.eop());
        jPanel.add((Component)jCheckBox, GBC.eol());
        jPanel.add((Component)jCheckBox2, GBC.eol());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("<html><ul><li>" + I18n.tr("<b>Baker Street</b> - 'Baker' and 'Street' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>\"Baker Street\"</b> - 'Baker Street' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>name:Bak</b> - 'Bak' anywhere in the name.") + "</li>" + "<li>" + I18n.tr("<b>-name:Bak</b> - not 'Bak' in the name.") + "</li>" + "<li>" + I18n.tr("<b>foot:</b> - key=foot set to any value.") + "</li>" + "<li>" + I18n.tr("<u>Special targets:</u>") + "</li>" + "<li>" + I18n.tr("<b>type:</b> - type of the object (<b>node</b>, <b>way</b>, <b>relation</b>)") + "</li>" + "<li>" + I18n.tr("<b>user:</b>... - all objects changed by user") + "</li>" + "<li>" + I18n.tr("<b>id:</b>... - object with given ID") + "</li>" + "<li>" + I18n.tr("<b>nodes:</b>... - object with given number of nodes") + "</li>" + "<li>" + I18n.tr("<b>modified</b> - all changed objects") + "</li>" + "<li>" + I18n.tr("<b>selected</b> - all selected objects") + "</li>" + "<li>" + I18n.tr("<b>incomplete</b> - all incomplete objects") + "</li>" + "<li>" + I18n.tr("<b>untagged</b> - all untagged objects") + "</li>" + "<li>" + I18n.tr("Use <b>|</b> or <b>OR</b> to combine with logical or") + "</li>" + "<li>" + I18n.tr("Use <b>\"</b> to quote operators (e.g. if key contains :)") + "</li>" + "<li>" + I18n.tr("Use <b>(</b> and <b>)</b> to group expressions") + "</li>" + "</ul></html>"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        int n = new ExtendedDialog(Main.parent, I18n.tr("Search"), jPanel3, new String[]{I18n.tr("Start Search"), I18n.tr("Cancel")}, new String[]{"dialogs/search.png", "cancel.png"}).getValue();
        if (n != 1) {
            return;
        }
        SearchMode searchMode = jRadioButton.isSelected() ? SearchMode.replace : (jRadioButton2.isSelected() ? SearchMode.add : SearchMode.remove);
        SearchSetting searchSetting2 = new SearchSetting(jTextField.getText(), jCheckBox.isSelected(), jCheckBox2.isSelected(), searchMode);
        SearchAction.searchWithHistory(searchSetting2);
    }

    public static void searchWithHistory(SearchSetting searchSetting) {
        searchHistory.addFirst(searchSetting);
        while (searchHistory.size() > 10) {
            searchHistory.removeLast();
        }
        lastSearch = searchSetting;
        SearchAction.search(searchSetting.text, searchSetting.mode, searchSetting.caseSensitive, searchSetting.regexSearch);
    }

    public static void searchWithoutHistory(SearchSetting searchSetting) {
        lastSearch = searchSetting;
        SearchAction.search(searchSetting.text, searchSetting.mode, searchSetting.caseSensitive, searchSetting.regexSearch);
    }

    public static void search(String string, SearchMode searchMode, boolean bl, boolean bl2) {
        Object object;
        if (string.startsWith("http://") || string.startsWith("ftp://") || string.startsWith("https://") || string.startsWith("file:/")) {
            object = new SelectionWebsiteLoader(string, searchMode);
            if (((SelectionWebsiteLoader)object).url != null) {
                Main.worker.execute((Runnable)object);
                return;
            }
        }
        try {
            object = Main.ds.getSelected();
            SearchCompiler.Match match = SearchCompiler.compile(string, bl, bl2);
            int n = 0;
            for (OsmPrimitive osmPrimitive : Main.ds.allNonDeletedCompletePrimitives()) {
                if (searchMode == SearchMode.replace) {
                    if (match.match(osmPrimitive)) {
                        object.add(osmPrimitive);
                        ++n;
                        continue;
                    }
                    object.remove(osmPrimitive);
                    continue;
                }
                if (searchMode == SearchMode.add && !osmPrimitive.selected && match.match(osmPrimitive)) {
                    object.add(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchMode != SearchMode.remove || !osmPrimitive.selected || !match.match(osmPrimitive)) continue;
                object.remove(osmPrimitive);
                ++n;
            }
            Main.ds.setSelected((Collection<? extends OsmPrimitive>)object);
            if (n == 0) {
                Object object2 = null;
                if (searchMode == SearchMode.replace) {
                    object2 = I18n.tr("No match found for ''{0}''", string);
                } else if (searchMode == SearchMode.add) {
                    object2 = I18n.tr("Nothing added to selection by searching for ''{0}''", string);
                } else if (searchMode == SearchMode.remove) {
                    object2 = I18n.tr("Nothing removed from selection by searching for ''{0}''", string);
                }
                Main.map.statusLine.setHelpText((String)object2);
                JOptionPane.showMessageDialog(Main.parent, object2);
            } else {
                Main.map.statusLine.setHelpText(I18n.tr("Found {0} matches", n));
            }
        }
        catch (SearchCompiler.ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, parseError.getMessage());
        }
    }

    public static class SearchSetting {
        String text;
        SearchMode mode;
        boolean caseSensitive;
        boolean regexSearch;

        public SearchSetting(String string, boolean bl, boolean bl2, SearchMode searchMode) {
            this.caseSensitive = bl;
            this.regexSearch = bl2;
            this.mode = searchMode;
            this.text = string;
        }

        public String toString() {
            String string = this.caseSensitive ? I18n.tr("CI") : I18n.tr("CS");
            String string2 = this.regexSearch ? ", " + I18n.tr("RX") : "";
            return "\"" + this.text + "\" (" + string + string2 + ", " + (Object)((Object)this.mode) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchMode {
        replace,
        add,
        remove;

    }
}

