/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.ConflictItem;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ConflictResolver;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictResolveCommand
extends Command {
    private final Collection<ConflictItem> conflicts;
    private final Map<OsmPrimitive, OsmPrimitive> resolved;
    private Map<OsmPrimitive, OsmPrimitive> origAllConflicts;
    private final ConflictDialog conflictDialog;

    public ConflictResolveCommand(List<ConflictItem> list, Map<OsmPrimitive, OsmPrimitive> map) {
        this.conflicts = list;
        this.resolved = map;
        this.conflictDialog = Main.map.conflictDialog;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.origAllConflicts = new HashMap<OsmPrimitive, OsmPrimitive>(this.conflictDialog.conflicts);
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(this.resolved.keySet());
        for (ConflictItem object : this.conflicts) {
            for (Map.Entry<OsmPrimitive, OsmPrimitive> entry : this.resolved.entrySet()) {
                if (object.resolution == ConflictResolver.Resolution.THEIR) {
                    object.apply(entry.getKey(), entry.getValue());
                    continue;
                }
                if (object.resolution == ConflictResolver.Resolution.MY) {
                    object.apply(entry.getValue(), entry.getKey());
                    continue;
                }
                if (!object.hasConflict(entry.getKey(), entry.getValue())) continue;
                hashSet.remove(entry.getKey());
            }
        }
        if (!hashSet.isEmpty()) {
            for (OsmPrimitive osmPrimitive : hashSet) {
                this.conflictDialog.conflicts.remove(osmPrimitive);
            }
            this.conflictDialog.rebuildList();
        }
        return true;
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        Main.map.conflictDialog.conflicts.clear();
        Main.map.conflictDialog.conflicts.putAll(this.origAllConflicts);
        Main.map.conflictDialog.rebuildList();
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.resolved.keySet());
    }

    @Override
    public MutableTreeNode description() {
        int n = 0;
        for (ConflictItem conflictItem : this.conflicts) {
            if (conflictItem.resolution == null) continue;
            ++n;
        }
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve {0} conflicts in {1} objects", n, this.resolved.size()), ImageProvider.get("data", "object"), 0));
    }
}

