/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateCommand
extends Command {
    public Collection<Node> objects = new LinkedList<Node>();
    private Node pivot;
    private double startAngle;
    private double rotationAngle;
    private Map<Node, MoveCommand.OldState> oldState = new HashMap<Node, MoveCommand.OldState>();

    public RotateCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth, EastNorth eastNorth2) {
        this.objects = AllNodesVisitor.getAllNodes(collection);
        this.pivot = new Node(new LatLon(0.0, 0.0));
        this.pivot.eastNorth = new EastNorth(0.0, 0.0);
        for (Node node : this.objects) {
            MoveCommand.OldState oldState = new MoveCommand.OldState();
            oldState.eastNorth = node.eastNorth;
            oldState.latlon = node.coor;
            oldState.modified = node.modified;
            this.oldState.put(node, oldState);
            this.pivot.eastNorth = new EastNorth(this.pivot.eastNorth.east() + oldState.eastNorth.east(), this.pivot.eastNorth.north() + oldState.eastNorth.north());
        }
        this.pivot.eastNorth = new EastNorth(this.pivot.eastNorth.east() / (double)this.objects.size(), this.pivot.eastNorth.north() / (double)this.objects.size());
        this.pivot.coor = Main.proj.eastNorth2latlon(this.pivot.eastNorth);
        this.rotationAngle = 1.5707963267948966;
        this.rotateAgain(eastNorth, eastNorth2);
    }

    public void rotateAgain(EastNorth eastNorth, EastNorth eastNorth2) {
        this.startAngle = Math.atan2(eastNorth.east() - this.pivot.eastNorth.east(), eastNorth.north() - this.pivot.eastNorth.north());
        double d = Math.atan2(eastNorth2.east() - this.pivot.eastNorth.east(), eastNorth2.north() - this.pivot.eastNorth.north());
        this.rotationAngle += this.startAngle - d;
        this.rotateNodes(false);
    }

    private void rotateNodes(boolean bl) {
        for (Node node : this.objects) {
            double d = Math.cos(this.rotationAngle);
            double d2 = Math.sin(this.rotationAngle);
            EastNorth eastNorth = this.oldState.get((Object)node).eastNorth;
            double d3 = eastNorth.east() - this.pivot.eastNorth.east();
            double d4 = eastNorth.north() - this.pivot.eastNorth.north();
            double d5 = d2 * d3 + d * d4 + this.pivot.eastNorth.east();
            double d6 = -d * d3 + d2 * d4 + this.pivot.eastNorth.north();
            node.eastNorth = new EastNorth(d5, d6);
            node.coor = Main.proj.eastNorth2latlon(node.eastNorth);
            if (!bl) continue;
            node.modified = true;
        }
    }

    @Override
    public boolean executeCommand() {
        this.rotateNodes(true);
        return true;
    }

    @Override
    public void undoCommand() {
        for (Node node : this.objects) {
            MoveCommand.OldState oldState = this.oldState.get(node);
            node.eastNorth = oldState.eastNorth;
            node.coor = oldState.latlon;
            node.modified = oldState.modified;
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        for (Node node : this.objects) {
            collection.add(node);
        }
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Rotate") + " " + this.objects.size() + " " + I18n.trn("node", "nodes", this.objects.size()), ImageProvider.get("data", "node"), 0));
    }
}

