/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;

public final class Node
extends OsmPrimitive {
    public LatLon coor;
    public volatile EastNorth eastNorth;
    private static LatLon.CoordinateFormat mCord;

    public Node(long l) {
        this.id = l;
        this.incomplete = true;
    }

    public Node(Node node) {
        this.cloneFrom(node);
    }

    public Node(LatLon latLon) {
        this.coor = latLon;
        this.eastNorth = Main.proj.latlon2eastNorth(latLon);
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.coor = ((Node)osmPrimitive).coor;
        this.eastNorth = ((Node)osmPrimitive).eastNorth;
    }

    public String toString() {
        if (this.coor == null) {
            return "{Node id=" + this.id + "}";
        }
        return "{Node id=" + this.id + ",version=" + this.version + ",lat=" + this.coor.lat() + ",lon=" + this.coor.lon() + "}";
    }

    public boolean realEqual(OsmPrimitive osmPrimitive, boolean bl) {
        if (osmPrimitive instanceof Node && super.realEqual(osmPrimitive, bl)) {
            if (this.coor == null && ((Node)osmPrimitive).coor == null) {
                return true;
            }
            if (this.coor != null) {
                return this.coor.equals(((Node)osmPrimitive).coor);
            }
        }
        return false;
    }

    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Node ? Long.valueOf(this.id).compareTo(osmPrimitive.id) : 1;
    }

    public String getName() {
        String string;
        if (this.incomplete) {
            string = I18n.tr("incomplete");
        } else {
            string = this.get("name");
            if (string == null) {
                string = this.id == 0L ? I18n.tr("node") : "" + this.id;
            }
            string = string + " (" + this.coor.latToString(mCord) + ", " + this.coor.lonToString(mCord) + ")";
        }
        return string;
    }

    static {
        try {
            mCord = LatLon.CoordinateFormat.valueOf(Main.pref.get("coordinates"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            mCord = LatLon.CoordinateFormat.DECIMAL_DEGREES;
        }
    }
}

