/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.I18n;

public final class Relation
extends OsmPrimitive {
    public final List<RelationMember> members = new ArrayList<RelationMember>();

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public Relation(Relation relation) {
        this.cloneFrom(relation);
    }

    public Relation(long l) {
        this.id = l;
        this.incomplete = true;
    }

    public Relation() {
    }

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        super.cloneFrom(osmPrimitive);
        this.members.clear();
        for (RelationMember relationMember : ((Relation)osmPrimitive).members) {
            this.members.add(new RelationMember(relationMember));
        }
    }

    public String toString() {
        return "{Relation id=" + this.id + " version=" + this.version + "}";
    }

    public boolean realEqual(OsmPrimitive osmPrimitive, boolean bl) {
        return osmPrimitive instanceof Relation ? super.realEqual(osmPrimitive, bl) && ((Object)this.members).equals(((Relation)osmPrimitive).members) : false;
    }

    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Relation ? Long.valueOf(this.id).compareTo(osmPrimitive.id) : -1;
    }

    public String getName() {
        String string;
        if (this.incomplete) {
            string = I18n.tr("incomplete");
        } else {
            string = this.get("type");
            if (string == null) {
                string = I18n.tr("relation");
            }
            string = string + " (";
            String string2 = this.get("name");
            if (string2 == null) {
                string2 = this.get("ref");
            }
            if (string2 == null) {
                string2 = this.get("note");
            }
            if (string2 != null) {
                string = string + "\"" + string2 + "\", ";
            }
            int n = this.members.size();
            string = string + I18n.trn("{0} member", "{0} members", n, n) + ")";
            if (this.errors != null) {
                string = "*" + string;
            }
        }
        return string;
    }

    public boolean isIncomplete() {
        for (RelationMember relationMember : this.members) {
            if (relationMember.member != null) continue;
            return true;
        }
        return false;
    }
}

