/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.gui.FileDrop;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WikiReader;

public class GettingStarted
extends JPanel {
    private static String content = "";
    private static String styles = "<style type=\"text/css\">\nbody { font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center;}\n</style>\n";

    private void assignContent() {
        int n;
        if (content.length() > 0 && Main.pref.getBoolean("help.displaymotd", true)) {
            return;
        }
        String string = Main.pref.get("help.baseurl", "http://josm.openstreetmap.de");
        WikiReader wikiReader = new WikiReader(string);
        String string2 = "";
        try {
            string2 = wikiReader.read(string + "/wiki/MessageOfTheDay?format=txt");
        }
        catch (IOException iOException) {
            string2 = "<html>" + styles + "<body><h1>" + "JOSM - " + I18n.tr("Java OpenStreetMap Editor") + "</h1>\n<h2 align=\"center\">(" + I18n.tr("Message of the day not available") + ")</h2>";
        }
        int n2 = AboutAction.getVersionNumber();
        String string3 = Main.getLanguageCodeU();
        Pattern pattern = Pattern.compile("\\[wiki:(?:[A-Z]+:)?MessageOfTheDay(\\>\\=|\\<\\=|\\<|\\>)([0-9]+)\\s*([A-Z]*)\\]", 2);
        Matcher matcher = pattern.matcher(string2);
        matcher.reset();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string4 = "";
        while (matcher.find()) {
            if (!(matcher.group(3) + ":").equals(string3) && !matcher.group(3).equals("")) continue;
            arrayList.add(new String[]{matcher.group(1), matcher.group(2), matcher.group(3)});
            string4 = string4 + matcher.group(1) + matcher.group(2) + matcher.group(3) + ": ";
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        ArrayList<Future<String>> arrayList2 = new ArrayList<Future<String>>();
        for (n = 0; n < arrayList.size(); ++n) {
            String[] stringArray = (String[])arrayList.get(n);
            int n3 = Integer.parseInt(stringArray[1]);
            String string5 = stringArray[0];
            Boolean bl = !stringArray[2].equals("");
            if (!bl.booleanValue() && string4.indexOf(string5 + stringArray[1] + string3 + " ") >= 0) continue;
            boolean bl2 = false;
            if (n2 == 0) {
                bl2 = true;
            } else if (string5.equals(">=")) {
                bl2 = n2 >= n3;
            } else if (string5.equals(">")) {
                bl2 = n2 > n3;
            } else if (string5.equals("<")) {
                bl2 = n2 < n3;
            } else {
                boolean bl3 = bl2 = n2 <= n3;
            }
            if (!bl2) continue;
            boolean bl4 = n3 == 1;
            String string6 = string + "/wiki/";
            String string7 = "MessageOfTheDay" + string5 + n3 + (bl4 ? "" : "?format=txt");
            String string8 = string6 + string3 + string7;
            String string9 = string6 + string7;
            arrayList2.add(executorService.submit(new readMOTD(bl, string, string8, string9, bl4)));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            try {
                content = content + (String)((Future)arrayList2.get(n)).get();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        arrayList2.clear();
        try {
            executorService.shutdown();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        content = "<html>\n" + styles + "<h1>JOSM - " + I18n.tr("Java OpenStreetMap Editor") + "</h1>\n" + content + "\n" + "</html>";
    }

    public GettingStarted() {
        super(new BorderLayout());
        final LinkGeneral linkGeneral = new LinkGeneral("<html>" + styles + "<h1>" + "JOSM - " + I18n.tr("Java OpenStreetMap Editor") + "</h1><h2 align=\"center\">" + I18n.tr("Downloading \"Message of the day\"") + "</h2>");
        JScrollPane jScrollPane = new JScrollPane(linkGeneral);
        jScrollPane.setViewportBorder(new EmptyBorder(10, 100, 10, 100));
        this.add((Component)jScrollPane, "Center");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                GettingStarted.this.assignContent();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        linkGeneral.setText(content);
                    }
                });
            }
        }, "MOTD-Loader");
        thread.setDaemon(true);
        thread.start();
        new FileDrop(jScrollPane);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class readMOTD
    implements Callable<String> {
        private boolean isLocalized;
        private boolean isHelp;
        private String urlLoc;
        private String urlIntl;
        private String urlBase;

        readMOTD(boolean bl, String string, String string2, String string3, boolean bl2) {
            this.isLocalized = bl;
            this.urlBase = string;
            this.urlLoc = string2;
            this.urlIntl = string3;
            this.isHelp = bl2;
        }

        @Override
        public String call() {
            WikiReader wikiReader = new WikiReader(this.urlBase);
            String string = "";
            try {
                String string2;
                String string3 = string2 = this.isLocalized ? wikiReader.read(this.urlLoc) : "";
                if (string2.equals("")) {
                    string2 = wikiReader.read(this.urlIntl);
                }
                if (!string2.equals("")) {
                    string = this.isHelp ? string + string2 : string + "<ul><li>" + string2.substring(8).replaceAll("\n *\\* +", "</li><li>") + "</li></ul>";
                }
            }
            catch (IOException iOException) {
                try {
                    string = this.isHelp ? string + wikiReader.read(this.urlIntl) : string + "<ul><li>" + wikiReader.read(this.urlIntl).substring(8).replaceAll("\n *\\* +", "</li><li>") + "</li></ul>";
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            return string;
        }
    }

    public class LinkGeneral
    extends JEditorPane
    implements HyperlinkListener {
        public LinkGeneral(String string) {
            this.setContentType("text/html");
            this.setText(string);
            this.setEditable(false);
            this.setOpaque(false);
            this.addHyperlinkListener(this);
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.displayUrl(hyperlinkEvent.getDescription());
            }
        }
    }
}

