/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.MapPaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmDataLayer
extends Layer {
    public final DataSet data;
    private boolean modified = false;
    public boolean uploadedModified = false;
    public final LinkedList<ModifiedChangedListener> listenerModified = new LinkedList();
    public final LinkedList<DataChangeListener> listenerDataChanged = new LinkedList();
    private static TexturePaint hatched;

    public static void createHatchTexture() {
        BufferedImage bufferedImage = new BufferedImage(15, 15, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Main.pref.getColor(I18n.marktr("background"), Color.BLACK));
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.3f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.fillRect(0, 0, 15, 15);
        graphics2D.setColor(Main.pref.getColor(I18n.marktr("outside downloaded area"), Color.YELLOW));
        graphics2D.drawLine(0, 15, 15, 0);
        Rectangle rectangle = new Rectangle(0, 0, 15, 15);
        hatched = new TexturePaint(bufferedImage, rectangle);
    }

    public OsmDataLayer(DataSet dataSet, String string, File file) {
        super(string);
        this.data = dataSet;
        this.associatedFile = file;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "osmdata_small");
    }

    @Override
    public void paint(Graphics graphics, MapView mapView) {
        Object object;
        boolean bl;
        boolean bl2 = Main.map.mapView.getActiveLayer() == this;
        boolean bl3 = !bl2 && Main.pref.getBoolean("draw.data.inactive_color", true);
        boolean bl4 = bl = !bl3 && Main.map.mapView.useVirtualNodes() != false;
        if (bl2 && Main.pref.getBoolean("draw.data.downloaded_area", true) && !this.data.dataSources.isEmpty()) {
            object = Main.map.mapView.getBounds();
            ((Rectangle)object).grow(100, 100);
            Area area = new Area((Shape)object);
            for (DataSource dataSource : this.data.dataSources) {
                if (dataSource.bounds == null || dataSource.bounds.min.equals(dataSource.bounds.max)) continue;
                EastNorth eastNorth = Main.proj.latlon2eastNorth(dataSource.bounds.min);
                EastNorth eastNorth2 = Main.proj.latlon2eastNorth(dataSource.bounds.max);
                Point point = mapView.getPoint(eastNorth);
                Point point2 = mapView.getPoint(eastNorth2);
                Rectangle rectangle = new Rectangle(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point2.x - point.x), Math.abs(point2.y - point.y));
                area.subtract(new Area(rectangle));
            }
            ((Graphics2D)graphics).setPaint(hatched);
            ((Graphics2D)graphics).fill(area);
        }
        object = Main.pref.getBoolean("draw.wireframe") ? new SimplePaintVisitor() : new MapPaintVisitor();
        ((SimplePaintVisitor)object).setGraphics(graphics);
        ((SimplePaintVisitor)object).setNavigatableComponent(mapView);
        ((SimplePaintVisitor)object).inactive = bl3;
        ((SimplePaintVisitor)object).visitAll(this.data, bl);
        Main.map.conflictDialog.paintConflicts(graphics, mapView);
    }

    @Override
    public String getToolTipText() {
        String string = "";
        string = string + this.undeletedSize(this.data.nodes) + " " + I18n.trn("node", "nodes", this.undeletedSize(this.data.nodes)) + ", ";
        string = string + this.undeletedSize(this.data.ways) + " " + I18n.trn("way", "ways", this.undeletedSize(this.data.ways));
        if (this.associatedFile != null) {
            string = "<html>" + string + "<br>" + this.associatedFile.getPath() + "</html>";
        }
        return string;
    }

    @Override
    public void mergeFrom(Layer layer) {
        MergeVisitor mergeVisitor = new MergeVisitor(this.data, ((OsmDataLayer)layer).data);
        for (OsmPrimitive object : ((OsmDataLayer)layer).data.allPrimitives()) {
            object.visit(mergeVisitor);
        }
        mergeVisitor.fixReferences();
        for (DataSource dataSource : ((OsmDataLayer)layer).data.dataSources) {
            this.data.dataSources.add(dataSource);
        }
        this.fireDataChange();
        Main.map.mapView.repaint();
        if (mergeVisitor.conflicts.isEmpty()) {
            return;
        }
        ConflictDialog conflictDialog = Main.map.conflictDialog;
        conflictDialog.add(mergeVisitor.conflicts);
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were conflicts during import."));
        if (!conflictDialog.isVisible()) {
            conflictDialog.action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Node node : this.data.nodes) {
            if (node.deleted || node.incomplete) continue;
            boundingXYVisitor.visit(node);
        }
    }

    public void cleanData(Collection<OsmPrimitive> collection, boolean bl) {
        if (collection != null && collection.isEmpty() && !bl) {
            return;
        }
        Main.main.undoRedo.clean();
        if (collection != null) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
            Iterator<OsmPrimitive> iterator = this.data.nodes.iterator();
            while (iterator.hasNext()) {
                this.cleanIterator(iterator, hashSet);
            }
            iterator = this.data.ways.iterator();
            while (iterator.hasNext()) {
                this.cleanIterator(iterator, hashSet);
            }
            iterator = this.data.relations.iterator();
            while (iterator.hasNext()) {
                this.cleanIterator(iterator, hashSet);
            }
        }
        if (this.associatedFile != null && collection != null && !bl) {
            return;
        }
        this.uploadedModified = this.associatedFile != null && collection != null && bl;
        this.setModified(this.uploadedModified);
    }

    private void cleanIterator(Iterator<? extends OsmPrimitive> iterator, Collection<OsmPrimitive> collection) {
        OsmPrimitive osmPrimitive = iterator.next();
        if (!collection.remove(osmPrimitive)) {
            return;
        }
        osmPrimitive.modified = false;
        if (osmPrimitive.deleted) {
            iterator.remove();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        if (bl == this.modified) {
            return;
        }
        this.modified = bl;
        for (ModifiedChangedListener modifiedChangedListener : this.listenerModified) {
            modifiedChangedListener.modifiedChanged(bl, this);
        }
    }

    private int undeletedSize(Collection<? extends OsmPrimitive> collection) {
        int n = 0;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.deleted) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Object getInfoComponent() {
        DataCountVisitor dataCountVisitor = new DataCountVisitor();
        for (OsmPrimitive osmPrimitive : this.data.allPrimitives()) {
            osmPrimitive.visit(dataCountVisitor);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("{0} consists of:", this.name)), GBC.eol());
        for (int i = 0; i < dataCountVisitor.normal.length; ++i) {
            String string = dataCountVisitor.normal[i] + " " + I18n.trn(dataCountVisitor.names[i], dataCountVisitor.names[i] + "s", dataCountVisitor.normal[i]);
            if (dataCountVisitor.deleted[i] > 0) {
                string = string + I18n.tr(" ({0} deleted.)", dataCountVisitor.deleted[i]);
            }
            jPanel.add((Component)new JLabel(string, ImageProvider.get("data", dataCountVisitor.names[i]), 0), GBC.eop().insets(15, 0, 0, 0));
        }
        return jPanel;
    }

    @Override
    public Component[] getMenuEntries() {
        if (Main.applet) {
            return new Component[]{new JMenuItem(new LayerListDialog.ShowHideLayerAction(this)), new JMenuItem(new LayerListDialog.DeleteLayerAction(this)), new JSeparator(), new JMenuItem(new RenameLayerAction(this.associatedFile, this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
        }
        return new Component[]{new JMenuItem(new LayerListDialog.ShowHideLayerAction(this)), new JMenuItem(new LayerListDialog.DeleteLayerAction(this)), new JSeparator(), new JMenuItem(new SaveAction(this)), new JMenuItem(new SaveAsAction(this)), new JMenuItem(new GpxExportAction(this)), new JMenuItem(new ConvertToGpxLayerAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.associatedFile, this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    public void fireDataChange() {
        for (DataChangeListener dataChangeListener : this.listenerDataChanged) {
            dataChangeListener.dataChanged(this);
        }
    }

    public static GpxData toGpxData(DataSet dataSet) {
        WithAttributes withAttributes;
        GpxData gpxData = new GpxData();
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Way osmPrimitive : dataSet.ways) {
            if (osmPrimitive.incomplete || osmPrimitive.deleted) continue;
            withAttributes = new GpxTrack();
            gpxData.tracks.add((GpxTrack)withAttributes);
            if (osmPrimitive.get("name") != null) {
                ((GpxTrack)withAttributes).attr.put("name", osmPrimitive.get("name"));
            }
            ArrayList<WayPoint> arrayList = null;
            for (Node node : osmPrimitive.nodes) {
                if (node.incomplete || node.deleted) {
                    arrayList = null;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<WayPoint>();
                    ((GpxTrack)withAttributes).trackSegs.add(arrayList);
                }
                if (!node.tagged) {
                    hashSet.add(node);
                }
                WayPoint wayPoint = new WayPoint(node.coor);
                if (node.timestamp != null) {
                    wayPoint.attr.put("time", node.timestamp);
                    wayPoint.setTime();
                }
                arrayList.add(wayPoint);
            }
        }
        for (Node node : dataSet.nodes) {
            if (node.incomplete || node.deleted || hashSet.contains(node)) continue;
            withAttributes = new WayPoint(node.coor);
            if (node.timestamp != null) {
                ((WayPoint)withAttributes).attr.put("time", node.timestamp);
                ((WayPoint)withAttributes).setTime();
            }
            if (node.keys == null || !node.keys.containsKey("name")) continue;
            ((WayPoint)withAttributes).attr.put("name", node.keys.get("name"));
        }
        return gpxData;
    }

    public GpxData toGpxData() {
        return OsmDataLayer.toGpxData(this.data);
    }

    public boolean containsPoint(LatLon latLon) {
        if (this.data.dataSources.isEmpty()) {
            return true;
        }
        boolean bl = false;
        for (DataSource dataSource : this.data.dataSources) {
            if (!dataSource.bounds.contains(latLon)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static {
        OsmDataLayer.createHatchTexture();
    }

    public class ConvertToGpxLayerAction
    extends AbstractAction {
        public ConvertToGpxLayerAction() {
            super(I18n.tr("Convert to GPX layer"), ImageProvider.get("converttogpx"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.main.addLayer(new GpxLayer(OsmDataLayer.this.toGpxData(), I18n.tr("Converted from: {0}", OsmDataLayer.this.name)));
            Main.main.removeLayer(OsmDataLayer.this);
        }
    }

    public static interface CommandQueueListener {
        public void commandChanged(int var1, int var2);
    }

    public static interface ModifiedChangedListener {
        public void modifiedChanged(boolean var1, OsmDataLayer var2);
    }

    public static final class DataCountVisitor
    implements Visitor {
        public final int[] normal = new int[3];
        public final int[] deleted = new int[3];
        public final String[] names = new String[]{"node", "way", "relation"};

        private void inc(OsmPrimitive osmPrimitive, int n) {
            int n2 = n;
            this.normal[n2] = this.normal[n2] + 1;
            if (osmPrimitive.deleted) {
                int n3 = n;
                this.deleted[n3] = this.deleted[n3] + 1;
            }
        }

        public void visit(Node node) {
            this.inc(node, 0);
        }

        public void visit(Way way) {
            this.inc(way, 1);
        }

        public void visit(Relation relation) {
            this.inc(relation, 2);
        }
    }
}

