/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.DontShowAgainInfo;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawGpsLayer
extends Layer
implements Preferences.PreferenceChangedListener {
    public final Collection<Collection<GpsPoint>> data;
    public final boolean fromServer;

    public RawGpsLayer(boolean bl, Collection<Collection<GpsPoint>> collection, String string, File file) {
        super(string);
        this.fromServer = bl;
        this.associatedFile = file;
        this.data = collection;
        Main.pref.listener.add(this);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "rawgps_small");
    }

    @Override
    public void paint(Graphics graphics, MapView mapView) {
        graphics.setColor(Main.pref.getColor(I18n.marktr("gps point"), "layer " + this.name, Color.gray));
        Point point = null;
        boolean bl = Main.pref.getBoolean("draw.rawgps.lines.force");
        boolean bl2 = Main.pref.getBoolean("draw.rawgps.lines");
        String string = "draw.rawgps.lines.layer " + this.name;
        if (Main.pref.hasKey(string)) {
            bl2 = Main.pref.getBoolean(string);
        }
        boolean bl3 = Main.pref.getBoolean("draw.rawgps.large");
        for (Collection<GpsPoint> collection : this.data) {
            if (!bl) {
                point = null;
            }
            for (GpsPoint gpsPoint : collection) {
                Point point2 = mapView.getPoint(gpsPoint.eastNorth);
                if (bl2 && point != null) {
                    graphics.drawLine(point.x, point.y, point2.x, point2.y);
                } else if (!bl3) {
                    graphics.drawRect(point2.x, point2.y, 0, 0);
                }
                if (bl3) {
                    graphics.fillRect(point2.x - 1, point2.y - 1, 3, 3);
                }
                point = point2;
            }
        }
    }

    @Override
    public String getToolTipText() {
        int n = 0;
        for (Collection<GpsPoint> collection : this.data) {
            n += collection.size();
        }
        Object object = this.data.size() + " " + I18n.trn("track", "tracks", this.data.size()) + " " + n + " " + I18n.trn("point", "points", n);
        if (this.associatedFile != null) {
            object = "<html>" + (String)object + "<br>" + this.associatedFile.getPath() + "</html>";
        }
        return object;
    }

    @Override
    public void mergeFrom(Layer layer) {
        RawGpsLayer rawGpsLayer = (RawGpsLayer)layer;
        this.data.addAll(rawGpsLayer.data);
    }

    @Override
    public boolean isMergable(Layer layer) {
        return layer instanceof RawGpsLayer;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Collection<GpsPoint> collection : this.data) {
            for (GpsPoint gpsPoint : collection) {
                boundingXYVisitor.visit(gpsPoint.eastNorth);
            }
        }
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Collection<GpsPoint> collection : this.data) {
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + I18n.trn("a track with {0} point", "a track with {0} points", collection.size(), collection.size()) + "<br>");
            n += collection.size();
        }
        stringBuilder.append("</html>");
        return "<html>" + I18n.trn("{0} consists of {1} track", "{0} consists of {1} tracks", this.data.size(), this.name, this.data.size()) + " (" + I18n.trn("{0} point", "{0} points", n, n) + ")<br>" + stringBuilder.toString();
    }

    @Override
    public Component[] getMenuEntries() {
        JMenuItem jMenuItem = new JMenuItem(I18n.tr("Customize line drawing"), ImageProvider.get("mapmode/addsegment"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton[] jRadioButtonArray = new JRadioButton[]{new JRadioButton(I18n.tr("Use global settings.")), new JRadioButton(I18n.tr("Draw lines between points for this layer.")), new JRadioButton(I18n.tr("Do not draw lines between points for this layer."))};
                ButtonGroup buttonGroup = new ButtonGroup();
                Box box = Box.createVerticalBox();
                for (JRadioButton jRadioButton : jRadioButtonArray) {
                    buttonGroup.add(jRadioButton);
                    box.add(jRadioButton);
                }
                String string = "draw.rawgps.lines.layer " + RawGpsLayer.this.name;
                if (Main.pref.hasKey(string)) {
                    buttonGroup.setSelected(jRadioButtonArray[Main.pref.getBoolean(string) ? 1 : 2].getModel(), true);
                } else {
                    buttonGroup.setSelected(jRadioButtonArray[0].getModel(), true);
                }
                int n = JOptionPane.showConfirmDialog(Main.parent, box, I18n.tr("Select line drawing options"), 2);
                if (n == 2) {
                    return;
                }
                if (buttonGroup.getSelection() == jRadioButtonArray[0].getModel()) {
                    Main.pref.put(string, null);
                } else {
                    Main.pref.put(string, buttonGroup.getSelection() == jRadioButtonArray[1].getModel());
                }
                Main.map.repaint();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(I18n.tr("Customize Color"), ImageProvider.get("colorchooser"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JColorChooser jColorChooser = new JColorChooser(Main.pref.getColor(I18n.marktr("gps point"), "layer " + RawGpsLayer.this.name, Color.gray));
                Object[] objectArray = new Object[]{I18n.tr("OK"), I18n.tr("Cancel"), I18n.tr("Default")};
                int n = JOptionPane.showOptionDialog(Main.parent, jColorChooser, I18n.tr("Choose a color"), 2, -1, null, objectArray, objectArray[0]);
                switch (n) {
                    case 0: {
                        Main.pref.putColor("layer " + RawGpsLayer.this.name, jColorChooser.getColor());
                        break;
                    }
                    case 1: {
                        return;
                    }
                    case 2: {
                        Main.pref.putColor("layer " + RawGpsLayer.this.name, null);
                    }
                }
                Main.map.repaint();
            }
        });
        if (Main.applet) {
            return new Component[]{new JMenuItem(new LayerListDialog.ShowHideLayerAction(this)), new JMenuItem(new LayerListDialog.DeleteLayerAction(this)), new JSeparator(), jMenuItem2, jMenuItem, new JMenuItem(new ConvertToDataLayerAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.associatedFile, this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
        }
        return new Component[]{new JMenuItem(new LayerListDialog.ShowHideLayerAction(this)), new JMenuItem(new LayerListDialog.DeleteLayerAction(this)), new JSeparator(), new JMenuItem(new GpxExportAction(this)), jMenuItem2, jMenuItem, new JMenuItem(new ConvertToDataLayerAction()), new JSeparator(), new JMenuItem(new RenameLayerAction(this.associatedFile, this)), new JSeparator(), new JMenuItem(new LayerListPopup.InfoAction(this))};
    }

    @Override
    public void preferenceChanged(String string, String string2) {
        if (Main.map != null && (string.equals("draw.rawgps.lines") || string.equals("draw.rawgps.lines.force"))) {
            Main.map.repaint();
        }
    }

    @Override
    public void destroy() {
        Main.pref.listener.remove(this);
    }

    public static class GpsPoint {
        public final LatLon latlon;
        public final EastNorth eastNorth;
        public final String time;

        public GpsPoint(LatLon latLon, String string) {
            this.latlon = latLon;
            this.eastNorth = Main.proj.latlon2eastNorth(latLon);
            this.time = string;
        }
    }

    public class ConvertToDataLayerAction
    extends AbstractAction {
        public ConvertToDataLayerAction() {
            super(I18n.tr("Convert to data layer"), ImageProvider.get("converttoosm"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:")), GBC.eol());
            jPanel.add((Component)new UrlLabel(I18n.tr("http://www.openstreetmap.org/traces")), GBC.eop());
            if (!DontShowAgainInfo.show("convert_to_data", jPanel)) {
                return;
            }
            DataSet dataSet = new DataSet();
            for (Collection<GpsPoint> collection : RawGpsLayer.this.data) {
                Way way = new Way();
                for (GpsPoint gpsPoint : collection) {
                    Node node = new Node(gpsPoint.latlon);
                    dataSet.nodes.add(node);
                    way.nodes.add(node);
                }
                dataSet.ways.add(way);
            }
            Main.main.addLayer(new OsmDataLayer(dataSet, I18n.tr("Converted from: {0}", RawGpsLayer.this.name), null));
            Main.main.removeLayer(RawGpsLayer.this);
        }
    }
}

