/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.AudioPlayer;

public class AudioMarker
extends ButtonMarker {
    private URL audioUrl;
    private static AudioMarker recentlyPlayedMarker = null;
    public double syncOffset;

    public static AudioMarker create(LatLon latLon, String string, String string2, MarkerLayer markerLayer, double d, double d2) {
        try {
            return new AudioMarker(latLon, string, new URL(string2), markerLayer, d, d2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private AudioMarker(LatLon latLon, String string, URL uRL, MarkerLayer markerLayer, double d, double d2) {
        super(latLon, string, "speech.png", markerLayer, d, d2);
        this.audioUrl = uRL;
        this.syncOffset = 0.0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.play();
    }

    public static AudioMarker recentlyPlayedMarker() {
        return recentlyPlayedMarker;
    }

    public URL url() {
        return this.audioUrl;
    }

    public void play(double d) {
        try {
            Main.map.mapView.playHeadMarker.animate();
            AudioPlayer.play(this.audioUrl, this.offset + this.syncOffset + d);
            recentlyPlayedMarker = this;
        }
        catch (Exception exception) {
            AudioPlayer.audioMalfunction(exception);
        }
    }

    public void play() {
        this.play(0.0);
    }

    public void adjustOffset(double d) {
        this.syncOffset = d;
    }

    public double syncOffset() {
        return this.syncOffset;
    }

    public static String inventName(double d) {
        int n = (int)(d + 0.5);
        if (n < 60) {
            return Integer.toString(n);
        }
        if (n < 3600) {
            return String.format("%d:%02d", n / 60, n % 60);
        }
        return String.format("%d:%02d:%02d", n / 3600, n % 3600 / 60, n % 60);
    }
}

