/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PresetTextComparator;

public class TaggingPresetMenu
extends TaggingPreset {
    public JMenu menu = null;

    public void setDisplayName() {
        String string = this.getName();
        this.putValue("Name", string);
        this.putValue("ShortDescription", I18n.tr("Preset group ''{0}''", string));
        this.putValue("toolbar", "tagginggroup_" + this.getRawName());
    }

    public void setIcon(String string) {
        super.setIcon(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.menu != null && object instanceof Component) {
            Component component = (Component)object;
            JPopupMenu jPopupMenu = new JPopupMenu(this.getName());
            for (Component component2 : this.menu.getMenuComponents()) {
                if (component2 instanceof JMenuItem) {
                    JMenuItem jMenuItem = new JMenuItem(((JMenuItem)component2).getAction());
                    jMenuItem.setText(((JMenuItem)component2).getText());
                    jPopupMenu.add(jMenuItem);
                    continue;
                }
                if (!(component2 instanceof JSeparator)) continue;
                jPopupMenu.addSeparator();
            }
            jPopupMenu.show(component, component.getWidth() / 2, component.getHeight() / 2);
        }
    }

    public void sortMenu() {
        TaggingPresetMenu.sortMenu(this.menu);
    }

    public static void sortMenu(JMenu jMenu) {
        Component[] componentArray = jMenu.getMenuComponents();
        PresetTextComparator presetTextComparator = new PresetTextComparator();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        int n = 0;
        for (int i = 0; i < componentArray.length; ++i) {
            int n2;
            int n3;
            Component component = componentArray[i];
            if (component instanceof JMenu) {
                TaggingPresetMenu.sortMenu((JMenu)component);
            }
            if (component instanceof JMenuItem) {
                arrayList.add((JMenuItem)component);
                if (i != componentArray.length - 1) continue;
                Collections.sort(arrayList, presetTextComparator);
                n3 = 0;
                for (JMenuItem jMenuItem : arrayList) {
                    n2 = n == 0 ? n3 : n3 + n + 1;
                    jMenu.add((Component)jMenuItem, n2);
                    ++n3;
                }
                arrayList = new ArrayList();
                n = 0;
                continue;
            }
            if (!(component instanceof JSeparator)) continue;
            Collections.sort(arrayList, presetTextComparator);
            n3 = 0;
            for (JMenuItem jMenuItem : arrayList) {
                n2 = n == 0 ? n3 : n3 + n + 1;
                jMenu.add((Component)jMenuItem, n2);
                ++n3;
            }
            arrayList = new ArrayList();
            n = i;
        }
    }
}

