/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.Hashtable;
import java.util.logging.Logger;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class MemoryTileCache
implements TileCache {
    protected static final Logger log = Logger.getLogger(MemoryTileCache.class.getName());
    protected int cacheSize = 200;
    protected Hashtable<String, CacheEntry> hashtable = new Hashtable(this.cacheSize);
    protected CacheLinkedListElement lruTiles = new CacheLinkedListElement();

    public void addTile(Tile tile) {
        CacheEntry cacheEntry = this.createCacheEntry(tile);
        this.hashtable.put(tile.getKey(), cacheEntry);
        this.lruTiles.addFirst(cacheEntry);
        if (this.hashtable.size() > this.cacheSize) {
            this.removeOldEntries();
        }
    }

    public Tile getTile(TileSource tileSource, int n, int n2, int n3) {
        CacheEntry cacheEntry = this.hashtable.get(Tile.getTileKey(tileSource, n, n2, n3));
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.tile.isLoaded()) {
            this.lruTiles.moveElementToFirstPos(cacheEntry);
        }
        return cacheEntry.tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOldEntries() {
        CacheLinkedListElement cacheLinkedListElement = this.lruTiles;
        synchronized (cacheLinkedListElement) {
            try {
                while (this.lruTiles.getElementCount() > this.cacheSize) {
                    this.removeEntry(this.lruTiles.getLastElement());
                }
            }
            catch (Exception exception) {
                log.warning(exception.getMessage());
            }
        }
    }

    protected void removeEntry(CacheEntry cacheEntry) {
        this.hashtable.remove(cacheEntry.tile.getKey());
        this.lruTiles.removeEntry(cacheEntry);
    }

    protected CacheEntry createCacheEntry(Tile tile) {
        return new CacheEntry(tile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CacheLinkedListElement cacheLinkedListElement = this.lruTiles;
        synchronized (cacheLinkedListElement) {
            this.hashtable.clear();
            this.lruTiles.clear();
        }
    }

    public int getTileCount() {
        return this.hashtable.size();
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
        if (this.hashtable.size() > n) {
            this.removeOldEntries();
        }
    }

    protected static class CacheLinkedListElement {
        protected CacheEntry firstElement = null;
        protected CacheEntry lastElement;
        protected int elementCount;

        public CacheLinkedListElement() {
            this.clear();
        }

        public synchronized void clear() {
            this.elementCount = 0;
            this.firstElement = null;
            this.lastElement = null;
        }

        public synchronized void addFirst(CacheEntry cacheEntry) {
            if (this.elementCount == 0) {
                this.firstElement = cacheEntry;
                this.lastElement = cacheEntry;
                cacheEntry.prev = null;
                cacheEntry.next = null;
            } else {
                cacheEntry.next = this.firstElement;
                this.firstElement.prev = cacheEntry;
                cacheEntry.prev = null;
                this.firstElement = cacheEntry;
            }
            ++this.elementCount;
        }

        public synchronized void removeEntry(CacheEntry cacheEntry) {
            if (cacheEntry.next != null) {
                cacheEntry.next.prev = cacheEntry.prev;
            }
            if (cacheEntry.prev != null) {
                cacheEntry.prev.next = cacheEntry.next;
            }
            if (cacheEntry == this.firstElement) {
                this.firstElement = cacheEntry.next;
            }
            if (cacheEntry == this.lastElement) {
                this.lastElement = cacheEntry.prev;
            }
            cacheEntry.next = null;
            cacheEntry.prev = null;
            --this.elementCount;
        }

        public synchronized void moveElementToFirstPos(CacheEntry cacheEntry) {
            if (this.firstElement == cacheEntry) {
                return;
            }
            this.removeEntry(cacheEntry);
            this.addFirst(cacheEntry);
        }

        public int getElementCount() {
            return this.elementCount;
        }

        public CacheEntry getLastElement() {
            return this.lastElement;
        }

        public CacheEntry getFirstElement() {
            return this.firstElement;
        }
    }

    protected static class CacheEntry {
        Tile tile;
        CacheEntry next;
        CacheEntry prev;

        protected CacheEntry(Tile tile) {
            this.tile = tile;
        }

        public Tile getTile() {
            return this.tile;
        }

        public CacheEntry getNext() {
            return this.next;
        }

        public CacheEntry getPrev() {
            return this.prev;
        }
    }
}

