/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TigerUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeNodesAction
extends JosmAction
implements SelectionChangedListener {
    public MergeNodesAction() {
        super(I18n.tr("Merge Nodes"), "mergenodes", I18n.tr("Merge nodes into the oldest one."), Shortcut.registerShortcut("tools:mergenodes", I18n.tr("Tool: {0}", I18n.tr("Merge Nodes")), 77, 3), true);
        DataSet.selListeners.add(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = Main.ds.getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (OsmPrimitive object : collection) {
            if (!(object instanceof Node)) continue;
            linkedList.add((Node)object);
        }
        if (linkedList.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two nodes to merge."));
            return;
        }
        Object object = null;
        for (Node node : linkedList) {
            if (node.id <= 0L) continue;
            object = node;
            break;
        }
        if (object == null) {
            object = (Node)linkedList.iterator().next();
        }
        MergeNodesAction.mergeNodes(linkedList, object);
    }

    /*
     * WARNING - void declaration
     */
    public static Node mergeNodes(LinkedList<Node> linkedList, Node node) {
        HashSet<Object> hashSet;
        Node node2 = new Node(node);
        HashMap<Pair<Relation, String>, HashSet> hashMap = new HashMap<Pair<Relation, String>, HashSet>();
        HashSet<Relation> hashSet2 = new HashSet<Relation>();
        for (Relation object2 : Main.ds.relations) {
            if (object2.deleted || object2.incomplete) continue;
            for (RelationMember relationMember : object2.members) {
                if (!(relationMember.member instanceof Node)) continue;
                for (Node node3 : linkedList) {
                    if (relationMember.member != node3) continue;
                    Pair<Relation, String> pair = new Pair<Relation, String>(object2, relationMember.role);
                    HashSet hashSet3 = new HashSet();
                    if (hashMap.containsKey(pair)) {
                        hashSet3 = (HashSet)hashMap.get(pair);
                    } else {
                        hashSet3 = new HashSet();
                        hashMap.put(pair, hashSet3);
                    }
                    hashSet3.add(node3);
                    hashSet2.add(object2);
                }
            }
        }
        for (HashSet hashSet4 : hashMap.values()) {
            if (hashSet4.containsAll(linkedList)) continue;
            int n = new ExtendedDialog(Main.parent, I18n.tr("Merge nodes with different memberships?"), I18n.tr("The selected nodes have differing relation memberships.  Do you still want to merge them?"), new String[]{I18n.tr("Merge Anyway"), I18n.tr("Cancel")}, new String[]{"mergenodes.png", "cancel.png"}).getValue();
            if (n == 1) break;
            return null;
        }
        TreeMap treeMap = new TreeMap();
        for (Node node4 : linkedList) {
            for (Map.Entry<String, String> entry : node4.entrySet()) {
                if (!treeMap.containsKey(entry.getKey())) {
                    treeMap.put(entry.getKey(), new TreeSet());
                }
                ((Set)treeMap.get(entry.getKey())).add(entry.getValue());
            }
        }
        HashMap hashMap2 = new HashMap();
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (Map.Entry entry : treeMap.entrySet()) {
            if (TigerUtils.isTigerTag((String)entry.getKey())) {
                String string = TigerUtils.combineTags((String)entry.getKey(), (Set)entry.getValue());
                node2.put((String)entry.getKey(), string);
                continue;
            }
            if (((Set)entry.getValue()).size() > 1) {
                if ("created_by".equals(entry.getKey())) {
                    node2.put("created_by", "JOSM");
                    continue;
                }
                JComboBox<Object> jComboBox = new JComboBox<Object>(((Set)entry.getValue()).toArray());
                jComboBox.setEditable(true);
                jPanel.add((Component)new JLabel((String)entry.getKey()), GBC.std());
                jPanel.add(Box.createHorizontalStrut(10), GBC.std());
                jPanel.add(jComboBox, GBC.eol());
                hashMap2.put(entry.getKey(), jComboBox);
                continue;
            }
            node2.put((String)entry.getKey(), (String)((Set)entry.getValue()).iterator().next());
        }
        if (!hashMap2.isEmpty()) {
            int n = new ExtendedDialog(Main.parent, I18n.tr("Enter values for all conflicts."), jPanel, new String[]{I18n.tr("Solve Conflicts"), I18n.tr("Cancel")}, new String[]{"dialogs/conflict.png", "cancel.png"}).getValue();
            if (n != 1) {
                return null;
            }
            for (Map.Entry entry : hashMap2.entrySet()) {
                node2.put((String)entry.getKey(), ((JComboBox)entry.getValue()).getEditor().getItem().toString());
            }
        }
        LinkedList<Command> linkedList2 = new LinkedList<Command>();
        linkedList2.add(new ChangeCommand(node, node2));
        HashSet<OsmPrimitive> hashSet5 = new HashSet<OsmPrimitive>();
        for (Way way : Main.ds.ways) {
            void var15_57;
            if (way.deleted || way.incomplete || way.nodes.size() < 1) continue;
            boolean bl = false;
            for (Node node5 : linkedList) {
                if (node5 == node || !way.nodes.contains(node5)) continue;
                bl = true;
            }
            if (!bl) continue;
            hashSet = new ArrayList();
            Object var14_49 = null;
            boolean bl2 = false;
            while (var15_57 < way.nodes.size()) {
                void var14_50;
                Node node6 = way.nodes.get((int)var15_57);
                if (linkedList.contains(node6)) {
                    node6 = node;
                }
                if (node6 != var14_50) {
                    ((ArrayList)((Object)hashSet)).add(node6);
                }
                Node node7 = node6;
                ++var15_57;
            }
            if (((ArrayList)((Object)hashSet)).size() < 2) {
                CollectBackReferencesVisitor collectBackReferencesVisitor = new CollectBackReferencesVisitor(Main.ds, false);
                way.visit(collectBackReferencesVisitor);
                if (!collectBackReferencesVisitor.data.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot merge nodes: Would have to delete a way that is still used."));
                    return null;
                }
                hashSet5.add(way);
                continue;
            }
            Way way2 = new Way(way);
            way2.nodes.clear();
            way2.nodes.addAll(hashSet);
            linkedList2.add(new ChangeCommand(way, way2));
        }
        hashSet5.addAll(linkedList);
        hashSet5.remove(node);
        if (!hashSet5.isEmpty()) {
            linkedList2.add(new DeleteCommand(hashSet5));
        }
        for (Relation relation : hashSet2) {
            Relation relation2 = new Relation(relation);
            relation2.members.clear();
            hashSet = new HashSet<Object>();
            for (RelationMember relationMember : relation.members) {
                if (linkedList.contains(relationMember.member)) {
                    hashSet.add(relationMember.role);
                    continue;
                }
                relation2.members.add(relationMember);
            }
            for (String string : hashSet) {
                relation2.members.add(new RelationMember(string, node));
            }
            linkedList2.add(new ChangeCommand(relation, relation2));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Merge {0} nodes", linkedList.size()), linkedList2));
        Main.ds.setSelected(node);
        return node;
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        boolean bl = true;
        if (collection.size() < 2) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) continue;
            bl = false;
            break;
        }
        this.setEnabled(bl);
    }
}

